/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.planner.physical;

import java.util.HashSet;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rex.RexOver;
import org.opensearch.sql.opensearch.storage.OpenSearchIndex;
import org.opensearch.sql.opensearch.storage.scan.AbstractCalciteIndexScan;

public interface OpenSearchIndexScanRule {
    public static boolean noAggregatePushed(AbstractCalciteIndexScan scan) {
        if (scan.getPushDownContext().isAggregatePushed()) {
            return false;
        }
        RelOptTable table = scan.getTable();
        return table.unwrap(OpenSearchIndex.class) != null;
    }

    public static boolean isLimitPushed(AbstractCalciteIndexScan scan) {
        return scan.getPushDownContext().isLimitPushed();
    }

    public static boolean distinctProjectList(LogicalProject project) {
        HashSet rexSet = new HashSet();
        return project.getProjects().stream().allMatch(rexSet::add);
    }

    public static boolean containsRexOver(LogicalProject project) {
        return project.getProjects().stream().anyMatch(RexOver::containsOver);
    }

    public static boolean isLogicalSortLimit(LogicalSort sort) {
        return sort.fetch != null;
    }

    public static boolean sortByFieldsOnly(Sort sort) {
        return !sort.getCollation().getFieldCollations().isEmpty() && sort.fetch == null;
    }
}

