/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprCollectionValue;
import org.opensearch.sql.data.model.ExprDoubleValue;
import org.opensearch.sql.data.model.ExprIntegerValue;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprTupleValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.exception.SemanticCheckException;

public final class JsonUtils {
    public static ExprValue isValidJson(ExprValue jsonExprValue) {
        ObjectMapper objectMapper = new ObjectMapper();
        if (jsonExprValue.isNull() || jsonExprValue.isMissing()) {
            return ExprValueUtils.LITERAL_FALSE;
        }
        try {
            objectMapper.readTree(jsonExprValue.stringValue());
            return ExprValueUtils.LITERAL_TRUE;
        }
        catch (JsonProcessingException e) {
            return ExprValueUtils.LITERAL_FALSE;
        }
    }

    public static ExprValue castJson(ExprValue json) {
        JsonNode jsonNode;
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            jsonNode = objectMapper.readTree(json.stringValue());
        }
        catch (JsonProcessingException e) {
            String errorFormat = "JSON string '%s' is not valid. Error details: %s";
            throw new SemanticCheckException(String.format("JSON string '%s' is not valid. Error details: %s", json, e.getMessage()), e);
        }
        return JsonUtils.processJsonNode(jsonNode);
    }

    private static ExprValue processJsonNode(JsonNode jsonNode2) {
        switch (jsonNode2.getNodeType()) {
            case ARRAY: {
                LinkedList<ExprValue> elements = new LinkedList<ExprValue>();
                for (JsonNode jsonNode2 : jsonNode2) {
                    elements.add(JsonUtils.processJsonNode(jsonNode2));
                }
                return new ExprCollectionValue(elements);
            }
            case OBJECT: {
                LinkedHashMap<String, ExprValue> values = new LinkedHashMap<String, ExprValue>();
                Iterator iter = jsonNode2.fields();
                while (iter.hasNext()) {
                    Map.Entry entry = (Map.Entry)iter.next();
                    values.put((String)entry.getKey(), JsonUtils.processJsonNode((JsonNode)entry.getValue()));
                }
                return ExprTupleValue.fromExprValueMap(values);
            }
            case STRING: {
                return new ExprStringValue(jsonNode2.asText());
            }
            case NUMBER: {
                if (jsonNode2.isFloatingPointNumber()) {
                    return new ExprDoubleValue(jsonNode2.asDouble());
                }
                return new ExprIntegerValue(jsonNode2.asLong());
            }
            case BOOLEAN: {
                return jsonNode2.asBoolean() ? ExprValueUtils.LITERAL_TRUE : ExprValueUtils.LITERAL_FALSE;
            }
        }
        return ExprValueUtils.LITERAL_NULL;
    }

    @Generated
    private JsonUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

