/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.singlebyte.ModifiableByte;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.protocol.handler.HelloVerifyRequestHandler;
import de.rub.nds.tlsattacker.core.protocol.handler.ProtocolMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class HelloVerifyRequestMessage
extends HandshakeMessage {
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.TLS_CONSTANT)
    private ModifiableByteArray protocolVersion = null;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableByte cookieLength = null;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.COOKIE)
    private ModifiableByteArray cookie = null;

    public HelloVerifyRequestMessage() {
        super(HandshakeMessageType.HELLO_VERIFY_REQUEST);
        this.IS_INCLUDE_IN_DIGEST_DEFAULT = false;
    }

    public HelloVerifyRequestMessage(Config tlsConfig) {
        super(tlsConfig, HandshakeMessageType.HELLO_VERIFY_REQUEST);
        this.IS_INCLUDE_IN_DIGEST_DEFAULT = false;
    }

    public ModifiableByteArray getProtocolVersion() {
        return this.protocolVersion;
    }

    public ModifiableByteArray getCookie() {
        return this.cookie;
    }

    public ModifiableByte getCookieLength() {
        return this.cookieLength;
    }

    public void setProtocolVersion(byte[] protocolVersion) {
        this.protocolVersion = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.protocolVersion, (byte[])protocolVersion);
    }

    public void setProtocolVersion(ModifiableByteArray protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public void setCookie(byte[] cookie) {
        this.cookie = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.cookie, (byte[])cookie);
    }

    public void setCookie(ModifiableByteArray cookie) {
        this.cookie = cookie;
    }

    public void setCookieLength(byte cookieLength) {
        this.cookieLength = ModifiableVariableFactory.safelySetValue((ModifiableByte)this.cookieLength, (Byte)cookieLength);
    }

    public void setCookieLength(ModifiableByte cookieLength) {
        this.cookieLength = cookieLength;
    }

    @Override
    public ProtocolMessageHandler getHandler(TlsContext context) {
        return new HelloVerifyRequestHandler(context);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HelloVerifyRequestMessage:");
        sb.append("\n  ProtocolVersion: ");
        if (this.protocolVersion != null && this.protocolVersion.getValue() != null) {
            sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.protocolVersion.getValue())));
        } else {
            sb.append("null");
        }
        sb.append("\n  Cookie Length: ");
        if (this.cookieLength != null && this.cookieLength.getValue() != null) {
            sb.append(this.cookieLength.getValue());
        } else {
            sb.append("null");
        }
        sb.append("\n  Cookie: ");
        if (this.cookie != null && this.cookie.getValue() != null) {
            sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.cookie.getValue())));
        } else {
            sb.append("null");
        }
        return sb.toString();
    }
}

