/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.PrintStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.exslt.Common;
import net.sf.saxon.exslt.Date;
import net.sf.saxon.exslt.Math;
import net.sf.saxon.exslt.Random;
import net.sf.saxon.exslt.Sets;
import net.sf.saxon.functions.Collection;
import net.sf.saxon.functions.CompileTimeFunction;
import net.sf.saxon.functions.ExtensionFunctionCall;
import net.sf.saxon.functions.Extensions;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.JavaExtensionFunctionFactory;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.value.Value;

public class JavaExtensionLibrary
implements FunctionLibrary {
    private Configuration config;
    private HashMap explicitMappings = new HashMap(10);
    private transient PrintStream diag = System.err;
    private boolean strictUriFormat = false;
    private static final Class[] NO_PARAMS = new Class[0];

    public JavaExtensionLibrary(Configuration config) {
        this.config = config;
        this.setDefaultURIMappings();
    }

    protected void setDefaultURIMappings() {
        this.declareJavaClass("http://saxon.sf.net/", Extensions.class);
        this.declareJavaClass("http://exslt.org/common", Common.class);
        this.declareJavaClass("http://exslt.org/sets", Sets.class);
        this.declareJavaClass("http://exslt.org/math", Math.class);
        this.declareJavaClass("http://exslt.org/dates-and-times", Date.class);
        this.declareJavaClass("http://exslt.org/random", Random.class);
    }

    public void setStrictJavaUriFormat(boolean strict) {
        this.strictUriFormat = strict;
    }

    public void declareJavaClass(String uri, Class theClass) {
        this.explicitMappings.put(uri, theClass);
    }

    public boolean isAvailable(StructuredQName functionName, int arity) {
        int significantArgs;
        boolean isStatic;
        Class reqClass;
        if (!this.config.isAllowExternalFunctions()) {
            return false;
        }
        try {
            reqClass = this.getExternalJavaClass(functionName.getNamespaceURI());
            if (reqClass == null) {
                return false;
            }
        }
        catch (Exception err) {
            return false;
        }
        Class theClass = reqClass;
        String local = functionName.getLocalName();
        if ("new".equals(local)) {
            int mod = theClass.getModifiers();
            if (Modifier.isAbstract(mod)) {
                return false;
            }
            if (Modifier.isInterface(mod)) {
                return false;
            }
            if (Modifier.isPrivate(mod)) {
                return false;
            }
            if (Modifier.isProtected(mod)) {
                return false;
            }
            if (arity == -1) {
                return true;
            }
            Constructor<?>[] constructors = theClass.getConstructors();
            for (int c = 0; c < constructors.length; ++c) {
                Constructor<?> theConstructor = constructors[c];
                if (theConstructor.getParameterTypes().length != arity) continue;
                return true;
            }
            return false;
        }
        String name = ExtensionFunctionCall.toCamelCase(local, false, this.diag);
        Method[] methods = theClass.getMethods();
        for (int m = 0; m < methods.length; ++m) {
            Method theMethod = methods[m];
            if (!theMethod.getName().equals(name) || !Modifier.isPublic(theMethod.getModifiers())) continue;
            if (arity == -1) {
                return true;
            }
            Class<?>[] theParameterTypes = theMethod.getParameterTypes();
            isStatic = Modifier.isStatic(theMethod.getModifiers());
            int n = significantArgs = isStatic ? arity : arity - 1;
            if (significantArgs < 0) continue;
            if (theParameterTypes.length == significantArgs && (significantArgs == 0 || theParameterTypes[0] != (class$net$sf$saxon$expr$XPathContext == null ? JavaExtensionLibrary.class$("net.sf.saxon.expr.XPathContext") : class$net$sf$saxon$expr$XPathContext))) {
                return true;
            }
            if (theParameterTypes.length != significantArgs + 1 || theParameterTypes[0] != (class$net$sf$saxon$expr$XPathContext == null ? JavaExtensionLibrary.class$("net.sf.saxon.expr.XPathContext") : class$net$sf$saxon$expr$XPathContext)) continue;
            return true;
        }
        Field[] fields = theClass.getFields();
        for (int m = 0; m < fields.length; ++m) {
            Field theField = fields[m];
            if (!theField.getName().equals(name) || !Modifier.isPublic(theField.getModifiers())) continue;
            if (arity == -1) {
                return true;
            }
            isStatic = Modifier.isStatic(theField.getModifiers());
            int n = significantArgs = isStatic ? arity : arity - 1;
            if (significantArgs != 0) continue;
            return true;
        }
        return false;
    }

    public Expression bind(StructuredQName functionName, Expression[] staticArgs, StaticContext env) throws XPathException {
        Class reqClass;
        boolean debug = this.config.isTraceExternalFunctions();
        if (!this.config.isAllowExternalFunctions()) {
            if (debug) {
                this.diag.println("Calls to extension functions have been disabled");
            }
            return null;
        }
        XPathException theException = null;
        ArrayList<AccessibleObject> candidateMethods = new ArrayList<AccessibleObject>(10);
        Class<?> resultClass = null;
        try {
            reqClass = this.getExternalJavaClass(functionName.getNamespaceURI());
            if (reqClass == null) {
                return null;
            }
        }
        catch (Exception err) {
            throw new XPathException("Cannot load external Java class", err);
        }
        if (debug) {
            this.diag.println("Looking for method " + functionName.getLocalName() + " in Java class " + reqClass);
            this.diag.println("Number of actual arguments = " + staticArgs.length);
        }
        int numArgs = staticArgs.length;
        Class theClass = reqClass;
        if ("new".equals(functionName.getLocalName())) {
            int mod;
            if (debug) {
                this.diag.println("Looking for a constructor");
            }
            if (Modifier.isAbstract(mod = theClass.getModifiers())) {
                theException = new XPathException("Class " + theClass + " is abstract");
            } else if (Modifier.isInterface(mod)) {
                theException = new XPathException(theClass + " is an interface");
            } else if (Modifier.isPrivate(mod)) {
                theException = new XPathException("Class " + theClass + " is private");
            } else if (Modifier.isProtected(mod)) {
                theException = new XPathException("Class " + theClass + " is protected");
            }
            if (theException != null) {
                if (debug) {
                    this.diag.println("Cannot construct an instance: " + theException.getMessage());
                }
                return null;
            }
            Constructor<?>[] constructors = theClass.getConstructors();
            for (int c = 0; c < constructors.length; ++c) {
                Constructor<?> theConstructor = constructors[c];
                if (debug) {
                    this.diag.println("Found a constructor with " + theConstructor.getParameterTypes().length + " arguments");
                }
                if (theConstructor.getParameterTypes().length != numArgs) continue;
                candidateMethods.add(theConstructor);
            }
            if (candidateMethods.isEmpty()) {
                theException = new XPathException("No constructor with " + numArgs + (numArgs == 1 ? " parameter" : " parameters") + " found in class " + theClass.getName());
                if (debug) {
                    this.diag.println(theException.getMessage());
                }
                return null;
            }
        } else {
            int significantArgs;
            boolean isStatic;
            String name = ExtensionFunctionCall.toCamelCase(functionName.getLocalName(), debug, this.diag);
            Method[] methods = theClass.getMethods();
            boolean consistentReturnType = true;
            for (int m = 0; m < methods.length; ++m) {
                Method theMethod = methods[m];
                if (debug) {
                    if (theMethod.getName().equals(name)) {
                        this.diag.println("Trying method " + theMethod.getName() + ": name matches");
                        if (!Modifier.isPublic(theMethod.getModifiers())) {
                            this.diag.println(" -- but the method is not public");
                        }
                    } else {
                        this.diag.println("Trying method " + theMethod.getName() + ": name does not match");
                    }
                }
                if (!theMethod.getName().equals(name) || !Modifier.isPublic(theMethod.getModifiers())) continue;
                if (consistentReturnType) {
                    if (resultClass == null) {
                        resultClass = theMethod.getReturnType();
                    } else {
                        consistentReturnType = theMethod.getReturnType() == resultClass;
                    }
                }
                Class<?>[] theParameterTypes = theMethod.getParameterTypes();
                isStatic = Modifier.isStatic(theMethod.getModifiers());
                if (debug) {
                    this.diag.println("Method is " + (isStatic ? "" : "not ") + "static");
                }
                int n = significantArgs = isStatic ? numArgs : numArgs - 1;
                if (significantArgs < 0) continue;
                if (debug) {
                    if (isStatic) {
                        this.diag.println("Method has " + theParameterTypes.length + " argument" + (theParameterTypes.length == 1 ? "" : "s") + "; expecting " + significantArgs);
                    } else {
                        this.diag.println("Method has " + theParameterTypes.length + " argument" + (theParameterTypes.length == 1 ? "" : "s") + "; expecting " + numArgs + " plus one for the target object");
                    }
                }
                if (theParameterTypes.length == significantArgs && (significantArgs == 0 || theParameterTypes[0] != (class$net$sf$saxon$expr$XPathContext == null ? JavaExtensionLibrary.class$("net.sf.saxon.expr.XPathContext") : class$net$sf$saxon$expr$XPathContext))) {
                    if (debug) {
                        this.diag.println("Found a candidate method:");
                        this.diag.println("    " + theMethod);
                    }
                    candidateMethods.add(theMethod);
                }
                if (theParameterTypes.length != significantArgs + 1 || theParameterTypes[0] != (class$net$sf$saxon$expr$XPathContext == null ? JavaExtensionLibrary.class$("net.sf.saxon.expr.XPathContext") : class$net$sf$saxon$expr$XPathContext)) continue;
                if (debug) {
                    this.diag.println("Method is a candidate because first argument is XPathContext");
                }
                candidateMethods.add(theMethod);
            }
            Field[] fields = theClass.getFields();
            for (int m = 0; m < fields.length; ++m) {
                Field theField = fields[m];
                if (debug) {
                    if (theField.getName().equals(name)) {
                        this.diag.println("Trying field " + theField.getName() + ": name matches");
                        if (!Modifier.isPublic(theField.getModifiers())) {
                            this.diag.println(" -- but the field is not public");
                        }
                    } else {
                        this.diag.println("Trying field " + theField.getName() + ": name does not match");
                    }
                }
                if (!theField.getName().equals(name) || !Modifier.isPublic(theField.getModifiers())) continue;
                if (consistentReturnType) {
                    if (resultClass == null) {
                        resultClass = theField.getType();
                    } else {
                        consistentReturnType = theField.getType() == resultClass;
                    }
                }
                isStatic = Modifier.isStatic(theField.getModifiers());
                if (debug) {
                    this.diag.println("Field is " + (isStatic ? "" : "not ") + "static");
                }
                int n = significantArgs = isStatic ? numArgs : numArgs - 1;
                if (significantArgs != 0) continue;
                if (debug) {
                    this.diag.println("Found a candidate field:");
                    this.diag.println("    " + theField);
                }
                candidateMethods.add(theField);
            }
            if (candidateMethods.isEmpty()) {
                theException = new XPathException("No method or field matching " + name + " with " + numArgs + (numArgs == 1 ? " parameter" : " parameters") + " found in class " + theClass.getName());
                if (debug) {
                    this.diag.println(theException.getMessage());
                }
                return null;
            }
        }
        if (candidateMethods.isEmpty()) {
            if (debug) {
                this.diag.println("There is no suitable method matching the arguments of function " + functionName.getLocalName());
            }
            return null;
        }
        AccessibleObject method = this.getBestFit(candidateMethods, staticArgs, theClass);
        if (method == null) {
            if (candidateMethods.size() > 1) {
                return new UnresolvedExtensionFunction(functionName, theClass, candidateMethods, staticArgs);
            }
            return null;
        }
        JavaExtensionFunctionFactory factory = (JavaExtensionFunctionFactory)this.config.getExtensionFunctionFactory("java");
        return factory.makeExtensionFunctionCall(functionName, theClass, method, staticArgs);
    }

    private AccessibleObject getBestFit(List candidateMethods, Expression[] args, Class theClass) {
        int[] pref_i;
        int i;
        boolean debug = this.config.isTraceExternalFunctions();
        int candidates = candidateMethods.size();
        if (candidates == 1) {
            return (AccessibleObject)candidateMethods.get(0);
        }
        if (debug) {
            this.diag.println("Finding best fit method for arguments");
        }
        boolean[] eliminated = new boolean[candidates];
        for (i = 0; i < candidates; ++i) {
            eliminated[i] = false;
        }
        if (debug) {
            for (i = 0; i < candidates; ++i) {
                pref_i = this.getConversionPreferences(args, (AccessibleObject)candidateMethods.get(i), theClass);
                this.diag.println("Trying option " + i + ": " + candidateMethods.get(i).toString());
                if (pref_i == null) {
                    this.diag.println("Arguments cannot be converted to required types");
                    continue;
                }
                String prefs = "[";
                for (int p = 0; p < pref_i.length; ++p) {
                    if (p != 0) {
                        prefs = prefs + ", ";
                    }
                    prefs = prefs + pref_i[p];
                }
                prefs = prefs + "]";
                this.diag.println("Conversion preferences are " + prefs);
            }
        }
        for (i = 0; i < candidates; ++i) {
            pref_i = this.getConversionPreferences(args, (AccessibleObject)candidateMethods.get(i), theClass);
            if (pref_i == null) {
                eliminated[i] = true;
            }
            if (eliminated[i]) continue;
            for (int j = i + 1; j < candidates; ++j) {
                if (eliminated[j]) continue;
                int[] pref_j = this.getConversionPreferences(args, (AccessibleObject)candidateMethods.get(j), theClass);
                if (pref_j == null) {
                    eliminated[j] = true;
                    continue;
                }
                for (int k = 0; k < pref_j.length; ++k) {
                    if (pref_i[k] > pref_j[k] && !eliminated[i]) {
                        eliminated[i] = true;
                        if (debug) {
                            this.diag.println("Eliminating option " + i);
                        }
                    }
                    if (pref_i[k] >= pref_j[k] || eliminated[j]) continue;
                    eliminated[j] = true;
                    if (!debug) continue;
                    this.diag.println("Eliminating option " + j);
                }
            }
        }
        int remaining = 0;
        AccessibleObject theMethod = null;
        for (int r = 0; r < candidates; ++r) {
            if (eliminated[r]) continue;
            theMethod = (AccessibleObject)candidateMethods.get(r);
            ++remaining;
        }
        if (debug) {
            this.diag.println("Number of candidate methods remaining: " + remaining);
        }
        if (remaining == 0) {
            if (debug) {
                this.diag.println("There are " + candidates + " candidate Java methods matching the function name, but none is a unique best match");
            }
            return null;
        }
        if (remaining > 1) {
            if (debug) {
                this.diag.println("There are several Java methods that match the function name equally well");
            }
            return null;
        }
        return theMethod;
    }

    private int[] getConversionPreferences(Expression[] args, AccessibleObject method, Class theClass) {
        boolean isStatic;
        Class<?>[] params;
        int firstArg;
        TypeHierarchy th = this.config.getTypeHierarchy();
        if (method instanceof Constructor) {
            firstArg = 0;
            params = ((Constructor)method).getParameterTypes();
        } else if (method instanceof Method) {
            isStatic = Modifier.isStatic(((Method)method).getModifiers());
            firstArg = isStatic ? 0 : 1;
            params = ((Method)method).getParameterTypes();
        } else if (method instanceof Field) {
            isStatic = Modifier.isStatic(((Field)method).getModifiers());
            firstArg = isStatic ? 0 : 1;
            params = NO_PARAMS;
        } else {
            throw new AssertionError((Object)("property " + method + " was neither constructor, method, nor field"));
        }
        int noOfArgs = args.length;
        int[] preferences = new int[noOfArgs];
        int firstParam = 0;
        if (params.length > 0 && params[0] == XPathContext.class) {
            firstParam = 1;
        }
        for (int i = firstArg; i < noOfArgs; ++i) {
            preferences[i] = this.getConversionPreference(th, args[i], params[i + firstParam - firstArg]);
            if (preferences[i] != -1) continue;
            return null;
        }
        if (firstArg == 1) {
            preferences[0] = this.getConversionPreference(th, args[0], theClass);
            if (preferences[0] == -1) {
                return null;
            }
        }
        return preferences;
    }

    private int getConversionPreference(TypeHierarchy th, Expression arg, Class required) {
        ItemType itemType = arg.getItemType(th);
        int cardinality = arg.getCardinality();
        if (required == Object.class) {
            return 100;
        }
        if (Cardinality.allowsMany(cardinality)) {
            if (required.isAssignableFrom(SequenceIterator.class)) {
                return 20;
            }
            if (required.isAssignableFrom(Value.class)) {
                return 21;
            }
            if (Collection.class.isAssignableFrom(required)) {
                return 22;
            }
            if (required.isArray()) {
                return 24;
            }
            return 80;
        }
        if (Type.isNodeType(itemType)) {
            if (required.isAssignableFrom(NodeInfo.class)) {
                return 20;
            }
            if (required.isAssignableFrom(DocumentInfo.class)) {
                return 21;
            }
            return 80;
        }
        if (itemType instanceof ExternalObjectType) {
            Class ext = ((ExternalObjectType)itemType).getJavaClass();
            if (required.isAssignableFrom(ext)) {
                return 10;
            }
            return -1;
        }
        int primitiveType = itemType.getPrimitiveType();
        return this.atomicConversionPreference(primitiveType, required);
    }

    protected int atomicConversionPreference(int primitiveType, Class required) {
        if (required == Object.class) {
            return 100;
        }
        switch (primitiveType) {
            case 513: {
                if (required.isAssignableFrom(StringValue.class)) {
                    return 50;
                }
                if (required == String.class) {
                    return 51;
                }
                if (required == CharSequence.class) {
                    return 51;
                }
                return -1;
            }
            case 517: {
                if (required.isAssignableFrom(DoubleValue.class)) {
                    return 50;
                }
                if (required == Double.TYPE) {
                    return 50;
                }
                if (required == Double.class) {
                    return 51;
                }
                return -1;
            }
            case 516: {
                if (required.isAssignableFrom(FloatValue.class)) {
                    return 50;
                }
                if (required == Float.TYPE) {
                    return 50;
                }
                if (required == Float.class) {
                    return 51;
                }
                if (required == Double.TYPE) {
                    return 52;
                }
                if (required == Double.class) {
                    return 53;
                }
                return -1;
            }
            case 515: {
                if (required.isAssignableFrom(DecimalValue.class)) {
                    return 50;
                }
                if (required == BigDecimal.class) {
                    return 50;
                }
                if (required == Double.TYPE) {
                    return 51;
                }
                if (required == Double.class) {
                    return 52;
                }
                if (required == Float.TYPE) {
                    return 53;
                }
                if (required == Float.class) {
                    return 54;
                }
                return -1;
            }
            case 532: {
                if (required.isAssignableFrom(Int64Value.class)) {
                    return 50;
                }
                if (required == BigInteger.class) {
                    return 51;
                }
                if (required == BigDecimal.class) {
                    return 52;
                }
                if (required == Long.TYPE) {
                    return 53;
                }
                if (required == Long.class) {
                    return 54;
                }
                if (required == Integer.TYPE) {
                    return 55;
                }
                if (required == Integer.class) {
                    return 56;
                }
                if (required == Short.TYPE) {
                    return 57;
                }
                if (required == Short.class) {
                    return 58;
                }
                if (required == Byte.TYPE) {
                    return 59;
                }
                if (required == Byte.class) {
                    return 60;
                }
                if (required == Double.TYPE) {
                    return 61;
                }
                if (required == Double.class) {
                    return 62;
                }
                if (required == Float.TYPE) {
                    return 63;
                }
                if (required == Float.class) {
                    return 64;
                }
                return -1;
            }
            case 514: {
                if (required.isAssignableFrom(BooleanValue.class)) {
                    return 50;
                }
                if (required == Boolean.TYPE) {
                    return 51;
                }
                if (required == Boolean.class) {
                    return 52;
                }
                return -1;
            }
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: {
                if (required.isAssignableFrom(DateValue.class)) {
                    return 50;
                }
                if (required.isAssignableFrom(java.util.Date.class)) {
                    return 51;
                }
                return -1;
            }
            case 519: {
                if (required.isAssignableFrom(DateTimeValue.class)) {
                    return 50;
                }
                if (required.isAssignableFrom(java.util.Date.class)) {
                    return 51;
                }
                return -1;
            }
            case 520: {
                if (required.isAssignableFrom(TimeValue.class)) {
                    return 50;
                }
                return -1;
            }
            case 518: 
            case 633: 
            case 634: {
                if (required.isAssignableFrom(DurationValue.class)) {
                    return 50;
                }
                return -1;
            }
            case 529: {
                if (required.isAssignableFrom(AnyURIValue.class)) {
                    return 50;
                }
                if (required == URI.class) {
                    return 51;
                }
                if (required == URL.class) {
                    return 52;
                }
                if (required == String.class) {
                    return 53;
                }
                if (required == CharSequence.class) {
                    return 53;
                }
                return -1;
            }
            case 530: {
                if (required.isAssignableFrom(QualifiedNameValue.class)) {
                    return 50;
                }
                if (required.getClass().getName().equals("javax.xml.namespace.QName")) {
                    return 51;
                }
                return -1;
            }
            case 528: {
                if (required.isAssignableFrom(Base64BinaryValue.class)) {
                    return 50;
                }
                return -1;
            }
            case 527: {
                if (required.isAssignableFrom(HexBinaryValue.class)) {
                    return 50;
                }
                return -1;
            }
            case 631: {
                return 50;
            }
        }
        return -1;
    }

    private Class getExternalJavaClass(String uri) {
        Class c = (Class)this.explicitMappings.get(uri);
        if (c != null) {
            return c;
        }
        try {
            if (uri.startsWith("java:")) {
                return this.config.getClass(uri.substring(5), this.config.isTraceExternalFunctions(), null);
            }
            if (this.strictUriFormat) {
                return null;
            }
            int slash = uri.lastIndexOf(47);
            if (slash < 0) {
                return this.config.getClass(uri, this.config.isTraceExternalFunctions(), null);
            }
            if (slash == uri.length() - 1) {
                return null;
            }
            return this.config.getClass(uri.substring(slash + 1), this.config.isTraceExternalFunctions(), null);
        }
        catch (XPathException err) {
            return null;
        }
    }

    public FunctionLibrary copy() {
        JavaExtensionLibrary jel = new JavaExtensionLibrary(this.config);
        jel.explicitMappings = new HashMap(this.explicitMappings);
        jel.diag = this.diag;
        return jel;
    }

    private class UnresolvedExtensionFunction
    extends CompileTimeFunction {
        private List candidateMethods;
        private StructuredQName functionName;
        private Class theClass;

        public UnresolvedExtensionFunction(StructuredQName functionName, Class theClass, List candidateMethods, Expression[] staticArgs) {
            this.setArguments(staticArgs);
            this.functionName = functionName;
            this.theClass = theClass;
            this.candidateMethods = candidateMethods;
        }

        public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
            for (int i = 0; i < this.argument.length; ++i) {
                Expression exp = visitor.typeCheck(this.argument[i], contextItemType);
                if (exp == this.argument[i]) continue;
                this.adoptChildExpression(exp);
                this.argument[i] = exp;
            }
            AccessibleObject method = JavaExtensionLibrary.this.getBestFit(this.candidateMethods, this.argument, this.theClass);
            if (method == null) {
                XPathException err = new XPathException("There is more than one method matching the function call " + this.functionName.getDisplayName() + ", and there is insufficient type information to determine which one should be used");
                err.setLocator(this);
                throw err;
            }
            JavaExtensionFunctionFactory factory = (JavaExtensionFunctionFactory)JavaExtensionLibrary.this.config.getExtensionFunctionFactory("java");
            Expression call = factory.makeExtensionFunctionCall(this.functionName, this.theClass, method, this.argument);
            ExpressionTool.copyLocationInfo(this, call);
            return call.typeCheck(visitor, contextItemType);
        }
    }
}

