/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.entity.internal.EntityInitializerImpl;

public final class InitializersList {
    private final Initializer<?>[] initializers;
    private final Initializer<?>[] sortedForResolveInstance;
    private final boolean hasCollectionInitializers;

    private InitializersList(Initializer<?>[] initializers, Initializer<?>[] sortedForResolveInstance, boolean hasCollectionInitializers) {
        this.initializers = initializers;
        this.sortedForResolveInstance = sortedForResolveInstance;
        this.hasCollectionInitializers = hasCollectionInitializers;
    }

    public Initializer<?>[] getInitializers() {
        return this.initializers;
    }

    public Initializer<?>[] getSortedForResolveInstance() {
        return this.sortedForResolveInstance;
    }

    @Deprecated
    public List<Initializer<?>> asList() {
        return Arrays.asList(this.initializers);
    }

    public int size() {
        return this.initializers.length;
    }

    public static class Builder {
        private final ArrayList<Initializer<?>> initializers;
        int nonCollectionInitializersNum = 0;
        int resolveFirstNum = 0;

        public Builder() {
            this.initializers = new ArrayList();
        }

        public Builder(int size) {
            this.initializers = new ArrayList(size);
        }

        public void addInitializer(Initializer<?> initializer) {
            this.initializers.add(initializer);
            if (!initializer.isCollectionInitializer()) {
                ++this.nonCollectionInitializersNum;
            }
            if (Builder.initializeFirst(initializer)) {
                ++this.resolveFirstNum;
            }
        }

        private static boolean initializeFirst(Initializer<?> initializer) {
            return initializer instanceof EntityInitializerImpl;
        }

        public InitializersList build() {
            Initializer<?>[] originalSortInitializers;
            int size = this.initializers.size();
            Initializer[] sortedForResolveInstance = new Initializer[size];
            int resolveFirstIdx = 0;
            int resolveLaterIdx = this.resolveFirstNum;
            for (Initializer<?> initializer : originalSortInitializers = this.toArray(this.initializers)) {
                if (Builder.initializeFirst(initializer)) {
                    sortedForResolveInstance[resolveFirstIdx++] = initializer;
                    continue;
                }
                sortedForResolveInstance[resolveLaterIdx++] = initializer;
            }
            boolean hasCollectionInitializers = this.nonCollectionInitializersNum != this.initializers.size();
            return new InitializersList(originalSortInitializers, sortedForResolveInstance, hasCollectionInitializers);
        }

        private Initializer<?>[] toArray(ArrayList<Initializer<?>> initializers) {
            return initializers.toArray(new Initializer[initializers.size()]);
        }
    }
}

