/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.update.rewrite;

import io.quarkus.bootstrap.resolver.maven.options.BootstrapMavenOptions;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.update.rewrite.QuarkusUpdateException;
import io.quarkus.devtools.project.update.rewrite.QuarkusUpdateExitErrorException;
import io.quarkus.qute.Qute;
import io.smallrye.common.os.OS;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class QuarkusUpdateCommand {
    public static final String MAVEN_REWRITE_PLUGIN_GROUP = "org.openrewrite.maven";
    public static final String MAVEN_REWRITE_PLUGIN_ARTIFACT = "rewrite-maven-plugin";
    public static Set<String> ADDITIONAL_SOURCE_FILES_SET = Set.of("**/META-INF/services/**", "**/*.txt", "**/*.adoc", "**/*.md", "**/src/main/codestarts/**/*.java", "**/src/test/resources/__snapshots__/**/*.java", "**/*.kt");
    public static String ADDITIONAL_SOURCE_FILES = String.join((CharSequence)",", ADDITIONAL_SOURCE_FILES_SET);

    public static String goal(boolean dryRun) {
        return dryRun ? "dryRun" : "run";
    }

    public static void handle(MessageWriter log, BuildTool buildTool, Path baseDir, String rewritePluginVersion, String recipesGAV, Path recipe, Path logFile, boolean dryRun) {
        switch (buildTool) {
            case MAVEN: {
                QuarkusUpdateCommand.runMavenUpdate(log, baseDir, rewritePluginVersion, recipesGAV, recipe, logFile, dryRun);
                break;
            }
            case GRADLE: {
                QuarkusUpdateCommand.runGradleUpdate(log, baseDir, rewritePluginVersion, recipesGAV, recipe, logFile, dryRun);
                break;
            }
            default: {
                throw new QuarkusUpdateException(buildTool.getKey() + " is not supported yet");
            }
        }
    }

    private static void runMavenUpdate(MessageWriter log, Path baseDir, String rewritePluginVersion, String recipesGAV, Path recipe, Path logFile, boolean dryRun) {
        String mvnBinary = QuarkusUpdateCommand.findMvnBinary(baseDir);
        LinkedHashMap<String, List<String>> commands = new LinkedHashMap<String, List<String>>();
        commands.put(QuarkusUpdateCommand.getRewriteCommandName(rewritePluginVersion, dryRun), QuarkusUpdateCommand.getMavenUpdateCommand(mvnBinary, rewritePluginVersion, recipesGAV, recipe, dryRun));
        if (!dryRun) {
            commands.put("process-sources", QuarkusUpdateCommand.getMavenProcessSourcesCommand(mvnBinary));
        }
        QuarkusUpdateCommand.executeRewrite(baseDir, commands, log, logFile);
    }

    private static String getRewriteCommandName(String rewritePluginVersion, boolean dryRun) {
        return "OpenRewrite %s%s".formatted(dryRun ? " in dry mode" : "", rewritePluginVersion);
    }

    private static void runGradleUpdate(MessageWriter log, Path baseDir, String rewritePluginVersion, String recipesGAV, Path recipe, Path logFile, boolean dryRun) {
        Path tempInit = null;
        try {
            tempInit = Files.createTempFile("openrewrite-init", "gradle", new FileAttribute[0]);
            try (InputStream inputStream = QuarkusUpdateCommand.class.getResourceAsStream("/openrewrite-init.gradle");){
                String template = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                String rewriteFile = recipe.toAbsolutePath().toString();
                if (OS.WINDOWS.isCurrent()) {
                    rewriteFile = rewriteFile.replace('\\', '/');
                }
                Files.writeString(tempInit, (CharSequence)Qute.fmt((String)template, Map.of("rewriteFile", rewriteFile, "pluginVersion", rewritePluginVersion, "recipesGAV", recipesGAV, "activeRecipe", "io.quarkus.openrewrite.Quarkus", "plainTextMask", ADDITIONAL_SOURCE_FILES_SET.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(", ")))), new OpenOption[0]);
            }
            String gradleBinary = QuarkusUpdateCommand.findGradleBinary(baseDir);
            List<String> command = List.of(gradleBinary.toString(), "--console", "plain", "--stacktrace", "--init-script", tempInit.toAbsolutePath().toString(), dryRun ? "rewriteDryRun" : "rewriteRun");
            LinkedHashMap<String, List<String>> commands = new LinkedHashMap<String, List<String>>();
            commands.put(QuarkusUpdateCommand.getRewriteCommandName(rewritePluginVersion, dryRun), command);
            QuarkusUpdateCommand.executeRewrite(baseDir, commands, log, logFile);
        }
        catch (QuarkusUpdateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QuarkusUpdateException("Error while running Gradle rewrite command, see the execution logs above for more details", e);
        }
        finally {
            if (tempInit != null) {
                try {
                    Files.deleteIfExists(tempInit);
                }
                catch (Exception exception) {}
            }
        }
    }

    private static String getMavenSettingsArg() {
        String mavenSettings = System.getProperty("maven.settings");
        if (mavenSettings != null) {
            return Files.exists(Paths.get(mavenSettings, new String[0]), new LinkOption[0]) ? mavenSettings : null;
        }
        return BootstrapMavenOptions.newInstance().getOptionValue("s");
    }

    private static void propagateSystemPropertyIfSet(String name, List<String> command) {
        if (System.getProperties().containsKey(name)) {
            StringBuilder buf = new StringBuilder();
            buf.append("-D").append(name);
            String value = System.getProperty(name);
            if (value != null && !value.isEmpty()) {
                buf.append("=").append(value);
            }
            command.add(buf.toString());
        }
    }

    private static List<String> getMavenProcessSourcesCommand(String mvnBinary) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(mvnBinary);
        command.add("-B");
        command.add("-e");
        command.add("process-sources");
        String mavenSettings = QuarkusUpdateCommand.getMavenSettingsArg();
        if (mavenSettings != null) {
            command.add("-s");
            command.add(mavenSettings);
        }
        return command;
    }

    private static List<String> getMavenUpdateCommand(String mvnBinary, String rewritePluginVersion, String recipesGAV, Path recipe, boolean dryRun) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(mvnBinary);
        command.add("-B");
        command.add("-e");
        command.add(String.format("%s:%s:%s:%s", MAVEN_REWRITE_PLUGIN_GROUP, MAVEN_REWRITE_PLUGIN_ARTIFACT, rewritePluginVersion, dryRun ? "dryRun" : "run"));
        command.add(String.format("-Drewrite.plainTextMasks=%s", ADDITIONAL_SOURCE_FILES));
        command.add(String.format("-Drewrite.configLocation=%s", recipe.toAbsolutePath()));
        command.add(String.format("-Drewrite.recipeArtifactCoordinates=%s", recipesGAV));
        command.add(String.format("-Drewrite.activeRecipes=%s", "io.quarkus.openrewrite.Quarkus"));
        command.add("-Drewrite.pomCacheEnabled=false");
        String mavenSettings = QuarkusUpdateCommand.getMavenSettingsArg();
        if (mavenSettings != null) {
            command.add("-s");
            command.add(mavenSettings);
        }
        return command;
    }

    private static void executeRewrite(Path baseDir, Map<String, List<String>> commands, MessageWriter log, Path logFile) {
        String logInfo;
        log.info("");
        log.info(" ------------------------------------------------------------------------");
        log.info("");
        if (logFile != null) {
            logInfo = "Logs can be found at: %s".formatted(baseDir.relativize(logFile).toString());
            try {
                Files.deleteIfExists(logFile);
            }
            catch (IOException iOException) {}
        } else {
            logInfo = "See the execution logs above for more details";
        }
        log.info("Update in progress (this may take a while):");
        for (Map.Entry<String, List<String>> e : commands.entrySet()) {
            log.info("  - executing " + e.getKey() + " command...");
            QuarkusUpdateCommand.execute(e.getKey(), e.getValue(), log, logFile, logInfo);
        }
        log.info("");
        log.info("Rewrite process completed. " + logInfo);
        log.info("");
    }

    private static void execute(String name, List<String> command, MessageWriter log, Path logFile, String logInfo) {
        List<String> effectiveCommand = QuarkusUpdateCommand.prepareCommand(command);
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(effectiveCommand);
        try {
            int exitCode;
            if (logFile != null) {
                Files.writeString(logFile, (CharSequence)("Running: " + String.join((CharSequence)" ", effectiveCommand) + "\n"), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
            }
            ProcessBuilder.Redirect redirect = logFile != null ? ProcessBuilder.Redirect.appendTo(logFile.toFile()) : ProcessBuilder.Redirect.PIPE;
            Process process = processBuilder.redirectOutput(redirect).redirectError(redirect).start();
            if (logFile == null) {
                String line;
                BufferedReader inputReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                LogLevel currentLogLevel = LogLevel.UNKNOWN;
                block8: while ((line = inputReader.readLine()) != null) {
                    Optional<LogLevel> detectedLogLevel = LogLevel.of(line);
                    if (detectedLogLevel.isPresent()) {
                        currentLogLevel = detectedLogLevel.get();
                    }
                    switch (currentLogLevel.ordinal()) {
                        case 0: {
                            log.error(currentLogLevel.clean(line));
                            continue block8;
                        }
                        case 1: {
                            log.warn(currentLogLevel.clean(line));
                            continue block8;
                        }
                        case 2: {
                            log.info(currentLogLevel.clean(line));
                            continue block8;
                        }
                    }
                    log.info(line);
                }
                while ((line = errorReader.readLine()) != null) {
                    log.error(line);
                }
                log.info("");
            }
            if ((exitCode = process.waitFor()) != 0) {
                log.info("");
                throw new QuarkusUpdateExitErrorException("The %s command exited with an error. %s".formatted(name, logInfo));
            }
            if (logFile != null) {
                Files.writeString(logFile, (CharSequence)"\n\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n", new OpenOption[0]);
            }
        }
        catch (QuarkusUpdateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QuarkusUpdateException("The %s command exited with an error. %s".formatted(name, logInfo), e);
        }
    }

    private static List<String> prepareCommand(List<String> command) {
        ArrayList<String> effectiveCommand = new ArrayList<String>(command);
        QuarkusUpdateCommand.propagateSystemPropertyIfSet("maven.repo.local", effectiveCommand);
        return effectiveCommand;
    }

    static String findMvnBinary(Path baseDir) {
        Path mavenCmd = QuarkusUpdateCommand.findWrapperOrBinary(baseDir, "mvnw", "mvn");
        if (mavenCmd == null) {
            throw new QuarkusUpdateException("Cannot locate mvnw or mvn. Make sure mvnw is in the project directory or mvn is in your PATH.");
        }
        return mavenCmd.toString();
    }

    static String findGradleBinary(Path baseDir) {
        Path gradleCmd = QuarkusUpdateCommand.findWrapperOrBinary(baseDir, "gradlew", "gradle");
        if (gradleCmd == null) {
            throw new QuarkusUpdateException("Cannot gradlew mvnw or gradle. Make sure gradlew is in the current directory or gradle in your PATH.");
        }
        return gradleCmd.toString();
    }

    private static Path findWrapperOrBinary(Path baseDir, String wrapper, String cmd) {
        Path found = QuarkusUpdateCommand.searchPath(wrapper, baseDir.toString());
        if (found == null) {
            found = QuarkusUpdateCommand.searchPath(cmd);
        }
        return found;
    }

    public static Path searchPath(String cmd) {
        String envPath = System.getenv("PATH");
        envPath = envPath != null ? envPath : "";
        return QuarkusUpdateCommand.searchPath(cmd, envPath);
    }

    public static Path searchPath(String cmd, String paths) {
        return Arrays.stream(paths.split(File.pathSeparator)).map(dir -> Paths.get(dir, new String[0]).resolve(cmd)).flatMap(QuarkusUpdateCommand::executables).filter(QuarkusUpdateCommand::isExecutable).findFirst().orElse(null);
    }

    private static Stream<Path> executables(Path base) {
        if (QuarkusUpdateCommand.isWindows()) {
            return Stream.of(Paths.get(base.toString() + ".exe", new String[0]), Paths.get(base.toString() + ".bat", new String[0]), Paths.get(base.toString() + ".cmd", new String[0]), Paths.get(base.toString() + ".ps1", new String[0]));
        }
        return Stream.of(base);
    }

    private static boolean isExecutable(Path file) {
        if (Files.isRegularFile(file, new LinkOption[0])) {
            if (QuarkusUpdateCommand.isWindows()) {
                String nm = file.getFileName().toString().toLowerCase();
                return nm.endsWith(".exe") || nm.endsWith(".bat") || nm.endsWith(".cmd") || nm.endsWith(".ps1");
            }
            return Files.isExecutable(file);
        }
        return false;
    }

    public static boolean isWindows() {
        return OS.WINDOWS.isCurrent();
    }

    private static enum LogLevel {
        ERROR,
        WARNING,
        INFO,
        UNKNOWN;

        private static final Pattern LEVEL_PATTERN;

        private static Optional<LogLevel> of(String line) {
            if (line == null || line.isBlank()) {
                return Optional.empty();
            }
            for (LogLevel level : LogLevel.values()) {
                if (!level.matches(line)) continue;
                return Optional.of(level);
            }
            if (LEVEL_PATTERN.matcher(line).matches()) {
                return Optional.of(UNKNOWN);
            }
            return Optional.empty();
        }

        private String clean(String line) {
            if (line == null || line.isBlank()) {
                return line;
            }
            String pattern = "[" + this.name() + "] ";
            if (!line.startsWith(pattern)) {
                return line;
            }
            return line.substring(pattern.length());
        }

        private boolean matches(String line) {
            return line != null && line.startsWith("[" + this.name() + "]");
        }

        static {
            LEVEL_PATTERN = Pattern.compile("^\\[[A-Z]+\\].*");
        }
    }
}

