/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (u64vec4(165ul, 133ul, 193ul, 76ul) * u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(27225ul, 17689ul, 37249ul, 5776ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) * u64vec4(80ul, 15ul, 51ul, 0ul)) => u64vec4(13200ul, 1995ul, 9843ul, 0ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) * u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(13200ul, 1995ul, 9843ul, 0ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) * u64vec4(80ul, 15ul, 51ul, 0ul)) => u64vec4(6400ul, 225ul, 2601ul, 0ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) * u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(27225ul, 17689ul, 37249ul, 5776ul))) ? 1 : -1] array0;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) * u64vec4(80ul, 15ul, 51ul, 0ul)), u64vec4(13200ul, 1995ul, 9843ul, 0ul))) ? 1 : -1] array1;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) * u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(13200ul, 1995ul, 9843ul, 0ul))) ? 1 : -1] array2;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) * u64vec4(80ul, 15ul, 51ul, 0ul)), u64vec4(6400ul, 225ul, 2601ul, 0ul))) ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
