/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.DrawableAlignment;
import jalview.Format;
import jalview.PostscriptProperties;
import jalview.ResidueProperties;
import jalview.SequenceGroup;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintStream;

public class Postscript {
    AlignFrame af;
    DrawableAlignment al;
    int noseqs;
    float boxsize;
    float yspace;
    int ygap;
    int maxseqlen;
    int maxidlen;
    StringBuffer out;
    BufferedWriter sw;
    PrintStream ps;
    Color lightBlue = new Color(175, 175, 255);
    Color midBlue = new Color(110, 110, 255);
    float xorig;
    float xtext;
    float ytext;
    float seqstart;
    int orient;
    int fontsize;
    int xmargin;
    int ymargin;
    int paperwidth;
    int paperheight;
    String font;
    boolean makeString;

    public Postscript(AlignFrame alignFrame, BufferedWriter bufferedWriter) {
        this.af = alignFrame;
        this.al = alignFrame.ap.seqPanel.align;
        this.orient = alignFrame.pp.orientation;
        this.font = alignFrame.pp.font;
        this.fontsize = alignFrame.pp.fsize;
        this.xmargin = alignFrame.pp.xoffset;
        this.ymargin = alignFrame.pp.yoffset;
        this.ygap = 30;
        this.sw = bufferedWriter;
    }

    public Postscript(AlignFrame alignFrame, PrintStream printStream) {
        this.af = alignFrame;
        this.al = alignFrame.ap.seqPanel.align;
        this.orient = alignFrame.pp.orientation;
        this.out = new StringBuffer();
        this.font = alignFrame.pp.font;
        this.fontsize = alignFrame.pp.fsize;
        this.xmargin = alignFrame.pp.xoffset;
        this.ymargin = alignFrame.pp.yoffset;
        this.ygap = 30;
        this.ps = printStream;
    }

    public Postscript(AlignFrame alignFrame, boolean bl) {
        if (bl) {
            this.makeString = true;
            this.af = alignFrame;
            this.al = alignFrame.ap.seqPanel.align;
            this.orient = alignFrame.pp.orientation;
            this.out = new StringBuffer();
            this.font = alignFrame.pp.font;
            this.fontsize = alignFrame.pp.fsize;
            this.xmargin = alignFrame.pp.xoffset;
            this.ymargin = alignFrame.pp.yoffset;
            this.ygap = 30;
        }
    }

    public void print(String string) throws IOException {
        if (this.sw != null) {
            this.sw.write(string);
        }
        if (this.ps != null) {
            this.ps.print(string);
        }
        if (this.makeString) {
            this.out.append(string);
        }
    }

    public void generate() {
        if (this.orient == PostscriptProperties.PORTRAIT) {
            this.paperwidth = PostscriptProperties.SHORTSIDE;
            this.paperheight = PostscriptProperties.LONGSIDE;
        } else {
            this.paperwidth = PostscriptProperties.LONGSIDE;
            this.paperheight = PostscriptProperties.SHORTSIDE;
        }
        this.noseqs = this.al.size();
        int n = this.al.maxLength();
        this.maxidlen = this.al.maxIdLength();
        this.boxsize = (float)((double)this.fontsize * 1.1);
        this.yspace = this.af.ap.seqPanel.seqCanvas.showScores ? this.boxsize * 2.0f : this.boxsize;
        this.seqstart = (float)((double)(this.boxsize * (float)this.maxidlen) * 0.7 + (double)this.xmargin);
        int n2 = (int)(((float)this.paperwidth - this.seqstart - (float)(2 * this.xmargin)) / this.boxsize);
        float f = 2.0f * this.boxsize + (float)this.noseqs * this.yspace;
        int n3 = (int)((float)(this.paperheight - this.ymargin) / (f + (float)this.ymargin));
        this.printinit();
        int n4 = 1;
        float f2 = 0.0f;
        int n5 = 0;
        try {
            int n6 = 0;
            while (n6 < n) {
                int n7;
                float f3;
                int n8;
                if (n6 % n2 == 0) {
                    if (n3 > 1 && n5 < n3 && n5 != 0) {
                        f2 = (float)n5 * (f + 30.0f);
                        ++n5;
                    } else {
                        f2 = 0.0f;
                        n5 = 1;
                        if (n4 > 1) {
                            this.print("\nshowpage\n");
                        }
                        this.print("\n%%Page: ? " + n4 + "\n");
                        if (this.paperwidth > this.paperheight) {
                            this.print(String.valueOf(PostscriptProperties.SHORTSIDE) + " 0 translate\n90 rotate\n");
                        }
                        this.print("gsave\n");
                        this.print("/Times-Roman findfont\n");
                        this.print("8 scalefont\n");
                        this.print(String.valueOf(this.xmargin) + " " + this.ymargin + " moveto\n");
                        this.print("(Jalview Michele Clamp 1998) show\n");
                        this.print("grestore\n");
                        ++n4;
                        if (this.sw != null) {
                            this.sw.flush();
                        }
                    }
                    this.print("black setrgbcolor\n");
                    n8 = 0;
                    while (n8 < this.noseqs) {
                        String string = this.al.sequences[n8].getName();
                        f3 = (float)(this.paperheight - this.ymargin) - this.boxsize - (float)n8 * this.yspace - f2;
                        this.ytext = this.af.ap.seqPanel.seqCanvas.showScores ? (float)((double)(f3 + this.yspace / 2.0f) + 0.2 * (double)this.boxsize) : (float)((double)f3 + 0.2 * (double)this.boxsize);
                        this.print("(" + string + ") " + this.xmargin + " " + this.ytext + " moveto show\n");
                        ++n8;
                    }
                }
                n8 = n6 % n2;
                this.xorig = (float)n8 * this.boxsize + this.seqstart;
                this.xtext = (float)((double)this.xorig + 0.12 * (double)this.boxsize);
                if (n6 % 10 == 9 && n6 != 0) {
                    float f4 = (float)((double)(this.paperheight - this.ymargin) + 0.2 * (double)this.boxsize - (double)f2);
                    f3 = (float)((double)(this.paperheight - this.ymargin) + 1.2 * (double)this.boxsize - (double)f2);
                    float f5 = (float)((double)this.xorig + 0.4 * (double)this.boxsize);
                    n7 = n6 + 1;
                    this.print("black setrgbcolor\n");
                    this.print("(|) " + f5 + " " + f4 + " moveto show\n");
                    this.print("(" + n7 + ") " + this.xtext + " " + f3 + " moveto show\n");
                }
                int n9 = 0;
                while (n9 < this.noseqs) {
                    int n10;
                    String string;
                    String string2;
                    Object object;
                    this.al.sequences[n9].getName();
                    f3 = (float)(this.paperheight - this.ymargin) - this.boxsize - (float)n9 * this.yspace - f2;
                    this.ytext = this.af.ap.seqPanel.seqCanvas.showScores ? (float)((double)(f3 + this.yspace / 2.0f) + 0.2 * (double)this.boxsize) : (float)((double)f3 + 0.2 * (double)this.boxsize);
                    String string3 = " ";
                    if (n6 < this.al.sequences[n9].getSequence().length()) {
                        string3 = this.al.sequences[n9].getSequence().substring(n6, n6 + 1);
                    } else if (n6 == this.al.sequences[n9].getSequence().length()) {
                        string3 = this.al.sequences[n9].getSequence().substring(n6);
                    }
                    n7 = 23;
                    try {
                        n7 = (Integer)ResidueProperties.aaHash.get(string3);
                    }
                    catch (Exception exception) {}
                    SequenceGroup sequenceGroup = this.al.findGroup(n9);
                    Color color = Color.white;
                    if (sequenceGroup.displayBoxes) {
                        color = this.findBoxColor(n6, n9, string3);
                    }
                    Format format = new Format("%6.3f");
                    String string4 = format.form((float)((double)color.getRed() / 256.0));
                    String string5 = format.form((float)((double)color.getGreen() / 256.0));
                    String string6 = format.form((float)((double)color.getBlue() / 256.0));
                    if (!sequenceGroup.displayText) {
                        string3 = " ";
                    }
                    if (sequenceGroup.colourText) {
                        Color color2 = this.findTextColor(n6, n9, string3);
                        object = format.form((float)((double)color2.getRed() / 256.0));
                        string2 = format.form((float)((double)color2.getGreen() / 256.0));
                        string = format.form((float)((double)color2.getBlue() / 256.0));
                        if (this.af.ap.seqPanel.seqCanvas.showScores) {
                            this.print("(" + string3 + ") " + this.xtext + " " + this.ytext + " " + (String)object + " " + string2 + " " + string + " " + string4 + " " + string5 + " " + string6 + " " + this.xorig + " " + (f3 + this.boxsize) + " -" + this.boxsize + " " + this.boxsize + " boxtext\n");
                        } else {
                            this.print("(" + string3 + ") " + this.xtext + " " + this.ytext + " " + (String)object + " " + string2 + " " + string + " " + string4 + " " + string5 + " " + string6 + " " + this.xorig + " " + f3 + " -" + this.boxsize + " " + this.boxsize + " boxtext\n");
                        }
                    } else if (this.af.ap.seqPanel.seqCanvas.showScores) {
                        this.print("(" + string3 + ") " + this.xtext + " " + this.ytext + " black " + string4 + " " + string5 + " " + string6 + " " + this.xorig + " " + (f3 + this.boxsize) + " -" + this.boxsize + " " + this.boxsize + " boxtext\n");
                    } else {
                        this.print("(" + string3 + ") " + this.xtext + " " + this.ytext + " black " + string4 + " " + string5 + " " + string6 + " " + this.xorig + " " + f3 + " -" + this.boxsize + " " + this.boxsize + " boxtext\n");
                    }
                    if (this.af.ap.seqPanel.seqCanvas.showScores && this.al.sequences[n9].score[0] != null && this.al.sequences[n9].score[0].size() > n6 && (n10 = ((Double)this.al.sequences[n9].score[0].elementAt(n6)).intValue()) >= 0 && n10 < 10) {
                        object = (Color)ResidueProperties.scaleColours.elementAt(((Double)this.al.sequences[n9].score[0].elementAt(n6)).intValue());
                        string2 = format.form((float)((double)((Color)object).getRed() / 256.0));
                        string = format.form((float)((double)((Color)object).getGreen() / 256.0));
                        String string7 = format.form((float)((double)((Color)object).getBlue() / 256.0));
                        this.print("( ) " + this.xtext + " " + this.ytext + " black " + string2 + " " + string + " " + string7 + " " + this.xorig + " " + (f3 + this.boxsize - this.yspace / 4.0f) + " -" + this.boxsize / 2.0f + " " + this.boxsize / 2.0f + " " + this.boxsize + " recttext\n");
                    }
                    ++n9;
                }
                ++n6;
            }
            this.print("showpage\n");
            if (this.sw != null) {
                this.sw.flush();
                return;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception : " + exception);
        }
    }

    public Color findBoxColor(int n, int n2, String string) {
        return (Color)this.af.ap.seqPanel.align.ds[n2].boxColour.elementAt(n);
    }

    public Color findTextColor(int n, int n2, String string) {
        return ((Color)this.af.ap.seqPanel.align.ds[n2].boxColour.elementAt(n)).darker();
    }

    public void printinit() {
        try {
            this.print("%!\n");
            this.print("/white {1.000000 1.000000 1.000000 } def\n");
            this.print("/black {0.000000 0.000000 0.000000 } def\n");
            this.print("/gray  {0.350000 0.350000 0.350000 } def\n");
            this.print("/red  {1.00000 0.350000 0.350000 } def\n");
            this.print("/green  {0.350000 1.000000 0.350000 } def\n");
            this.print("/blue  {0.350000 0.350000 1.00000 } def\n");
            this.print("/boxtext {\n");
            this.print("/boxsize exch def\n");
            this.print("/negsize exch def\n");
            this.print("newpath\nmoveto\n\n");
            this.print("0 boxsize rlineto\n");
            this.print("boxsize 0 rlineto\n");
            this.print("0 negsize  rlineto\n");
            this.print("closepath\n");
            this.print("setrgbcolor fill setrgbcolor\n");
            this.print("moveto show\n");
            this.print("} def\n");
            this.print("/recttext {\n");
            this.print("/boxx exch def\n");
            this.print("/boxy exch def\n");
            this.print("/negy exch def\n");
            this.print("newpath\nmoveto\n\n");
            this.print("0 boxy rlineto\n");
            this.print("boxx 0 rlineto\n");
            this.print("0 negy  rlineto\n");
            this.print("closepath\n");
            this.print("setrgbcolor fill setrgbcolor\n");
            this.print("moveto show\n");
            this.print("} def\n");
            this.print("/" + this.font + " findfont\n");
            this.print(String.valueOf(this.fontsize) + " scalefont\n");
            this.print("setfont\n");
            return;
        }
        catch (Exception exception) {
            System.out.println("Exception " + exception);
            return;
        }
    }
}

