/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernException;
import com.mongodb.WriteConcernResult;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncWriteBinding;
import com.mongodb.binding.WriteBinding;
import com.mongodb.bulk.BulkWriteError;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.BulkWriteUpsert;
import com.mongodb.bulk.DeleteRequest;
import com.mongodb.bulk.InsertRequest;
import com.mongodb.bulk.UpdateRequest;
import com.mongodb.bulk.WriteConcernError;
import com.mongodb.bulk.WriteRequest;
import com.mongodb.connection.AsyncConnection;
import com.mongodb.connection.BulkWriteBatchCombiner;
import com.mongodb.connection.Connection;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ServerVersion;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.connection.IndexMap;
import com.mongodb.operation.AsyncWriteOperation;
import com.mongodb.operation.OperationHelper;
import com.mongodb.operation.WriteOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;

public class MixedBulkWriteOperation
implements AsyncWriteOperation<BulkWriteResult>,
WriteOperation<BulkWriteResult> {
    private final MongoNamespace namespace;
    private final List<? extends WriteRequest> writeRequests;
    private final boolean ordered;
    private final WriteConcern writeConcern;
    private Boolean bypassDocumentValidation;
    private static final List<String> IGNORED_KEYS = Arrays.asList("ok", "err", "code");

    public MixedBulkWriteOperation(MongoNamespace namespace, List<? extends WriteRequest> writeRequests, boolean ordered, WriteConcern writeConcern) {
        this.ordered = ordered;
        this.namespace = Assertions.notNull("namespace", namespace);
        this.writeRequests = Assertions.notNull("writes", writeRequests);
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
        Assertions.isTrueArgument("writes is not an empty list", !writeRequests.isEmpty());
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public List<? extends WriteRequest> getWriteRequests() {
        return this.writeRequests;
    }

    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public MixedBulkWriteOperation bypassDocumentValidation(Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    @Override
    public BulkWriteResult execute(WriteBinding binding) {
        return OperationHelper.withConnection(binding, new OperationHelper.CallableWithConnection<BulkWriteResult>(){

            @Override
            public BulkWriteResult call(Connection connection) {
                OperationHelper.validateWriteRequests(connection, MixedBulkWriteOperation.this.bypassDocumentValidation, MixedBulkWriteOperation.this.writeRequests, MixedBulkWriteOperation.this.writeConcern);
                BulkWriteBatchCombiner bulkWriteBatchCombiner = new BulkWriteBatchCombiner(connection.getDescription().getServerAddress(), MixedBulkWriteOperation.this.ordered, MixedBulkWriteOperation.this.writeConcern);
                for (Run run : MixedBulkWriteOperation.this.getRunGenerator(connection.getDescription())) {
                    try {
                        BulkWriteResult result = run.execute(connection);
                        if (!result.wasAcknowledged()) continue;
                        bulkWriteBatchCombiner.addResult(result, run.indexMap);
                    }
                    catch (MongoBulkWriteException e) {
                        bulkWriteBatchCombiner.addErrorResult(e, run.indexMap);
                        if (!bulkWriteBatchCombiner.shouldStopSendingMoreBatches()) continue;
                        break;
                    }
                }
                return bulkWriteBatchCombiner.getResult();
            }
        });
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, final SingleResultCallback<BulkWriteResult> callback) {
        OperationHelper.withConnection(binding, new OperationHelper.AsyncCallableWithConnection(){

            @Override
            public void call(AsyncConnection connection, Throwable t) {
                final SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else {
                    OperationHelper.validateWriteRequests(connection, MixedBulkWriteOperation.this.bypassDocumentValidation, MixedBulkWriteOperation.this.writeRequests, MixedBulkWriteOperation.this.writeConcern, new OperationHelper.AsyncCallableWithConnection(){

                        @Override
                        public void call(AsyncConnection connection, Throwable t) {
                            if (t != null) {
                                OperationHelper.releasingCallback(errHandlingCallback, connection).onResult(null, t);
                            } else {
                                Iterator runs = MixedBulkWriteOperation.this.getRunGenerator(connection.getDescription()).iterator();
                                MixedBulkWriteOperation.this.executeRunsAsync(runs, connection, new BulkWriteBatchCombiner(connection.getDescription().getServerAddress(), MixedBulkWriteOperation.this.ordered, MixedBulkWriteOperation.this.writeConcern), errHandlingCallback);
                            }
                        }
                    });
                }
            }
        });
    }

    private void executeRunsAsync(final Iterator<Run> runs, final AsyncConnection connection, final BulkWriteBatchCombiner bulkWriteBatchCombiner, final SingleResultCallback<BulkWriteResult> callback) {
        final Run run = runs.next();
        final SingleResultCallback<BulkWriteResult> wrappedCallback = OperationHelper.releasingCallback(callback, connection);
        run.executeAsync(connection, new SingleResultCallback<BulkWriteResult>(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onResult(BulkWriteResult result, Throwable t) {
                if (t != null) {
                    if (!(t instanceof MongoBulkWriteException)) {
                        wrappedCallback.onResult(null, t);
                        return;
                    }
                    bulkWriteBatchCombiner.addErrorResult((MongoBulkWriteException)t, run.indexMap);
                } else if (result.wasAcknowledged()) {
                    bulkWriteBatchCombiner.addResult(result, run.indexMap);
                }
                if (runs.hasNext() && !bulkWriteBatchCombiner.shouldStopSendingMoreBatches()) {
                    MixedBulkWriteOperation.this.executeRunsAsync(runs, connection, bulkWriteBatchCombiner, callback);
                    return;
                }
                if (bulkWriteBatchCombiner.hasErrors()) {
                    wrappedCallback.onResult(null, bulkWriteBatchCombiner.getError());
                    return;
                }
                wrappedCallback.onResult(bulkWriteBatchCombiner.getResult(), null);
            }
        });
    }

    private boolean shouldUseWriteCommands(ConnectionDescription description) {
        return this.writeConcern.isAcknowledged() && this.serverSupportsWriteCommands(description);
    }

    private boolean serverSupportsWriteCommands(ConnectionDescription connectionDescription) {
        return connectionDescription.getServerVersion().compareTo(new ServerVersion(2, 6)) >= 0;
    }

    private Iterable<Run> getRunGenerator(ConnectionDescription connectionDescription) {
        if (this.ordered) {
            return new OrderedRunGenerator(connectionDescription, this.bypassDocumentValidation);
        }
        return new UnorderedRunGenerator(connectionDescription, this.bypassDocumentValidation);
    }

    private class Run {
        private final List runWrites = new ArrayList();
        private final WriteRequest.Type type;
        private final boolean ordered;
        private final Boolean bypassDocumentValidation;
        private IndexMap indexMap = IndexMap.create();

        Run(WriteRequest.Type type, boolean ordered, Boolean bypassDocumentValidation) {
            this.type = type;
            this.ordered = ordered;
            this.bypassDocumentValidation = bypassDocumentValidation;
        }

        void add(WriteRequest writeRequest, int originalIndex) {
            this.indexMap = this.indexMap.add(this.runWrites.size(), originalIndex);
            this.runWrites.add(writeRequest);
        }

        public int size() {
            return this.runWrites.size();
        }

        BulkWriteResult execute(Connection connection) {
            BulkWriteResult nextWriteResult;
            if (this.type == WriteRequest.Type.UPDATE || this.type == WriteRequest.Type.REPLACE) {
                nextWriteResult = this.getUpdatesRunExecutor((List<UpdateRequest>)this.runWrites, this.bypassDocumentValidation, connection).execute();
            } else if (this.type == WriteRequest.Type.INSERT) {
                nextWriteResult = this.getInsertsRunExecutor((List<InsertRequest>)this.runWrites, this.bypassDocumentValidation, connection).execute();
            } else if (this.type == WriteRequest.Type.DELETE) {
                nextWriteResult = this.getDeletesRunExecutor((List<DeleteRequest>)this.runWrites, connection).execute();
            } else {
                throw new UnsupportedOperationException(String.format("Unsupported write of type %s", new Object[]{this.type}));
            }
            return nextWriteResult;
        }

        void executeAsync(AsyncConnection connection, SingleResultCallback<BulkWriteResult> callback) {
            if (this.type == WriteRequest.Type.UPDATE || this.type == WriteRequest.Type.REPLACE) {
                this.getUpdatesRunExecutor((List<UpdateRequest>)this.runWrites, this.bypassDocumentValidation, connection).executeAsync(callback);
            } else if (this.type == WriteRequest.Type.INSERT) {
                this.getInsertsRunExecutor((List<InsertRequest>)this.runWrites, this.bypassDocumentValidation, connection).executeAsync(callback);
            } else if (this.type == WriteRequest.Type.DELETE) {
                this.getDeletesRunExecutor((List<DeleteRequest>)this.runWrites, connection).executeAsync(callback);
            } else {
                callback.onResult(null, new UnsupportedOperationException(String.format("Unsupported write of type %s", new Object[]{this.type})));
            }
        }

        RunExecutor getDeletesRunExecutor(final List<DeleteRequest> deleteRequests, final Connection connection) {
            return new RunExecutor(connection){

                @Override
                WriteConcernResult executeWriteProtocol(int index) {
                    return connection.delete(MixedBulkWriteOperation.this.namespace, Run.this.ordered, MixedBulkWriteOperation.this.writeConcern, Collections.singletonList(deleteRequests.get(index)));
                }

                @Override
                BulkWriteResult executeWriteCommandProtocol() {
                    return connection.deleteCommand(MixedBulkWriteOperation.this.namespace, Run.this.ordered, MixedBulkWriteOperation.this.writeConcern, deleteRequests);
                }

                @Override
                WriteRequest.Type getType() {
                    return WriteRequest.Type.DELETE;
                }
            };
        }

        RunExecutor getInsertsRunExecutor(final List<InsertRequest> insertRequests, final Boolean bypassDocumentValidation, final Connection connection) {
            return new RunExecutor(connection){

                @Override
                WriteConcernResult executeWriteProtocol(int index) {
                    return connection.insert(MixedBulkWriteOperation.this.namespace, Run.this.ordered, MixedBulkWriteOperation.this.writeConcern, Collections.singletonList(insertRequests.get(index)));
                }

                @Override
                BulkWriteResult executeWriteCommandProtocol() {
                    return connection.insertCommand(MixedBulkWriteOperation.this.namespace, Run.this.ordered, MixedBulkWriteOperation.this.writeConcern, bypassDocumentValidation, insertRequests);
                }

                @Override
                WriteRequest.Type getType() {
                    return WriteRequest.Type.INSERT;
                }

                @Override
                int getCount(WriteConcernResult writeConcernResult) {
                    return 1;
                }
            };
        }

        RunExecutor getUpdatesRunExecutor(final List<UpdateRequest> updates, final Boolean bypassDocumentValidation, final Connection connection) {
            return new RunExecutor(connection){

                @Override
                WriteConcernResult executeWriteProtocol(int index) {
                    return connection.update(MixedBulkWriteOperation.this.namespace, Run.this.ordered, MixedBulkWriteOperation.this.writeConcern, Collections.singletonList(updates.get(index)));
                }

                @Override
                BulkWriteResult executeWriteCommandProtocol() {
                    return connection.updateCommand(MixedBulkWriteOperation.this.namespace, Run.this.ordered, MixedBulkWriteOperation.this.writeConcern, bypassDocumentValidation, updates);
                }

                @Override
                WriteRequest.Type getType() {
                    return WriteRequest.Type.UPDATE;
                }
            };
        }

        AsyncRunExecutor getDeletesRunExecutor(final List<DeleteRequest> deleteRequests, final AsyncConnection connection) {
            return new AsyncRunExecutor(connection){

                @Override
                void executeWriteProtocolAsync(int index, SingleResultCallback<WriteConcernResult> callback) {
                    connection.deleteAsync(MixedBulkWriteOperation.this.namespace, Run.this.ordered, MixedBulkWriteOperation.this.writeConcern, Collections.singletonList(deleteRequests.get(index)), callback);
                }

                @Override
                void executeWriteCommandProtocolAsync(SingleResultCallback<BulkWriteResult> callback) {
                    connection.deleteCommandAsync(MixedBulkWriteOperation.this.namespace, Run.this.ordered, MixedBulkWriteOperation.this.writeConcern, deleteRequests, callback);
                }

                @Override
                WriteRequest.Type getType() {
                    return WriteRequest.Type.DELETE;
                }
            };
        }

        AsyncRunExecutor getInsertsRunExecutor(final List<InsertRequest> insertRequests, final Boolean bypassDocumentValidation, final AsyncConnection connection) {
            return new AsyncRunExecutor(connection){

                @Override
                void executeWriteProtocolAsync(int index, SingleResultCallback<WriteConcernResult> callback) {
                    connection.insertAsync(MixedBulkWriteOperation.this.namespace, Run.this.ordered, MixedBulkWriteOperation.this.writeConcern, Collections.singletonList(insertRequests.get(index)), callback);
                }

                @Override
                void executeWriteCommandProtocolAsync(SingleResultCallback<BulkWriteResult> callback) {
                    connection.insertCommandAsync(MixedBulkWriteOperation.this.namespace, Run.this.ordered, MixedBulkWriteOperation.this.writeConcern, bypassDocumentValidation, insertRequests, callback);
                }

                @Override
                WriteRequest.Type getType() {
                    return WriteRequest.Type.INSERT;
                }

                @Override
                int getCount(WriteConcernResult writeConcernResult) {
                    return 1;
                }
            };
        }

        AsyncRunExecutor getUpdatesRunExecutor(final List<UpdateRequest> updates, final Boolean bypassDocumentValidation, final AsyncConnection connection) {
            return new AsyncRunExecutor(connection){

                @Override
                void executeWriteProtocolAsync(int index, SingleResultCallback<WriteConcernResult> callback) {
                    connection.updateAsync(MixedBulkWriteOperation.this.namespace, Run.this.ordered, MixedBulkWriteOperation.this.writeConcern, Collections.singletonList(updates.get(index)), callback);
                }

                @Override
                void executeWriteCommandProtocolAsync(SingleResultCallback<BulkWriteResult> callback) {
                    connection.updateCommandAsync(MixedBulkWriteOperation.this.namespace, Run.this.ordered, MixedBulkWriteOperation.this.writeConcern, bypassDocumentValidation, updates, callback);
                }

                @Override
                WriteRequest.Type getType() {
                    return WriteRequest.Type.UPDATE;
                }
            };
        }

        private abstract class AsyncRunExecutor
        extends BaseRunExecutor {
            private final AsyncConnection connection;

            AsyncRunExecutor(AsyncConnection connection) {
                this.connection = connection;
            }

            abstract void executeWriteProtocolAsync(int var1, SingleResultCallback<WriteConcernResult> var2);

            abstract void executeWriteCommandProtocolAsync(SingleResultCallback<BulkWriteResult> var1);

            void executeAsync(SingleResultCallback<BulkWriteResult> callback) {
                if (MixedBulkWriteOperation.this.shouldUseWriteCommands(this.connection.getDescription())) {
                    this.executeWriteCommandProtocolAsync(callback);
                } else {
                    BulkWriteBatchCombiner bulkWriteBatchCombiner = new BulkWriteBatchCombiner(this.connection.getDescription().getServerAddress(), Run.this.ordered, MixedBulkWriteOperation.this.writeConcern);
                    this.executeRunWritesAsync(Run.this.runWrites.size(), 0, bulkWriteBatchCombiner, callback);
                }
            }

            private void executeRunWritesAsync(final int numberOfRuns, final int currentPosition, final BulkWriteBatchCombiner bulkWriteBatchCombiner, final SingleResultCallback<BulkWriteResult> callback) {
                final IndexMap indexMap = IndexMap.create(currentPosition, 1).add(0, currentPosition);
                this.executeWriteProtocolAsync(currentPosition, new SingleResultCallback<WriteConcernResult>(){

                    /*
                     * Enabled aggressive block sorting
                     */
                    @Override
                    public void onResult(WriteConcernResult result, Throwable t) {
                        int nextRunPosition = currentPosition + 1;
                        if (t != null) {
                            if (!(t instanceof WriteConcernException)) {
                                callback.onResult(null, t);
                                return;
                            }
                            WriteConcernException writeException = (WriteConcernException)t;
                            if (writeException.getResponse().get("wtimeout") != null) {
                                bulkWriteBatchCombiner.addWriteConcernErrorResult(AsyncRunExecutor.this.getWriteConcernError(writeException));
                            } else {
                                bulkWriteBatchCombiner.addWriteErrorResult(AsyncRunExecutor.this.getBulkWriteError(writeException), indexMap);
                            }
                        } else if (result.wasAcknowledged()) {
                            BulkWriteResult bulkWriteResult = AsyncRunExecutor.this.getType() == WriteRequest.Type.UPDATE || AsyncRunExecutor.this.getType() == WriteRequest.Type.REPLACE ? AsyncRunExecutor.this.getResult(result, (UpdateRequest)Run.this.runWrites.get(currentPosition)) : AsyncRunExecutor.this.getResult(result);
                            bulkWriteBatchCombiner.addResult(bulkWriteResult, indexMap);
                        }
                        if (numberOfRuns != nextRunPosition && !bulkWriteBatchCombiner.shouldStopSendingMoreBatches()) {
                            AsyncRunExecutor.this.executeRunWritesAsync(numberOfRuns, nextRunPosition, bulkWriteBatchCombiner, callback);
                            return;
                        }
                        if (bulkWriteBatchCombiner.hasErrors()) {
                            callback.onResult(null, bulkWriteBatchCombiner.getError());
                            return;
                        }
                        callback.onResult(bulkWriteBatchCombiner.getResult(), null);
                    }
                });
            }
        }

        private abstract class RunExecutor
        extends BaseRunExecutor {
            private final Connection connection;

            RunExecutor(Connection connection) {
                this.connection = connection;
            }

            abstract WriteConcernResult executeWriteProtocol(int var1);

            abstract BulkWriteResult executeWriteCommandProtocol();

            BulkWriteResult execute() {
                if (MixedBulkWriteOperation.this.shouldUseWriteCommands(this.connection.getDescription())) {
                    return this.executeWriteCommandProtocol();
                }
                BulkWriteBatchCombiner bulkWriteBatchCombiner = new BulkWriteBatchCombiner(this.connection.getDescription().getServerAddress(), Run.this.ordered, MixedBulkWriteOperation.this.writeConcern);
                for (int i = 0; i < Run.this.runWrites.size(); ++i) {
                    IndexMap indexMap = IndexMap.create(i, 1);
                    indexMap = indexMap.add(0, i);
                    try {
                        WriteConcernResult result = this.executeWriteProtocol(i);
                        if (!result.wasAcknowledged()) continue;
                        BulkWriteResult bulkWriteResult = this.getType() == WriteRequest.Type.UPDATE || this.getType() == WriteRequest.Type.REPLACE ? this.getResult(result, (UpdateRequest)Run.this.runWrites.get(i)) : this.getResult(result);
                        bulkWriteBatchCombiner.addResult(bulkWriteResult, indexMap);
                        continue;
                    }
                    catch (WriteConcernException writeException) {
                        if (writeException.getResponse().get("wtimeout") != null) {
                            bulkWriteBatchCombiner.addWriteConcernErrorResult(this.getWriteConcernError(writeException));
                        } else {
                            bulkWriteBatchCombiner.addWriteErrorResult(this.getBulkWriteError(writeException), indexMap);
                        }
                        if (bulkWriteBatchCombiner.shouldStopSendingMoreBatches()) break;
                    }
                }
                return bulkWriteBatchCombiner.getResult();
            }
        }

        private abstract class BaseRunExecutor {
            private BaseRunExecutor() {
            }

            abstract WriteRequest.Type getType();

            int getCount(WriteConcernResult writeConcernResult) {
                return this.getType() == WriteRequest.Type.INSERT ? 1 : writeConcernResult.getCount();
            }

            BulkWriteResult getResult(WriteConcernResult writeConcernResult) {
                return this.getResult(writeConcernResult, this.getUpsertedItems(writeConcernResult));
            }

            BulkWriteResult getResult(WriteConcernResult writeConcernResult, UpdateRequest updateRequest) {
                return this.getResult(writeConcernResult, this.getUpsertedItems(writeConcernResult, updateRequest));
            }

            BulkWriteResult getResult(WriteConcernResult writeConcernResult, List<BulkWriteUpsert> upsertedItems) {
                int count = this.getCount(writeConcernResult);
                Integer modifiedCount = this.getType() == WriteRequest.Type.UPDATE || this.getType() == WriteRequest.Type.REPLACE ? null : Integer.valueOf(0);
                return BulkWriteResult.acknowledged(this.getType(), count - upsertedItems.size(), modifiedCount, upsertedItems);
            }

            List<BulkWriteUpsert> getUpsertedItems(WriteConcernResult writeConcernResult) {
                return writeConcernResult.getUpsertedId() == null ? Collections.emptyList() : Collections.singletonList(new BulkWriteUpsert(0, writeConcernResult.getUpsertedId()));
            }

            List<BulkWriteUpsert> getUpsertedItems(WriteConcernResult writeConcernResult, UpdateRequest updateRequest) {
                if (writeConcernResult.getUpsertedId() == null) {
                    if (writeConcernResult.isUpdateOfExisting() || !updateRequest.isUpsert()) {
                        return Collections.emptyList();
                    }
                    BsonDocument update = updateRequest.getUpdate();
                    BsonDocument filter = updateRequest.getFilter();
                    if (update.containsKey("_id")) {
                        return Collections.singletonList(new BulkWriteUpsert(0, update.get("_id")));
                    }
                    if (filter.containsKey("_id")) {
                        return Collections.singletonList(new BulkWriteUpsert(0, filter.get("_id")));
                    }
                    return Collections.emptyList();
                }
                return Collections.singletonList(new BulkWriteUpsert(0, writeConcernResult.getUpsertedId()));
            }

            BulkWriteError getBulkWriteError(WriteConcernException writeException) {
                return new BulkWriteError(writeException.getErrorCode(), writeException.getErrorMessage(), this.translateGetLastErrorResponseToErrInfo(writeException.getResponse()), 0);
            }

            WriteConcernError getWriteConcernError(WriteConcernException writeException) {
                return new WriteConcernError(writeException.getErrorCode(), ((BsonString)writeException.getResponse().get("err")).getValue(), this.translateGetLastErrorResponseToErrInfo(writeException.getResponse()));
            }

            private BsonDocument translateGetLastErrorResponseToErrInfo(BsonDocument response) {
                BsonDocument errInfo = new BsonDocument();
                for (Map.Entry<String, BsonValue> entry : response.entrySet()) {
                    if (IGNORED_KEYS.contains(entry.getKey())) continue;
                    errInfo.put(entry.getKey(), entry.getValue());
                }
                return errInfo;
            }
        }
    }

    private class UnorderedRunGenerator
    implements Iterable<Run> {
        private final int maxBatchCount;
        private final Boolean bypassDocumentValidation;

        public UnorderedRunGenerator(ConnectionDescription connectionDescription, Boolean bypassDocumentValidation) {
            this.maxBatchCount = connectionDescription.getMaxBatchCount();
            this.bypassDocumentValidation = bypassDocumentValidation;
        }

        @Override
        public Iterator<Run> iterator() {
            return new Iterator<Run>(){
                private final List<Run> runs = new ArrayList<Run>();
                private int curIndex;

                @Override
                public boolean hasNext() {
                    return this.curIndex < MixedBulkWriteOperation.this.writeRequests.size() || !this.runs.isEmpty();
                }

                @Override
                public Run next() {
                    while (this.curIndex < MixedBulkWriteOperation.this.writeRequests.size()) {
                        WriteRequest writeRequest = (WriteRequest)MixedBulkWriteOperation.this.writeRequests.get(this.curIndex);
                        Run run = this.findRunOfType(writeRequest.getType());
                        if (run == null) {
                            run = new Run(writeRequest.getType(), false, UnorderedRunGenerator.this.bypassDocumentValidation);
                            this.runs.add(run);
                        }
                        run.add(writeRequest, this.curIndex);
                        ++this.curIndex;
                        if (run.size() != UnorderedRunGenerator.this.maxBatchCount) continue;
                        this.runs.remove(run);
                        return run;
                    }
                    return this.runs.remove(0);
                }

                private Run findRunOfType(WriteRequest.Type type) {
                    for (Run cur : this.runs) {
                        if (cur.type != type) continue;
                        return cur;
                    }
                    return null;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not implemented");
                }
            };
        }
    }

    private class OrderedRunGenerator
    implements Iterable<Run> {
        private final int maxBatchCount;
        private final Boolean bypassDocumentValidation;

        public OrderedRunGenerator(ConnectionDescription connectionDescription, Boolean bypassDocumentValidation) {
            this.maxBatchCount = connectionDescription.getMaxBatchCount();
            this.bypassDocumentValidation = bypassDocumentValidation;
        }

        @Override
        public Iterator<Run> iterator() {
            return new Iterator<Run>(){
                private int curIndex;

                @Override
                public boolean hasNext() {
                    return this.curIndex < MixedBulkWriteOperation.this.writeRequests.size();
                }

                @Override
                public Run next() {
                    Run run = new Run(((WriteRequest)MixedBulkWriteOperation.this.writeRequests.get(this.curIndex)).getType(), true, OrderedRunGenerator.this.bypassDocumentValidation);
                    int nextIndex = this.getNextIndex();
                    for (int i = this.curIndex; i < nextIndex; ++i) {
                        run.add((WriteRequest)MixedBulkWriteOperation.this.writeRequests.get(i), i);
                    }
                    this.curIndex = nextIndex;
                    return run;
                }

                private int getNextIndex() {
                    WriteRequest.Type type = ((WriteRequest)MixedBulkWriteOperation.this.writeRequests.get(this.curIndex)).getType();
                    for (int i = this.curIndex; i < MixedBulkWriteOperation.this.writeRequests.size(); ++i) {
                        if (i != this.curIndex + OrderedRunGenerator.this.maxBatchCount && ((WriteRequest)MixedBulkWriteOperation.this.writeRequests.get(i)).getType() == type) continue;
                        return i;
                    }
                    return MixedBulkWriteOperation.this.writeRequests.size();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not implemented");
                }
            };
        }
    }
}

