/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity.mutation;

import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.AttributeMappingsList;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.mutation.AbstractDeleteCoordinator;
import org.hibernate.persister.entity.mutation.EntityTableMapping;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.ast.ColumnValueBindingList;
import org.hibernate.sql.model.ast.builder.MutationGroupBuilder;
import org.hibernate.sql.model.ast.builder.RestrictedTableMutationBuilder;
import org.hibernate.sql.model.ast.builder.TableDeleteBuilder;
import org.hibernate.sql.model.ast.builder.TableDeleteBuilderSkipped;
import org.hibernate.sql.model.ast.builder.TableDeleteBuilderStandard;

public class DeleteCoordinatorStandard
extends AbstractDeleteCoordinator {
    public DeleteCoordinatorStandard(EntityPersister entityPersister, SessionFactoryImplementor factory) {
        super(entityPersister, factory);
    }

    @Override
    protected MutationOperationGroup generateOperationGroup(Object rowId, Object[] loadedState, boolean applyVersion, SharedSessionContractImplementor session) {
        MutationGroupBuilder deleteGroupBuilder = new MutationGroupBuilder(MutationType.DELETE, this.entityPersister());
        this.entityPersister().forEachMutableTableReverse(tableMapping -> {
            TableDeleteBuilder tableDeleteBuilder = tableMapping.isCascadeDeleteEnabled() ? new TableDeleteBuilderSkipped((TableMapping)tableMapping) : new TableDeleteBuilderStandard((MutationTarget<?>)this.entityPersister(), (TableMapping)tableMapping, this.factory());
            deleteGroupBuilder.addTableDetailsBuilder(tableDeleteBuilder);
        });
        this.applyTableDeleteDetails(deleteGroupBuilder, rowId, loadedState, applyVersion, session);
        return this.createOperationGroup(null, deleteGroupBuilder.buildMutationGroup());
    }

    private void applyTableDeleteDetails(MutationGroupBuilder deleteGroupBuilder, Object rowId, Object[] loadedState, boolean applyVersion, SharedSessionContractImplementor session) {
        deleteGroupBuilder.forEachTableMutationBuilder(builder -> {
            EntityTableMapping tableMapping = (EntityTableMapping)builder.getMutatingTable().getTableMapping();
            TableDeleteBuilder tableDeleteBuilder = (TableDeleteBuilder)builder;
            DeleteCoordinatorStandard.applyKeyRestriction(rowId, this.entityPersister(), tableDeleteBuilder, tableMapping);
        });
        if (applyVersion) {
            this.applyOptimisticLocking(deleteGroupBuilder, loadedState, session);
            EntityPersister persister = this.entityPersister();
            if (persister.hasPartitionedSelectionMapping()) {
                AttributeMappingsList attributeMappings = persister.getAttributeMappings();
                for (int m = 0; m < attributeMappings.size(); ++m) {
                    AttributeMapping attributeMapping = attributeMappings.get(m);
                    int jdbcTypeCount = attributeMapping.getJdbcTypeCount();
                    for (int i = 0; i < jdbcTypeCount; ++i) {
                        SelectableMapping selectableMapping = attributeMapping.getSelectable(i);
                        if (!selectableMapping.isPartitioned()) continue;
                        String tableNameForMutation = persister.physicalTableNameForMutation(selectableMapping);
                        RestrictedTableMutationBuilder rootTableMutationBuilder = (RestrictedTableMutationBuilder)deleteGroupBuilder.findTableDetailsBuilder(tableNameForMutation);
                        rootTableMutationBuilder.addKeyRestrictionLeniently(selectableMapping);
                    }
                }
            }
        }
    }

    protected void applyOptimisticLocking(MutationGroupBuilder mutationGroupBuilder, Object[] loadedState, SharedSessionContractImplementor session) {
        OptimisticLockStyle optimisticLockStyle = this.entityPersister().optimisticLockStyle();
        if (optimisticLockStyle.isVersion() && this.entityPersister().getVersionMapping() != null) {
            this.applyVersionBasedOptLocking(mutationGroupBuilder);
        } else if (loadedState != null && this.entityPersister().optimisticLockStyle().isAllOrDirty()) {
            this.applyNonVersionOptLocking(optimisticLockStyle, mutationGroupBuilder, loadedState, session);
        }
    }

    protected void applyVersionBasedOptLocking(MutationGroupBuilder mutationGroupBuilder) {
        assert (this.entityPersister().optimisticLockStyle() == OptimisticLockStyle.VERSION);
        assert (this.entityPersister().getVersionMapping() != null);
        String tableNameForMutation = this.entityPersister().physicalTableNameForMutation(this.entityPersister().getVersionMapping());
        RestrictedTableMutationBuilder rootTableMutationBuilder = (RestrictedTableMutationBuilder)mutationGroupBuilder.findTableDetailsBuilder(tableNameForMutation);
        rootTableMutationBuilder.addOptimisticLockRestriction(this.entityPersister().getVersionMapping());
    }

    protected void applyNonVersionOptLocking(OptimisticLockStyle lockStyle, MutationGroupBuilder mutationGroupBuilder, Object[] loadedState, SharedSessionContractImplementor session) {
        EntityPersister persister = this.entityPersister();
        assert (loadedState != null);
        assert (lockStyle.isAllOrDirty());
        assert (persister.optimisticLockStyle().isAllOrDirty());
        assert (session != null);
        boolean[] versionability = persister.getPropertyVersionability();
        for (int attributeIndex = 0; attributeIndex < versionability.length; ++attributeIndex) {
            AttributeMapping attribute;
            if (!versionability[attributeIndex] || (attribute = persister.getAttributeMapping(attributeIndex)).isPluralAttributeMapping()) continue;
            this.breakDownJdbcValues(mutationGroupBuilder, session, attribute, loadedState[attributeIndex]);
        }
    }

    private void breakDownJdbcValues(MutationGroupBuilder mutationGroupBuilder, SharedSessionContractImplementor session, AttributeMapping attribute, Object loadedValue) {
        ColumnValueBindingList optimisticLockBindings;
        RestrictedTableMutationBuilder tableMutationBuilder = (RestrictedTableMutationBuilder)mutationGroupBuilder.findTableDetailsBuilder(attribute.getContainingTableExpression());
        if (tableMutationBuilder != null && (optimisticLockBindings = tableMutationBuilder.getOptimisticLockBindings()) != null) {
            attribute.breakDownJdbcValues(loadedValue, (valueIndex, value, jdbcValueMapping) -> {
                if (!tableMutationBuilder.getKeyRestrictionBindings().containsColumn(jdbcValueMapping.getSelectableName(), jdbcValueMapping.getJdbcMapping())) {
                    optimisticLockBindings.consume(valueIndex, value, jdbcValueMapping);
                }
            }, session);
        }
    }
}

