/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.Beans;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Hashes;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InjectionTargetInfo;
import io.quarkus.arc.processor.InvocationTransformer;
import io.quarkus.arc.processor.InvokerBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class InvokerInfo
implements InjectionTargetInfo {
    private final BeanDeployment beanDeployment;
    final BeanInfo targetBean;
    final ClassInfo targetBeanClass;
    final MethodInfo method;
    final boolean instanceLookup;
    final boolean[] argumentLookups;
    final Injection argumentInjection;
    final boolean usesLookup;
    final InvocationTransformer instanceTransformer;
    final InvocationTransformer[] argumentTransformers;
    final InvocationTransformer returnValueTransformer;
    final InvocationTransformer exceptionTransformer;
    final InvocationTransformer invocationWrapper;
    final String className;
    final String wrapperClassName;
    final String lazyClassName;

    InvokerInfo(InvokerBuilder builder, Injection argumentInjection, BeanDeployment beanDeployment) {
        assert (builder.argumentTransformers.length == builder.targetMethod.parametersCount());
        assert (builder.argumentLookups.length == builder.targetMethod.parametersCount());
        this.beanDeployment = beanDeployment;
        this.targetBean = builder.targetBean;
        this.targetBeanClass = builder.targetBeanClass;
        this.method = builder.targetMethod;
        this.instanceLookup = builder.instanceLookup;
        this.argumentLookups = builder.argumentLookups;
        this.argumentInjection = argumentInjection;
        boolean usesLookup = builder.instanceLookup;
        for (boolean argumentLookup : builder.argumentLookups) {
            usesLookup |= argumentLookup;
        }
        this.usesLookup = usesLookup;
        this.instanceTransformer = builder.instanceTransformer;
        this.argumentTransformers = builder.argumentTransformers;
        this.returnValueTransformer = builder.returnValueTransformer;
        this.exceptionTransformer = builder.exceptionTransformer;
        this.invocationWrapper = builder.invocationWrapper;
        String prefix = String.valueOf(builder.targetMethod.declaringClass().name()) + "_" + builder.targetMethod.name();
        String hash = InvokerInfo.methodHash(builder);
        this.className = prefix + "_Invoker_" + hash;
        this.wrapperClassName = this.invocationWrapper != null ? prefix + "_InvokerWrapper_" + hash : null;
        this.lazyClassName = usesLookup ? prefix + "_LazyInvoker_" + hash : null;
    }

    private static String methodHash(InvokerBuilder builder) {
        StringBuilder str = new StringBuilder();
        str.append(builder.targetBean.getIdentifier());
        str.append(builder.targetBeanClass.name());
        str.append(builder.targetMethod.declaringClass().name());
        str.append(builder.targetMethod.name());
        str.append(builder.targetMethod.returnType().name());
        for (Type parameterType : builder.targetMethod.parameterTypes()) {
            str.append(parameterType.name());
        }
        str.append(builder.instanceTransformer);
        str.append(Arrays.toString(builder.argumentTransformers));
        str.append(builder.returnValueTransformer);
        str.append(builder.exceptionTransformer);
        str.append(builder.invocationWrapper);
        str.append(builder.instanceLookup);
        str.append(Arrays.toString(builder.argumentLookups));
        return Hashes.sha1_base64(str.toString());
    }

    public String getClassName() {
        if (this.lazyClassName != null) {
            return this.lazyClassName;
        }
        if (this.wrapperClassName != null) {
            return this.wrapperClassName;
        }
        return this.className;
    }

    public String toString() {
        return "invoker of " + String.valueOf(this.targetBeanClass.name()) + "#" + this.method.name();
    }

    @Override
    public InjectionTargetInfo.TargetKind kind() {
        return InjectionTargetInfo.TargetKind.INVOKER;
    }

    @Override
    public InvokerInfo asInvoker() {
        return this;
    }

    void init(List<Throwable> errors) {
        for (InjectionPointInfo injectionPoint : this.argumentInjection.injectionPoints) {
            Beans.resolveInjectionPoint(this.beanDeployment, this, injectionPoint, errors);
        }
    }

    InjectionPointInfo getInjectionPointForArgument(int position) {
        if (this.argumentLookups[position]) {
            for (InjectionPointInfo injectionPoint : this.argumentInjection.injectionPoints) {
                if (injectionPoint.getPosition() != position) continue;
                return injectionPoint;
            }
        }
        return null;
    }

    List<BeanInfo> getLookedUpBeans() {
        ArrayList<BeanInfo> result = new ArrayList<BeanInfo>();
        if (this.instanceLookup) {
            result.add(this.targetBean);
        }
        for (int i = 0; i < this.argumentLookups.length; ++i) {
            InjectionPointInfo injectionPoint = this.getInjectionPointForArgument(i);
            if (injectionPoint == null) continue;
            result.add(injectionPoint.getResolvedBean());
        }
        return result;
    }

    boolean isAsynchronous() {
        DotName returnType = this.method.returnType().name();
        return DotNames.COMPLETION_STAGE.equals((Object)returnType) || DotNames.UNI.equals((Object)returnType) || DotNames.MULTI.equals((Object)returnType);
    }
}

