/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.validate.validators;

import org.keycloak.provider.ConfiguredProvider;
import org.keycloak.validate.ValidatorConfig;
import org.keycloak.validate.validators.AbstractNumberValidator;

public class DoubleValidator
extends AbstractNumberValidator
implements ConfiguredProvider {
    public static final String ID = "double";
    public static final DoubleValidator INSTANCE = new DoubleValidator();

    public DoubleValidator() {
    }

    public DoubleValidator(ValidatorConfig config) {
        super(config);
    }

    public String getId() {
        return ID;
    }

    @Override
    protected Number convert(Object value, ValidatorConfig config) {
        if (value instanceof Number) {
            return (Number)value;
        }
        return Double.valueOf(value.toString());
    }

    @Override
    protected Number getMinMaxConfig(ValidatorConfig config, String key) {
        return config != null ? config.getDouble(key) : null;
    }

    @Override
    protected boolean isFirstGreaterThanToSecond(Number n1, Number n2) {
        return n1.doubleValue() > n2.doubleValue();
    }

    public String getHelpText() {
        return "Validator to check Double number format and optionally min and max values";
    }
}

