/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.styles;

import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;

public class LengthCalculator {
    private double millimeter;
    private double point;
    private double pixel;

    public void add(CSSNumericValue cSSNumericValue) {
        if (cSSNumericValue == null) {
            return;
        }
        CSSNumericType cSSNumericType = cSSNumericValue.getType();
        if (cSSNumericType == CSSNumericType.CM) {
            this.millimeter += cSSNumericValue.getValue() * 10.0;
        } else if (cSSNumericType == CSSNumericType.MM) {
            this.millimeter += cSSNumericValue.getValue();
        } else if (cSSNumericType == CSSNumericType.PT) {
            this.point += cSSNumericValue.getValue();
        } else if (cSSNumericType == CSSNumericType.PC) {
            this.point += 12.0 * cSSNumericValue.getValue();
        } else if (cSSNumericType == CSSNumericType.INCH) {
            this.point += 72.0 * cSSNumericValue.getValue();
        } else if (cSSNumericType == CSSNumericType.PX) {
            this.pixel += cSSNumericValue.getValue();
        }
    }

    public CSSNumericValue getResult() {
        if (this.pixel == 0.0 && this.point == 0.0) {
            return CSSNumericValue.createValue((CSSNumericType)CSSNumericType.MM, (double)this.millimeter);
        }
        if (this.pixel == 0.0 && this.millimeter == 0.0) {
            return CSSNumericValue.createValue((CSSNumericType)CSSNumericType.PT, (double)this.point);
        }
        if (this.point == 0.0 && this.millimeter == 0.0) {
            return CSSNumericValue.createValue((CSSNumericType)CSSNumericType.PX, (double)this.pixel);
        }
        double d = this.point;
        d += this.millimeter * 10.0 * 72.0 / 254.0;
        return CSSNumericValue.createValue((CSSNumericType)CSSNumericType.PT, (double)(d += this.pixel * 72.0 / 96.0));
    }
}

