/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DeleteVpcEndpointsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DeleteVpcEndpointsRequestMarshaller
implements Marshaller<Request<DeleteVpcEndpointsRequest>, DeleteVpcEndpointsRequest> {
    public Request<DeleteVpcEndpointsRequest> marshall(DeleteVpcEndpointsRequest deleteVpcEndpointsRequest) {
        if (deleteVpcEndpointsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteVpcEndpointsRequest, "AmazonEC2");
        request.addParameter("Action", "DeleteVpcEndpoints");
        request.addParameter("Version", "2015-04-15");
        if (deleteVpcEndpointsRequest.isDryRun() != null) {
            request.addParameter("DryRun", StringUtils.fromBoolean((Boolean)deleteVpcEndpointsRequest.isDryRun()));
        }
        List<String> vpcEndpointIdsList = deleteVpcEndpointsRequest.getVpcEndpointIds();
        int vpcEndpointIdsListIndex = 1;
        for (String vpcEndpointIdsListValue : vpcEndpointIdsList) {
            if (vpcEndpointIdsListValue != null) {
                request.addParameter("VpcEndpointId." + vpcEndpointIdsListIndex, StringUtils.fromString((String)vpcEndpointIdsListValue));
            }
            ++vpcEndpointIdsListIndex;
        }
        return request;
    }
}

