/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.modeler.util.ProgressDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LongRunningTask<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LongRunningTask.class);
    protected static final int DEFAULT_MS_TO_DECIDE_TO_POPUP = 500;
    protected ProgressDialog dialog;
    protected JFrame frame;
    protected String title;
    protected Timer taskPollingTimer;
    protected boolean canceled;
    protected int minValue;
    protected int maxValue;
    protected boolean finished;
    protected T result;

    public LongRunningTask(JFrame frame, String title) {
        this.frame = frame;
        this.title = title;
    }

    public synchronized T startAndWait() {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new CayenneRuntimeException("Can't block EventDispatchThread. Call 'startAndWait' from another thread.", new Object[0]);
        }
        this.start();
        if (this.finished) {
            return this.result;
        }
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            this.setCanceled(true);
        }
        this.notifyAll();
        return this.result;
    }

    public void start() {
        this.setCanceled(false);
        this.finished = false;
        Thread task = new Thread(this::internalExecute);
        Timer progressDisplayTimer = new Timer(500, e -> this.showProgress());
        progressDisplayTimer.setRepeats(false);
        progressDisplayTimer.start();
        task.start();
    }

    protected synchronized void showProgress() {
        LOGGER.debug("will show progress...");
        if (this.finished) {
            return;
        }
        int currentValue = this.getCurrentValue();
        if (!this.isCanceled() && currentValue < this.getMaxValue()) {
            LOGGER.debug("task still in progress, will show progress dialog...");
            this.dialog = new ProgressDialog(this.frame, "Progress...", this.title);
            this.dialog.getCancelButton().addActionListener(e -> this.setCanceled(true));
            this.dialog.getProgressBar().setMinimum(this.getMinValue());
            this.dialog.getProgressBar().setMaximum(this.getMaxValue());
            this.updateProgress();
            this.taskPollingTimer = new Timer(500, e -> this.updateProgress());
            this.taskPollingTimer.start();
            this.dialog.setVisible(true);
        }
    }

    protected void updateProgress() {
        if (this.isCanceled()) {
            this.stop();
            return;
        }
        this.dialog.getStatusLabel().setText(this.getCurrentNote());
        JProgressBar progressBar = this.dialog.getProgressBar();
        if (!this.isIndeterminate()) {
            progressBar.setValue(this.getCurrentValue());
            progressBar.setIndeterminate(false);
        } else {
            progressBar.setIndeterminate(true);
        }
    }

    protected synchronized void stop() {
        if (this.taskPollingTimer != null) {
            this.taskPollingTimer.stop();
        }
        if (this.dialog != null) {
            this.dialog.dispose();
        }
        this.finished = true;
        this.notifyAll();
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean b) {
        if (b) {
            LOGGER.debug("task canceled");
        }
        this.canceled = b;
    }

    protected void internalExecute() {
        try {
            this.execute();
        }
        catch (Throwable th) {
            this.setCanceled(true);
            LOGGER.warn("task error", th);
        }
        finally {
            this.stop();
        }
    }

    protected abstract void execute();

    protected abstract String getCurrentNote();

    protected abstract int getCurrentValue();

    protected abstract boolean isIndeterminate();

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
    }
}

