/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.httpclient;

import java.time.Duration;
import java.time.Instant;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.component.DestroyedComponentException;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.TimerSupport;
import org.apache.http.conn.HttpClientConnectionManager;

public class IdleConnectionSweeper
implements DestructableComponent {
    private boolean destroyed;
    private boolean createdTimer;
    @Nullable
    private Instant executionTime;
    @Nonnull
    private final HttpClientConnectionManager connectionManager;
    @Nonnull
    private final Timer taskTimer;
    @Nonnull
    private final TimerTask sweeper;

    public IdleConnectionSweeper(@Nonnull HttpClientConnectionManager manager, @Nonnull Duration idleTimeout, @Nonnull Duration sweepInterval) {
        this(manager, idleTimeout, sweepInterval, new Timer(TimerSupport.getTimerName(IdleConnectionSweeper.class.getName(), null), true));
        this.createdTimer = true;
    }

    public IdleConnectionSweeper(@Nonnull HttpClientConnectionManager manager, final @Nonnull Duration idleTimeout, @Nonnull Duration sweepInterval, @Nonnull Timer backgroundTimer) {
        this.connectionManager = Constraint.isNotNull(manager, "HttpClientConnectionManager can not be null");
        this.taskTimer = Constraint.isNotNull(backgroundTimer, "Sweeper task timer can not be null");
        this.sweeper = new TimerTask(){

            @Override
            public void run() {
                IdleConnectionSweeper.this.executionTime = Instant.now();
                IdleConnectionSweeper.this.connectionManager.closeIdleConnections(idleTimeout.toMillis(), TimeUnit.MILLISECONDS);
            }
        };
        this.taskTimer.schedule(this.sweeper, sweepInterval.toMillis(), sweepInterval.toMillis());
    }

    @Nonnull
    public Instant scheduledExecutionTime() {
        if (this.isDestroyed()) {
            throw new DestroyedComponentException();
        }
        if (this.executionTime != null) {
            return this.executionTime;
        }
        return Instant.ofEpochMilli(this.sweeper.scheduledExecutionTime());
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public synchronized void destroy() {
        this.sweeper.cancel();
        if (this.createdTimer) {
            this.taskTimer.cancel();
        }
        this.destroyed = true;
    }
}

