/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Arrays;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class ReplicationDeleteTXMessage
extends PacketImpl {
    private long txId;
    private long id;
    private byte journalID;
    private EncodingSupport encodingData;
    private byte[] recordData;

    public ReplicationDeleteTXMessage() {
        super((byte)94);
    }

    public ReplicationDeleteTXMessage(byte journalID, long txId, long id, EncodingSupport encodingData) {
        this();
        this.journalID = journalID;
        this.txId = txId;
        this.id = id;
        this.encodingData = encodingData;
    }

    public int expectedEncodeSize() {
        return 34 + this.encodingData.getEncodeSize();
    }

    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeByte(this.journalID);
        buffer.writeLong(this.txId);
        buffer.writeLong(this.id);
        buffer.writeInt(this.encodingData.getEncodeSize());
        this.encodingData.encode(buffer);
    }

    public void decodeRest(ActiveMQBuffer buffer) {
        this.journalID = buffer.readByte();
        this.txId = buffer.readLong();
        this.id = buffer.readLong();
        int size1 = buffer.readInt();
        this.recordData = new byte[size1];
        buffer.readBytes(this.recordData);
    }

    public long getId() {
        return this.id;
    }

    public long getTxId() {
        return this.txId;
    }

    public byte getJournalID() {
        return this.journalID;
    }

    public byte[] getRecordData() {
        return this.recordData;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.encodingData, this.id, this.journalID, Arrays.hashCode(this.recordData), this.txId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ReplicationDeleteTXMessage)) {
            return false;
        }
        ReplicationDeleteTXMessage other = (ReplicationDeleteTXMessage)((Object)obj);
        return Objects.equals(this.encodingData, other.encodingData) && this.id == other.id && this.journalID == other.journalID && Arrays.equals(this.recordData, other.recordData) && this.txId == other.txId;
    }
}

