/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.EntityPart;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.cxf.jaxrs.impl.EntityPartImpl;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

public class EntityPartBuilderImpl
implements EntityPart.Builder {
    private final String name;
    private MediaType mediaType;
    private MultivaluedMap<String, String> headers = new MultivaluedHashMap();
    private String fileName;
    private Object content;
    private GenericType<?> genericType;
    private Class<?> type;

    public EntityPartBuilderImpl(String name) {
        this.name = name;
    }

    public EntityPart.Builder mediaType(MediaType mt) throws IllegalArgumentException {
        this.mediaType = mt;
        return this;
    }

    public EntityPart.Builder mediaType(String mts) throws IllegalArgumentException {
        this.mediaType = MediaType.valueOf((String)mts);
        return this;
    }

    public EntityPart.Builder header(String headerName, String ... headerValues) throws IllegalArgumentException {
        this.headers.addAll((Object)headerName, (Object[])headerValues);
        return this;
    }

    public EntityPart.Builder headers(MultivaluedMap<String, String> newHeaders) throws IllegalArgumentException {
        this.headers.clear();
        this.headers.putAll(newHeaders);
        return this;
    }

    public EntityPart.Builder fileName(String fn) throws IllegalArgumentException {
        this.fileName = fn;
        return this;
    }

    public EntityPart.Builder content(InputStream in) throws IllegalArgumentException {
        this.content = in;
        return this;
    }

    public <T> EntityPart.Builder content(T c, Class<? extends T> t) throws IllegalArgumentException {
        this.content = c;
        this.type = t;
        this.genericType = null;
        return this;
    }

    public <T> EntityPart.Builder content(T c, GenericType<T> t) throws IllegalArgumentException {
        this.content = c;
        this.genericType = t;
        this.type = null;
        return this;
    }

    public EntityPart build() throws IllegalStateException, IOException, WebApplicationException {
        MediaType mt = Objects.requireNonNullElse(this.mediaType, MediaType.APPLICATION_OCTET_STREAM_TYPE);
        Message message = JAXRSUtils.getCurrentMessage();
        ServerProviderFactory factory = ServerProviderFactory.getInstance(message);
        if (this.genericType != null) {
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                this.writeTo((ProviderFactory)factory, this.genericType, mt, message, out);
                EntityPartImpl entityPartImpl = new EntityPartImpl(factory, this.name, this.fileName, new ByteArrayInputStream(out.toByteArray()), this.headers, mt);
                return entityPartImpl;
            }
        }
        if (this.type != null) {
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                this.writeTo((ProviderFactory)factory, this.type, mt, message, out);
                EntityPartImpl entityPartImpl = new EntityPartImpl(factory, this.name, this.fileName, new ByteArrayInputStream(out.toByteArray()), this.headers, mt);
                return entityPartImpl;
            }
        }
        throw new IllegalStateException("Either type or genericType is expected for the content");
    }

    private <T> void writeTo(ProviderFactory providers, GenericType<T> t, MediaType mt, Message message, ByteArrayOutputStream out) throws IOException {
        MessageBodyWriter writer = providers.createMessageBodyWriter(t.getRawType(), t.getType(), null, mt, message);
        writer.writeTo(this.content, t.getRawType(), t.getType(), null, mt, EntityPartBuilderImpl.cast(this.headers), (OutputStream)out);
    }

    private <T> void writeTo(ProviderFactory providers, Class<T> t, MediaType mt, Message message, ByteArrayOutputStream out) throws IOException {
        MessageBodyWriter<T> writer = providers.createMessageBodyWriter(t, null, null, mt, message);
        writer.writeTo(this.content, t, null, null, mt, EntityPartBuilderImpl.cast(this.headers), (OutputStream)out);
    }

    private static <T, U> MultivaluedMap<T, U> cast(MultivaluedMap<?, ?> p) {
        return p;
    }
}

