/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.protocol.ClientPacketDecoder;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.BackupRegistrationMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.BackupReplicationStartFailedMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.BackupRequestMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.BackupResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ClusterConnectMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ClusterConnectReplyMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateProducerMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.FederationDownstreamConnectMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.MessagePacketI;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.NodeAnnounceMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.QuorumVoteMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.QuorumVoteReplyMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.RemoveProducerMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationAddMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationAddTXMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationCommitMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationDeleteMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationDeleteTXMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationLargeMessageBeginMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationLargeMessageEndMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationLargeMessageWriteMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationPageEventMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationPageWriteMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationPrepareMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationPrimaryIsStoppingMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationResponseMessageV2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationStartSyncMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationSyncFileMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ScaleDownAnnounceMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionAcknowledgeMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionConsumerFlowCreditMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionRequestProducerCreditsMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionSendLargeMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionSendMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionSendMessage_1X;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionSendMessage_V2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionSendMessage_V3;
import org.apache.activemq.artemis.core.server.LargeServerMessage;

public class ServerPacketDecoder
extends ClientPacketDecoder {
    private static final long serialVersionUID = 3348673114388400766L;
    private final StorageManager storageManager;

    public ServerPacketDecoder(StorageManager storageManager) {
        assert (storageManager != null);
        this.storageManager = storageManager;
    }

    private SessionSendMessage decodeSessionSendMessage(ActiveMQBuffer in, CoreRemotingConnection connection) {
        Object sendMessage = connection.isVersionBeforeAddressChange() ? new SessionSendMessage_1X(new CoreMessage(this.coreMessageObjectPools)) : (connection.isVersionBeforeAsyncResponseChange() ? new SessionSendMessage(new CoreMessage(this.coreMessageObjectPools)) : (connection.isBeforeProducerMetricsChanged() ? new SessionSendMessage_V2(new CoreMessage(this.coreMessageObjectPools)) : new SessionSendMessage_V3(new CoreMessage(this.coreMessageObjectPools))));
        sendMessage.decode(in);
        return sendMessage;
    }

    private static SessionAcknowledgeMessage decodeSessionAcknowledgeMessage(ActiveMQBuffer in, CoreRemotingConnection connection) {
        SessionAcknowledgeMessage acknowledgeMessage = new SessionAcknowledgeMessage();
        acknowledgeMessage.decode(in);
        return acknowledgeMessage;
    }

    private static SessionRequestProducerCreditsMessage decodeRequestProducerCreditsMessage(ActiveMQBuffer in, CoreRemotingConnection connection) {
        SessionRequestProducerCreditsMessage requestProducerCreditsMessage = new SessionRequestProducerCreditsMessage();
        requestProducerCreditsMessage.decode(in);
        return requestProducerCreditsMessage;
    }

    private static SessionConsumerFlowCreditMessage decodeSessionConsumerFlowCreditMessage(ActiveMQBuffer in, CoreRemotingConnection connection) {
        SessionConsumerFlowCreditMessage sessionConsumerFlowCreditMessage = new SessionConsumerFlowCreditMessage();
        sessionConsumerFlowCreditMessage.decode(in);
        return sessionConsumerFlowCreditMessage;
    }

    public Packet decode(ActiveMQBuffer in, CoreRemotingConnection connection) {
        byte packetType = in.readByte();
        switch (packetType) {
            case 71: {
                return this.decodeSessionSendMessage(in, connection);
            }
            case 41: {
                return ServerPacketDecoder.decodeSessionAcknowledgeMessage(in, connection);
            }
            case 79: {
                return ServerPacketDecoder.decodeRequestProducerCreditsMessage(in, connection);
            }
            case 70: {
                return ServerPacketDecoder.decodeSessionConsumerFlowCreditMessage(in, connection);
            }
        }
        return this.slowPathDecode(in, packetType, connection);
    }

    private Packet slowPathDecode(ActiveMQBuffer in, byte packetType, CoreRemotingConnection connection) {
        Message message;
        PacketImpl packet = switch (packetType) {
            case 72 -> new SessionSendLargeMessage((Message)new CoreMessage());
            case 91 -> new ReplicationAddMessage(connection.isBeforeTwoEighteen());
            case 92 -> new ReplicationAddTXMessage(connection.isBeforeTwoEighteen());
            case 93 -> new ReplicationDeleteMessage();
            case 94 -> new ReplicationDeleteTXMessage();
            case 95 -> new ReplicationPrepareMessage();
            case 96 -> new ReplicationCommitMessage();
            case 90 -> new ReplicationResponseMessage();
            case -9 -> new ReplicationResponseMessageV2();
            case 97 -> new ReplicationPageWriteMessage(connection.isVersionUsingLongOnPageReplication(), this.coreMessageObjectPools);
            case 98 -> new ReplicationPageEventMessage(connection.isVersionUsingLongOnPageReplication());
            case 99 -> new ReplicationLargeMessageBeginMessage();
            case 100 -> new ReplicationLargeMessageEndMessage();
            case 101 -> new ReplicationLargeMessageWriteMessage();
            case 115 -> new BackupRegistrationMessage();
            case 116 -> new BackupReplicationStartFailedMessage();
            case 120 -> new ReplicationStartSyncMessage(connection.isBeforeTwoEighteen());
            case 103 -> new ReplicationSyncFileMessage();
            case 121 -> new ReplicationPrimaryIsStoppingMessage();
            case 125 -> new ClusterConnectMessage();
            case 126 -> new ClusterConnectReplyMessage();
            case 111 -> new NodeAnnounceMessage();
            case 127 -> new BackupRequestMessage();
            case -1 -> new BackupResponseMessage();
            case -2 -> new QuorumVoteMessage();
            case -3 -> new QuorumVoteReplyMessage();
            case -6 -> new ScaleDownAnnounceMessage();
            case -16 -> new FederationDownstreamConnectMessage();
            case -20 -> new CreateProducerMessage();
            case -21 -> new RemoveProducerMessage();
            default -> super.decode(packetType, connection);
        };
        packet.decode(in);
        if (packet instanceof MessagePacketI && (message = ((MessagePacketI)packet).getMessage()) instanceof LargeServerMessage) {
            assert (this.storageManager != null);
            ((LargeServerMessage)message).setStorageManager(this.storageManager);
        }
        return packet;
    }
}

