/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.httpclient.impl;

import javax.annotation.Nonnull;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.httpclient.HttpClientSupport;
import net.shibboleth.shared.httpclient.TLSSocketFactoryBuilder;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.opensaml.security.httpclient.impl.SecurityEnhancedTLSSocketFactory;
import org.opensaml.security.x509.tls.impl.ThreadLocalX509CredentialKeyManager;
import org.opensaml.security.x509.tls.impl.ThreadLocalX509TrustManager;

public final class SecurityEnhancedHttpClientSupport {
    private SecurityEnhancedHttpClientSupport() {
    }

    @Nonnull
    public static LayeredConnectionSocketFactory buildTLSSocketFactory() {
        return SecurityEnhancedHttpClientSupport.buildTLSSocketFactory(true, false);
    }

    @Nonnull
    public static LayeredConnectionSocketFactory buildTLSSocketFactoryWithClientTLS() {
        return SecurityEnhancedHttpClientSupport.buildTLSSocketFactory(true, true);
    }

    @Nonnull
    public static LayeredConnectionSocketFactory buildTLSSocketFactoryWithClientTLSOnly() {
        return SecurityEnhancedHttpClientSupport.buildTLSSocketFactory(false, true);
    }

    @Nonnull
    public static LayeredConnectionSocketFactory buildTLSSocketFactory(boolean supportTrustEngine, boolean supportClientTLS) {
        TLSSocketFactoryBuilder wrappedFactoryBuilder = new TLSSocketFactoryBuilder();
        if (supportTrustEngine || supportClientTLS) {
            if (supportTrustEngine) {
                wrappedFactoryBuilder.setTrustManagers(CollectionSupport.singletonList((Object)new ThreadLocalX509TrustManager()));
            }
            if (supportClientTLS) {
                wrappedFactoryBuilder.setKeyManagers(CollectionSupport.singletonList((Object)new ThreadLocalX509CredentialKeyManager()));
            }
            return new SecurityEnhancedTLSSocketFactory((LayeredConnectionSocketFactory)wrappedFactoryBuilder.build());
        }
        return HttpClientSupport.buildStrictTLSSocketFactory();
    }
}

