/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.IOException;
import jdbm.helper.TupleBrowser;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.AbstractCursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.cursor.Tuple;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.server.core.partition.impl.btree.jdbm.DupsContainer;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmTable;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DupsContainerCursor<K, V>
extends AbstractCursor<Tuple<K, DupsContainer<V>>> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger(Loggers.CURSOR_LOG.getName());
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private final JdbmTable<K, V> table;
    private jdbm.helper.Tuple<K, V> jdbmTuple = new jdbm.helper.Tuple();
    private Tuple<K, DupsContainer<V>> returnedTuple = new Tuple();
    private TupleBrowser<K, V> browser;
    private boolean valueAvailable;
    private Boolean forwardDirection;

    public DupsContainerCursor(JdbmTable<K, V> table) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating DupsContainerCursor {}", (Object)this);
        }
        if (!table.isDupsEnabled()) {
            throw new IllegalStateException(I18n.err(I18n.ERR_572, new Object[0]));
        }
        this.table = table;
    }

    private void clearValue() {
        this.returnedTuple.setKey(null);
        this.returnedTuple.setValue(null);
        this.jdbmTuple.setKey(null);
        this.jdbmTuple.setValue(null);
        this.valueAvailable = false;
    }

    @Override
    public boolean available() {
        return this.valueAvailable;
    }

    public void beforeKey(K key) throws CursorException {
        this.checkNotClosed();
        try {
            this.browser = this.table.getBTree().browse(key);
            this.forwardDirection = null;
            this.clearValue();
        }
        catch (IOException e) {
            throw new CursorException(e);
        }
    }

    public void afterKey(K key) throws CursorException {
        this.checkNotClosed();
        try {
            this.browser = this.table.getBTree().browse(key);
            this.forwardDirection = null;
            while (this.browser.getNext(this.jdbmTuple)) {
                this.checkNotClosed();
                K next = this.jdbmTuple.getKey();
                int nextCompared = this.table.getKeyComparator().compare(next, key);
                if (nextCompared <= 0) continue;
                this.browser.getPrevious(this.jdbmTuple);
                this.browser.getPrevious(this.jdbmTuple);
                this.forwardDirection = false;
                this.clearValue();
                return;
            }
            this.clearValue();
        }
        catch (IOException e) {
            throw new CursorException(e);
        }
    }

    public void beforeValue(K key, DupsContainer<V> value) throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_573, new Object[0]));
    }

    public void afterValue(K key, DupsContainer<V> value) throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_573, new Object[0]));
    }

    @Override
    public void before(Tuple<K, DupsContainer<V>> element) throws LdapException, CursorException {
        this.beforeKey(element.getKey());
    }

    @Override
    public void after(Tuple<K, DupsContainer<V>> element) throws CursorException {
        this.afterKey(element.getKey());
    }

    @Override
    public void beforeFirst() throws LdapException, CursorException {
        this.checkNotClosed();
        try {
            this.browser = this.table.getBTree().browse();
            this.forwardDirection = null;
            this.clearValue();
        }
        catch (IOException e) {
            throw new CursorException(e);
        }
    }

    @Override
    public void afterLast() throws LdapException, CursorException {
        this.checkNotClosed();
        try {
            this.browser = this.table.getBTree().browse(null);
            this.forwardDirection = null;
            this.clearValue();
        }
        catch (IOException e) {
            throw new CursorException(e);
        }
    }

    @Override
    public boolean first() throws LdapException, CursorException {
        this.beforeFirst();
        return this.next();
    }

    @Override
    public boolean last() throws LdapException, CursorException {
        this.afterLast();
        return this.previous();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean previous() throws LdapException, CursorException {
        this.checkNotClosed();
        if (this.browser == null) {
            this.afterLast();
        }
        try {
            boolean advanceSuccess = this.browser.getPrevious(this.jdbmTuple);
            if (this.forwardDirection == null) {
                if (!advanceSuccess) {
                    this.clearValue();
                    return false;
                }
                this.forwardDirection = false;
            } else if (this.forwardDirection.booleanValue()) {
                advanceSuccess = this.browser.getPrevious(this.jdbmTuple);
                this.forwardDirection = false;
            }
            this.valueAvailable = advanceSuccess;
            if (this.valueAvailable) {
                this.returnedTuple.setKey(this.jdbmTuple.getKey());
                this.returnedTuple.setValue(this.table.getDupsContainer((byte[])this.jdbmTuple.getValue()));
                return this.valueAvailable;
            }
            this.clearValue();
            return this.valueAvailable;
        }
        catch (IOException e) {
            throw new CursorException(e);
        }
    }

    @Override
    public boolean next() throws LdapException, CursorException {
        this.checkNotClosed();
        if (this.browser == null) {
            this.beforeFirst();
        }
        try {
            boolean advanceSuccess = this.browser.getNext(this.jdbmTuple);
            if (this.forwardDirection == null) {
                if (advanceSuccess) {
                    this.forwardDirection = true;
                } else {
                    this.clearValue();
                    return false;
                }
            }
            if (!this.forwardDirection.booleanValue()) {
                advanceSuccess = this.browser.getNext(this.jdbmTuple);
                this.forwardDirection = true;
            }
            this.valueAvailable = advanceSuccess;
            if (this.valueAvailable) {
                this.returnedTuple.setKey(this.jdbmTuple.getKey());
                this.returnedTuple.setValue(this.table.getDupsContainer((byte[])this.jdbmTuple.getValue()));
            } else {
                this.clearValue();
            }
            return this.valueAvailable;
        }
        catch (IOException e) {
            throw new CursorException(e);
        }
    }

    @Override
    public Tuple<K, DupsContainer<V>> get() throws CursorException {
        this.checkNotClosed();
        if (this.valueAvailable) {
            return this.returnedTuple;
        }
        throw new InvalidCursorPositionException();
    }

    @Override
    public void close() throws IOException {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing DupsContainerCursor {}", (Object)this);
        }
        super.close();
    }

    @Override
    public void close(Exception cause) throws IOException {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing DupsContainerCursor {}", (Object)this);
        }
        super.close(cause);
    }
}

