/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.multipleinput.output;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.multipleinput.output.ExceptionInMultipleInputOperatorException;
import org.apache.flink.table.runtime.operators.multipleinput.output.OutputBase;
import org.apache.flink.util.OutputTag;

public class CopyingSecondInputOfTwoInputStreamOperatorOutput
extends OutputBase {
    private final TwoInputStreamOperator<RowData, RowData, RowData> operator;
    private final TypeSerializer<RowData> serializer;

    public CopyingSecondInputOfTwoInputStreamOperatorOutput(TwoInputStreamOperator<RowData, RowData, RowData> operator, TypeSerializer<RowData> serializer) {
        super((StreamOperator<?>)operator);
        this.operator = operator;
        this.serializer = serializer;
    }

    public void emitWatermark(Watermark mark) {
        try {
            this.operator.processWatermark2(mark);
        }
        catch (Exception e) {
            throw new ExceptionInMultipleInputOperatorException(e);
        }
    }

    public void emitWatermarkStatus(WatermarkStatus watermarkStatus) {
        try {
            this.operator.processWatermarkStatus2(watermarkStatus);
        }
        catch (Exception e) {
            throw new ExceptionInMultipleInputOperatorException(e);
        }
    }

    public void emitLatencyMarker(LatencyMarker latencyMarker) {
        try {
            this.operator.processLatencyMarker2(latencyMarker);
        }
        catch (Exception e) {
            throw new ExceptionInMultipleInputOperatorException(e);
        }
    }

    public void collect(StreamRecord<RowData> record) {
        this.pushToOperator(record);
    }

    public <X> void collect(OutputTag<X> outputTag, StreamRecord<X> record) {
        this.pushToOperator(record);
    }

    protected <X> void pushToOperator(StreamRecord<X> record) {
        try {
            StreamRecord<X> castRecord = record;
            StreamRecord copy = castRecord.copy(this.serializer.copy(castRecord.getValue()));
            this.operator.processElement2(copy);
        }
        catch (Exception e) {
            throw new ExceptionInMultipleInputOperatorException(e);
        }
    }
}

