/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.v2.Cell;
import com.google.bigtable.v2.Column;
import com.google.bigtable.v2.Family;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowAdapter;
import com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;

public class DefaultRowAdapter
implements RowAdapter<Row> {
    @Override
    public boolean isScanMarkerRow(Row row) {
        return row.getCells().isEmpty();
    }

    @Override
    public RowAdapter.RowBuilder<Row> createRowBuilder() {
        return new DefaultRowBuilder();
    }

    @Override
    public ByteString getKey(Row row) {
        return row.getKey();
    }

    @InternalApi
    public Row createRowFromProto(com.google.bigtable.v2.Row row) {
        RowAdapter.RowBuilder<Row> builder = this.createRowBuilder();
        builder.startRow(row.getKey());
        for (Family family : row.getFamiliesList()) {
            for (Column column : family.getColumnsList()) {
                for (Cell cell : column.getCellsList()) {
                    builder.startCell(family.getName(), column.getQualifier(), cell.getTimestampMicros(), (List<String>)cell.getLabelsList(), cell.getValue().size());
                    builder.cellValue(cell.getValue());
                    builder.finishCell();
                }
            }
        }
        return builder.finishRow();
    }

    public class DefaultRowBuilder
    implements RowAdapter.RowBuilder<Row> {
        private ByteString currentKey;
        private TreeMap<String, ImmutableList.Builder<RowCell>> cellsByFamily;
        private ImmutableList.Builder<RowCell> currentFamilyCells;
        private String previousFamily;
        private int totalCellCount;
        private String family;
        private ByteString qualifier;
        private List<String> labels;
        private long timestamp;
        private ByteString value;

        public DefaultRowBuilder() {
            this.reset();
        }

        @Override
        public Row createScanMarkerRow(ByteString key) {
            return Row.create(key, (List<RowCell>)ImmutableList.of());
        }

        @Override
        public void startRow(ByteString key) {
            this.currentKey = key;
        }

        @Override
        public void startCell(String family, ByteString qualifier, long timestamp, List<String> labels, long size) {
            this.family = family;
            this.qualifier = qualifier;
            this.timestamp = timestamp;
            this.labels = labels;
            this.value = ByteString.EMPTY;
        }

        @Override
        public void cellValue(ByteString value) {
            this.value = this.value.concat(value);
        }

        @Override
        public void finishCell() {
            if (!Objects.equals(this.family, this.previousFamily)) {
                this.previousFamily = this.family;
                this.currentFamilyCells = ImmutableList.builder();
                this.cellsByFamily.put(this.family, this.currentFamilyCells);
            }
            RowCell rowCell = RowCell.create(this.family, this.qualifier, this.timestamp, this.labels, this.value);
            this.currentFamilyCells.add((Object)rowCell);
            ++this.totalCellCount;
        }

        @Override
        public Row finishRow() {
            ImmutableList sortedCells;
            if (this.cellsByFamily.size() == 0) {
                sortedCells = ImmutableList.of();
            } else if (this.cellsByFamily.size() == 1) {
                sortedCells = this.currentFamilyCells.build();
            } else {
                ImmutableList.Builder sortedCellsBuilder = ImmutableList.builder();
                for (ImmutableList.Builder<RowCell> familyCells : this.cellsByFamily.values()) {
                    sortedCellsBuilder.addAll((Iterable)familyCells.build());
                }
                sortedCells = sortedCellsBuilder.build();
            }
            return Row.create(this.currentKey, (List<RowCell>)sortedCells);
        }

        @Override
        public void reset() {
            this.currentKey = null;
            this.cellsByFamily = new TreeMap();
            this.currentFamilyCells = null;
            this.previousFamily = null;
            this.totalCellCount = 0;
            this.family = null;
            this.qualifier = null;
            this.labels = null;
            this.timestamp = 0L;
            this.value = null;
        }
    }
}

