/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.MutationApi;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Range;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import java.io.Serializable;
import javax.annotation.Nonnull;

public final class RowMutation
implements MutationApi<RowMutation>,
Serializable {
    private static final long serialVersionUID = 6529002234913236318L;
    private final String tableId;
    private final ByteString key;
    private final Mutation mutation;

    private RowMutation(String tableId, ByteString key, Mutation mutation) {
        this.tableId = tableId;
        this.key = key;
        this.mutation = mutation;
    }

    public static RowMutation create(@Nonnull String tableId, @Nonnull String key) {
        return RowMutation.create(tableId, ByteString.copyFromUtf8(key));
    }

    public static RowMutation create(@Nonnull String tableId, @Nonnull ByteString key) {
        return new RowMutation(tableId, key, Mutation.create());
    }

    public static RowMutation create(@Nonnull String tableId, @Nonnull String key, @Nonnull Mutation mutation) {
        return RowMutation.create(tableId, ByteString.copyFromUtf8(key), mutation);
    }

    public static RowMutation create(@Nonnull String tableId, @Nonnull ByteString key, @Nonnull Mutation mutation) {
        return new RowMutation(tableId, key, mutation);
    }

    @Override
    public RowMutation setCell(@Nonnull String familyName, @Nonnull String qualifier, @Nonnull String value) {
        this.mutation.setCell(familyName, qualifier, value);
        return this;
    }

    @Override
    public RowMutation setCell(@Nonnull String familyName, @Nonnull String qualifier, long timestamp, @Nonnull String value) {
        this.mutation.setCell(familyName, qualifier, timestamp, value);
        return this;
    }

    @Override
    public RowMutation setCell(@Nonnull String familyName, @Nonnull ByteString qualifier, @Nonnull ByteString value) {
        this.mutation.setCell(familyName, qualifier, value);
        return this;
    }

    @Override
    public RowMutation setCell(@Nonnull String familyName, @Nonnull ByteString qualifier, long timestamp, @Nonnull ByteString value) {
        this.mutation.setCell(familyName, qualifier, timestamp, value);
        return this;
    }

    @Override
    public RowMutation setCell(@Nonnull String familyName, @Nonnull String qualifier, long value) {
        this.mutation.setCell(familyName, qualifier, value);
        return this;
    }

    @Override
    public RowMutation setCell(@Nonnull String familyName, @Nonnull String qualifier, long timestamp, long value) {
        this.mutation.setCell(familyName, qualifier, timestamp, value);
        return this;
    }

    @Override
    public RowMutation setCell(@Nonnull String familyName, @Nonnull ByteString qualifier, long value) {
        this.mutation.setCell(familyName, qualifier, value);
        return this;
    }

    @Override
    public RowMutation setCell(@Nonnull String familyName, @Nonnull ByteString qualifier, long timestamp, long value) {
        this.mutation.setCell(familyName, qualifier, timestamp, value);
        return this;
    }

    @Override
    public RowMutation deleteCells(@Nonnull String familyName, @Nonnull String qualifier) {
        this.mutation.deleteCells(familyName, qualifier);
        return this;
    }

    @Override
    public RowMutation deleteCells(@Nonnull String familyName, @Nonnull ByteString qualifier) {
        this.mutation.deleteCells(familyName, qualifier);
        return this;
    }

    @Override
    public RowMutation deleteCells(@Nonnull String familyName, @Nonnull ByteString qualifier, @Nonnull Range.TimestampRange timestampRange) {
        this.mutation.deleteCells(familyName, qualifier, timestampRange);
        return this;
    }

    @Override
    public RowMutation deleteFamily(@Nonnull String familyName) {
        this.mutation.deleteFamily(familyName);
        return this;
    }

    @Override
    public RowMutation deleteRow() {
        this.mutation.deleteRow();
        return this;
    }

    @InternalApi
    public MutateRowRequest toProto(RequestContext requestContext) {
        String tableName = NameUtil.formatTableName(requestContext.getProjectId(), requestContext.getInstanceId(), this.tableId);
        return MutateRowRequest.newBuilder().setAppProfileId(requestContext.getAppProfileId()).setTableName(tableName).setRowKey(this.key).addAllMutations(this.mutation.getMutations()).build();
    }

    @InternalApi
    public MutateRowsRequest toBulkProto(RequestContext requestContext) {
        String tableName = NameUtil.formatTableName(requestContext.getProjectId(), requestContext.getInstanceId(), this.tableId);
        return MutateRowsRequest.newBuilder().setAppProfileId(requestContext.getAppProfileId()).setTableName(tableName).addEntries(MutateRowsRequest.Entry.newBuilder().setRowKey(this.key).addAllMutations(this.mutation.getMutations()).build()).build();
    }

    @BetaApi
    public static RowMutation fromProto(@Nonnull MutateRowRequest request) {
        String tableId = NameUtil.extractTableIdFromTableName(request.getTableName());
        return RowMutation.create(tableId, request.getRowKey(), Mutation.fromProto(request.getMutationsList()));
    }
}

