/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.org.threeten.bp.temporal;

import com.google.bigtable.repackaged.org.threeten.bp.DateTimeException;
import com.google.bigtable.repackaged.org.threeten.bp.temporal.TemporalField;
import java.io.Serializable;

public final class ValueRange
implements Serializable {
    private static final long serialVersionUID = -7317881728594519368L;
    private final long minSmallest;
    private final long minLargest;
    private final long maxSmallest;
    private final long maxLargest;

    public static ValueRange of(long min, long max) {
        if (min > max) {
            throw new IllegalArgumentException("Minimum value must be less than maximum value");
        }
        return new ValueRange(min, min, max, max);
    }

    public static ValueRange of(long min, long maxSmallest, long maxLargest) {
        return ValueRange.of(min, min, maxSmallest, maxLargest);
    }

    public static ValueRange of(long minSmallest, long minLargest, long maxSmallest, long maxLargest) {
        if (minSmallest > minLargest) {
            throw new IllegalArgumentException("Smallest minimum value must be less than largest minimum value");
        }
        if (maxSmallest > maxLargest) {
            throw new IllegalArgumentException("Smallest maximum value must be less than largest maximum value");
        }
        if (minLargest > maxLargest) {
            throw new IllegalArgumentException("Minimum value must be less than maximum value");
        }
        return new ValueRange(minSmallest, minLargest, maxSmallest, maxLargest);
    }

    private ValueRange(long minSmallest, long minLargest, long maxSmallest, long maxLargest) {
        this.minSmallest = minSmallest;
        this.minLargest = minLargest;
        this.maxSmallest = maxSmallest;
        this.maxLargest = maxLargest;
    }

    public boolean isFixed() {
        return this.minSmallest == this.minLargest && this.maxSmallest == this.maxLargest;
    }

    public long getMinimum() {
        return this.minSmallest;
    }

    public long getLargestMinimum() {
        return this.minLargest;
    }

    public long getSmallestMaximum() {
        return this.maxSmallest;
    }

    public long getMaximum() {
        return this.maxLargest;
    }

    public boolean isIntValue() {
        return this.getMinimum() >= Integer.MIN_VALUE && this.getMaximum() <= Integer.MAX_VALUE;
    }

    public boolean isValidValue(long value) {
        return value >= this.getMinimum() && value <= this.getMaximum();
    }

    public boolean isValidIntValue(long value) {
        return this.isIntValue() && this.isValidValue(value);
    }

    public long checkValidValue(long value, TemporalField field) {
        if (!this.isValidValue(value)) {
            if (field != null) {
                throw new DateTimeException("Invalid value for " + field + " (valid values " + this + "): " + value);
            }
            throw new DateTimeException("Invalid value (valid values " + this + "): " + value);
        }
        return value;
    }

    public int checkValidIntValue(long value, TemporalField field) {
        if (!this.isValidIntValue(value)) {
            throw new DateTimeException("Invalid int value for " + field + ": " + value);
        }
        return (int)value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ValueRange) {
            ValueRange other = (ValueRange)obj;
            return this.minSmallest == other.minSmallest && this.minLargest == other.minLargest && this.maxSmallest == other.maxSmallest && this.maxLargest == other.maxLargest;
        }
        return false;
    }

    public int hashCode() {
        long hash = this.minSmallest + this.minLargest << (int)(16L + this.minLargest) >> (int)(48L + this.maxSmallest) << (int)(32L + this.maxSmallest) >> (int)(32L + this.maxLargest) << (int)(48L + this.maxLargest) >> 16;
        return (int)(hash ^ hash >>> 32);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.minSmallest);
        if (this.minSmallest != this.minLargest) {
            buf.append('/').append(this.minLargest);
        }
        buf.append(" - ").append(this.maxSmallest);
        if (this.maxSmallest != this.maxLargest) {
            buf.append('/').append(this.maxLargest);
        }
        return buf.toString();
    }
}

