/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.cloud.bigtable.hbase.AbstractBigtableRegionLocator;
import com.google.cloud.bigtable.hbase.util.Logger;
import com.google.cloud.bigtable.hbase.wrappers.BigtableHBaseSettings;
import com.google.cloud.bigtable.hbase.wrappers.DataClientWrapper;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

@InternalApi(value="For internal usage only")
public abstract class BigtableRegionLocator
extends AbstractBigtableRegionLocator
implements RegionLocator {
    protected static final Logger LOG = new Logger(BigtableRegionLocator.class);

    public BigtableRegionLocator(TableName tableName, BigtableHBaseSettings settings, DataClientWrapper client) {
        super(tableName, settings, client);
    }

    public HRegionLocation getRegionLocation(byte[] row) throws IOException {
        return this.getRegionLocation(row, false);
    }

    public HRegionLocation getRegionLocation(byte[] row, boolean reload) throws IOException {
        List<HRegionLocation> regions = this.getRegions(reload);
        return this.findRegion(regions, row);
    }

    private HRegionLocation findRegion(List<HRegionLocation> regions, byte[] row) throws IOException {
        int low = 0;
        int high = regions.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            HRegionLocation regionLocation = regions.get(mid);
            HRegionInfo regionInfo = regionLocation.getRegionInfo();
            if (regionInfo.getEndKey().length > 0 && Bytes.compareTo((byte[])row, (byte[])regionInfo.getEndKey()) >= 0) {
                low = mid + 1;
                continue;
            }
            if (Bytes.compareTo((byte[])row, (byte[])regionInfo.getStartKey()) < 0) {
                high = mid - 1;
                continue;
            }
            return regionLocation;
        }
        throw new IOException("Region not found for row: " + Bytes.toStringBinary((byte[])row));
    }

    private List<HRegionLocation> getRegions(boolean reload) throws IOException {
        try {
            return (List)this.getRegionsAsync(reload).get();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new IOException("getRegionLocation was interrupted");
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException("getRegionLocation ExecutionException", e);
        }
    }

    public List<HRegionLocation> getAllRegionLocations() throws IOException {
        return this.getRegions(false);
    }

    public byte[][] getStartKeys() throws IOException {
        return (byte[][])this.getStartEndKeys().getFirst();
    }

    public byte[][] getEndKeys() throws IOException {
        return (byte[][])this.getStartEndKeys().getSecond();
    }

    public Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
        List<HRegionLocation> regions = this.getAllRegionLocations();
        byte[][] startKeys = new byte[regions.size()][];
        byte[][] endKeys = new byte[regions.size()][];
        int i = 0;
        for (HRegionLocation region : regions) {
            startKeys[i] = region.getRegionInfo().getStartKey();
            endKeys[i] = region.getRegionInfo().getEndKey();
            ++i;
        }
        return Pair.newPair((Object)startKeys, (Object)endKeys);
    }

    public TableName getName() {
        return this.tableName;
    }

    public void close() throws IOException {
    }
}

