/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.BlockStoragePolicySpi;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.local.LocalConfigKeys;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.AclUtil;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.viewfs.ChRootedFs;
import org.apache.hadoop.fs.viewfs.Constants;
import org.apache.hadoop.fs.viewfs.InodeTree;
import org.apache.hadoop.fs.viewfs.NotInMountpointException;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import org.apache.hadoop.fs.viewfs.ViewFsFileStatus;
import org.apache.hadoop.fs.viewfs.ViewFsLocatedFileStatus;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ViewFs
extends AbstractFileSystem {
    static final Logger LOG = LoggerFactory.getLogger(ViewFs.class);
    final long creationTime;
    final UserGroupInformation ugi;
    final Configuration config;
    InodeTree<AbstractFileSystem> fsState;
    Path homeDir = null;
    private ViewFileSystem.RenameStrategy renameStrategy = ViewFileSystem.RenameStrategy.SAME_MOUNTPOINT;
    private static boolean showMountLinksAsSymlinks = true;

    static AccessControlException readOnlyMountTable(String operation, String p) {
        return new AccessControlException("InternalDir of ViewFileSystem is readonly, operation " + operation + " not permitted on path " + p + ".");
    }

    static AccessControlException readOnlyMountTable(String operation, Path p) {
        return ViewFs.readOnlyMountTable(operation, p.toString());
    }

    String getType() {
        return "viewfs";
    }

    public ViewFs(Configuration conf) throws IOException, URISyntaxException {
        this(FsConstants.VIEWFS_URI, conf);
    }

    ViewFs(URI theUri, Configuration conf) throws IOException, URISyntaxException {
        super(theUri, "viewfs", false, -1);
        this.creationTime = Time.now();
        this.ugi = UserGroupInformation.getCurrentUser();
        this.config = conf;
        showMountLinksAsSymlinks = this.config.getBoolean("fs.viewfs.mount.links.as.symlinks", true);
        String authority = theUri.getAuthority();
        boolean initingUriAsFallbackOnNoMounts = !"viewfs".equals(this.getType());
        this.fsState = new InodeTree<AbstractFileSystem>(conf, authority, theUri, initingUriAsFallbackOnNoMounts){

            @Override
            protected Function<URI, AbstractFileSystem> initAndGetTargetFs() {
                return new Function<URI, AbstractFileSystem>(){

                    @Override
                    public AbstractFileSystem apply(final URI uri) {
                        try {
                            AbstractFileSystem fs = ViewFs.this.ugi.doAs(new PrivilegedExceptionAction<AbstractFileSystem>(){

                                @Override
                                public AbstractFileSystem run() throws IOException {
                                    return AbstractFileSystem.createFileSystem(uri, ViewFs.this.config);
                                }
                            });
                            String pathString = uri.getPath();
                            if (pathString.isEmpty()) {
                                pathString = "/";
                            }
                            return new ChRootedFs(fs, new Path(pathString));
                        }
                        catch (IOException | InterruptedException | URISyntaxException ex) {
                            LOG.error("Could not initialize underlying FileSystem object for uri " + uri + "with exception: " + ex.toString());
                            return null;
                        }
                    }
                };
            }

            @Override
            protected AbstractFileSystem getTargetFileSystem(InodeTree.INodeDir<AbstractFileSystem> dir) throws URISyntaxException {
                return new InternalDirOfViewFs(dir, ViewFs.this.creationTime, ViewFs.this.ugi, ViewFs.this.getUri(), this, ViewFs.this.config);
            }

            @Override
            protected AbstractFileSystem getTargetFileSystem(String settings, URI[] mergeFsURIList) throws URISyntaxException, UnsupportedFileSystemException {
                throw new UnsupportedFileSystemException("mergefs not implemented yet");
            }
        };
        this.renameStrategy = ViewFileSystem.RenameStrategy.valueOf(conf.get("fs.viewfs.rename.strategy", ViewFileSystem.RenameStrategy.SAME_MOUNTPOINT.toString()));
    }

    @Override
    @Deprecated
    public FsServerDefaults getServerDefaults() throws IOException {
        return LocalConfigKeys.getServerDefaults();
    }

    @Override
    public FsServerDefaults getServerDefaults(Path f) throws IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res;
        try {
            res = this.fsState.resolve(this.getUriPath(f), true);
        }
        catch (FileNotFoundException fnfe) {
            return LocalConfigKeys.getServerDefaults();
        }
        return ((AbstractFileSystem)res.targetFileSystem).getServerDefaults(res.remainingPath);
    }

    @Override
    public int getUriDefaultPort() {
        return -1;
    }

    @Override
    public Path getHomeDirectory() {
        if (this.homeDir == null) {
            String base = this.fsState.getHomeDirPrefixValue();
            if (base == null) {
                base = "/user";
            }
            this.homeDir = base.equals("/") ? this.makeQualified(new Path(base + this.ugi.getShortUserName())) : this.makeQualified(new Path(base + "/" + this.ugi.getShortUserName()));
        }
        return this.homeDir;
    }

    @Override
    public Path resolvePath(Path f) throws FileNotFoundException, AccessControlException, UnresolvedLinkException, IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        if (res.isInternalDir()) {
            return f;
        }
        return ((AbstractFileSystem)res.targetFileSystem).resolvePath(res.remainingPath);
    }

    @Override
    public FSDataOutputStream createInternal(Path f, EnumSet<CreateFlag> flag, FsPermission absolutePermission, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnsupportedFileSystemException, UnresolvedLinkException, IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res;
        try {
            res = this.fsState.resolve(this.getUriPath(f), false);
        }
        catch (FileNotFoundException e) {
            if (createParent) {
                throw ViewFs.readOnlyMountTable("create", f);
            }
            throw e;
        }
        assert (res.remainingPath != null);
        return ((AbstractFileSystem)res.targetFileSystem).createInternal(res.remainingPath, flag, absolutePermission, bufferSize, replication, blockSize, progress, checksumOpt, createParent);
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        if (res.isInternalDir() || res.remainingPath == InodeTree.SlashPath) {
            throw new AccessControlException("Cannot delete internal mount table directory: " + f);
        }
        return ((AbstractFileSystem)res.targetFileSystem).delete(res.remainingPath, recursive);
    }

    @Override
    public BlockLocation[] getFileBlockLocations(Path f, long start, long len) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((AbstractFileSystem)res.targetFileSystem).getFileBlockLocations(res.remainingPath, start, len);
    }

    @Override
    public FileChecksum getFileChecksum(Path f) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((AbstractFileSystem)res.targetFileSystem).getFileChecksum(res.remainingPath);
    }

    @Override
    public FileStatus getFileStatus(Path f) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        FileStatus status = ((AbstractFileSystem)res.targetFileSystem).getFileStatus(res.remainingPath);
        return new ViewFsFileStatus(status, this.makeQualified(f));
    }

    @Override
    public void access(Path path, FsAction mode) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((AbstractFileSystem)res.targetFileSystem).access(res.remainingPath, mode);
    }

    @Override
    public FileStatus getFileLinkStatus(Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(f), false);
        return ((AbstractFileSystem)res.targetFileSystem).getFileLinkStatus(res.remainingPath);
    }

    @Override
    public FsStatus getFsStatus() throws AccessControlException, FileNotFoundException, IOException {
        return new FsStatus(0L, 0L, 0L);
    }

    @Override
    public RemoteIterator<FileStatus> listStatusIterator(Path f) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        RemoteIterator<FileStatus> fsIter = ((AbstractFileSystem)res.targetFileSystem).listStatusIterator(res.remainingPath);
        if (res.isInternalDir()) {
            return fsIter;
        }
        return new WrappingRemoteIterator<FileStatus>(res, fsIter, f){

            @Override
            public FileStatus getViewFsFileStatus(FileStatus stat, Path newPath) {
                return new ViewFsFileStatus(stat, newPath);
            }
        };
    }

    @Override
    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        RemoteIterator<LocatedFileStatus> fsIter = ((AbstractFileSystem)res.targetFileSystem).listLocatedStatus(res.remainingPath);
        if (res.isInternalDir()) {
            return fsIter;
        }
        return new WrappingRemoteIterator<LocatedFileStatus>(res, fsIter, f){

            @Override
            public LocatedFileStatus getViewFsFileStatus(LocatedFileStatus stat, Path newPath) {
                return new ViewFsLocatedFileStatus(stat, newPath);
            }
        };
    }

    @Override
    public FileStatus[] listStatus(Path f) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        FileStatus[] statusLst = ((AbstractFileSystem)res.targetFileSystem).listStatus(res.remainingPath);
        if (!res.isInternalDir()) {
            ChRootedFs targetFs = (ChRootedFs)res.targetFileSystem;
            int i = 0;
            for (FileStatus status : statusLst) {
                String suffix = targetFs.stripOutRoot(status.getPath());
                statusLst[i++] = new ViewFsFileStatus(status, this.makeQualified(suffix.length() == 0 ? f : new Path(res.resolvedPath, suffix)));
            }
        }
        return statusLst;
    }

    @Override
    public void mkdir(Path dir, FsPermission permission, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, UnresolvedLinkException, IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(dir), false);
        ((AbstractFileSystem)res.targetFileSystem).mkdir(res.remainingPath, permission, createParent);
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((AbstractFileSystem)res.targetFileSystem).open(res.remainingPath, bufferSize);
    }

    @Override
    public boolean truncate(Path f, long newLength) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((AbstractFileSystem)res.targetFileSystem).truncate(res.remainingPath, newLength);
    }

    @Override
    public void renameInternal(Path src, Path dst, boolean overwrite) throws IOException, UnresolvedLinkException {
        InodeTree.ResolveResult<AbstractFileSystem> resDst;
        InodeTree.ResolveResult<AbstractFileSystem> resSrc = this.fsState.resolve(this.getUriPath(src), false);
        if (resSrc.isInternalDir()) {
            if (this.fsState.getRootFallbackLink() == null) {
                throw new AccessControlException("Cannot Rename within internal dirs of mount table: src=" + src + " is readOnly");
            }
            InodeTree.ResolveResult<AbstractFileSystem> resSrcWithLastComp = this.fsState.resolve(this.getUriPath(src), true);
            if (resSrcWithLastComp.isInternalDir() || resSrcWithLastComp.isLastInternalDirLink()) {
                throw new AccessControlException("Cannot Rename within internal dirs of mount table: src=" + src + " is readOnly");
            }
            resSrc = resSrcWithLastComp;
        }
        if ((resDst = this.fsState.resolve(this.getUriPath(dst), false)).isInternalDir()) {
            if (this.fsState.getRootFallbackLink() == null) {
                throw new AccessControlException("Cannot Rename within internal dirs of mount table: dest=" + dst + " is readOnly");
            }
            InodeTree.ResolveResult<AbstractFileSystem> resDstWithLastComp = this.fsState.resolve(this.getUriPath(dst), true);
            resDst = resDstWithLastComp.isInternalDir() ? new InodeTree.ResolveResult<AbstractFileSystem>(InodeTree.ResultKind.INTERNAL_DIR, this.fsState.getRootFallbackLink().getTargetFileSystem(), "/", new Path(resDstWithLastComp.resolvedPath), false) : resDstWithLastComp;
        }
        URI srcUri = ((AbstractFileSystem)resSrc.targetFileSystem).getUri();
        URI dstUri = ((AbstractFileSystem)resDst.targetFileSystem).getUri();
        ViewFileSystem.verifyRenameStrategy(srcUri, dstUri, resSrc.targetFileSystem == resDst.targetFileSystem, this.renameStrategy);
        ChRootedFs srcFS = (ChRootedFs)resSrc.targetFileSystem;
        ChRootedFs dstFS = (ChRootedFs)resDst.targetFileSystem;
        srcFS.getMyFs().renameInternal(srcFS.fullPath(resSrc.remainingPath), dstFS.fullPath(resDst.remainingPath), overwrite);
    }

    @Override
    public void renameInternal(Path src, Path dst) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnresolvedLinkException, IOException {
        this.renameInternal(src, dst, false);
    }

    @Override
    public boolean supportsSymlinks() {
        return true;
    }

    @Override
    public void createSymlink(Path target, Path link, boolean createParent) throws IOException, UnresolvedLinkException {
        InodeTree.ResolveResult<AbstractFileSystem> res;
        try {
            res = this.fsState.resolve(this.getUriPath(link), false);
        }
        catch (FileNotFoundException e) {
            if (createParent) {
                throw ViewFs.readOnlyMountTable("createSymlink", link);
            }
            throw e;
        }
        assert (res.remainingPath != null);
        ((AbstractFileSystem)res.targetFileSystem).createSymlink(target, res.remainingPath, createParent);
    }

    @Override
    public Path getLinkTarget(Path f) throws IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(f), false);
        return ((AbstractFileSystem)res.targetFileSystem).getLinkTarget(res.remainingPath);
    }

    @Override
    public void setOwner(Path f, String username, String groupname) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        ((AbstractFileSystem)res.targetFileSystem).setOwner(res.remainingPath, username, groupname);
    }

    @Override
    public void setPermission(Path f, FsPermission permission) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        ((AbstractFileSystem)res.targetFileSystem).setPermission(res.remainingPath, permission);
    }

    @Override
    public boolean setReplication(Path f, short replication) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((AbstractFileSystem)res.targetFileSystem).setReplication(res.remainingPath, replication);
    }

    @Override
    public void setTimes(Path f, long mtime, long atime) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        ((AbstractFileSystem)res.targetFileSystem).setTimes(res.remainingPath, mtime, atime);
    }

    @Override
    public void setVerifyChecksum(boolean verifyChecksum) throws AccessControlException, IOException {
    }

    public MountPoint[] getMountPoints() {
        List<InodeTree.MountPoint<AbstractFileSystem>> mountPoints = this.fsState.getMountPoints();
        MountPoint[] result = new MountPoint[mountPoints.size()];
        for (int i = 0; i < mountPoints.size(); ++i) {
            result[i] = new MountPoint(new Path(mountPoints.get((int)i).src), mountPoints.get((int)i).target.targetDirLinkList);
        }
        return result;
    }

    @Override
    public List<Token<?>> getDelegationTokens(String renewer) throws IOException {
        List<InodeTree.MountPoint<AbstractFileSystem>> mountPoints = this.fsState.getMountPoints();
        int initialListSize = 0;
        for (InodeTree.MountPoint<AbstractFileSystem> im : mountPoints) {
            initialListSize += im.target.targetDirLinkList.length;
        }
        ArrayList result = new ArrayList(initialListSize);
        for (int i = 0; i < mountPoints.size(); ++i) {
            List<Token<?>> tokens = ((AbstractFileSystem)mountPoints.get((int)i).target.getTargetFileSystem()).getDelegationTokens(renewer);
            if (tokens == null) continue;
            result.addAll(tokens);
        }
        return result;
    }

    @Override
    public boolean isValidName(String src) {
        return true;
    }

    @Override
    public void modifyAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((AbstractFileSystem)res.targetFileSystem).modifyAclEntries(res.remainingPath, aclSpec);
    }

    @Override
    public void removeAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((AbstractFileSystem)res.targetFileSystem).removeAclEntries(res.remainingPath, aclSpec);
    }

    @Override
    public void removeDefaultAcl(Path path) throws IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((AbstractFileSystem)res.targetFileSystem).removeDefaultAcl(res.remainingPath);
    }

    @Override
    public void removeAcl(Path path) throws IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((AbstractFileSystem)res.targetFileSystem).removeAcl(res.remainingPath);
    }

    @Override
    public void setAcl(Path path, List<AclEntry> aclSpec) throws IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((AbstractFileSystem)res.targetFileSystem).setAcl(res.remainingPath, aclSpec);
    }

    @Override
    public AclStatus getAclStatus(Path path) throws IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        return ((AbstractFileSystem)res.targetFileSystem).getAclStatus(res.remainingPath);
    }

    @Override
    public void setXAttr(Path path, String name, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((AbstractFileSystem)res.targetFileSystem).setXAttr(res.remainingPath, name, value, flag);
    }

    @Override
    public byte[] getXAttr(Path path, String name) throws IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        return ((AbstractFileSystem)res.targetFileSystem).getXAttr(res.remainingPath, name);
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        return ((AbstractFileSystem)res.targetFileSystem).getXAttrs(res.remainingPath);
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        return ((AbstractFileSystem)res.targetFileSystem).getXAttrs(res.remainingPath, names);
    }

    @Override
    public List<String> listXAttrs(Path path) throws IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        return ((AbstractFileSystem)res.targetFileSystem).listXAttrs(res.remainingPath);
    }

    @Override
    public void removeXAttr(Path path, String name) throws IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((AbstractFileSystem)res.targetFileSystem).removeXAttr(res.remainingPath, name);
    }

    @Override
    public Path createSnapshot(Path path, String snapshotName) throws IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        return ((AbstractFileSystem)res.targetFileSystem).createSnapshot(res.remainingPath, snapshotName);
    }

    @Override
    public void renameSnapshot(Path path, String snapshotOldName, String snapshotNewName) throws IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((AbstractFileSystem)res.targetFileSystem).renameSnapshot(res.remainingPath, snapshotOldName, snapshotNewName);
    }

    @Override
    public void deleteSnapshot(Path path, String snapshotName) throws IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((AbstractFileSystem)res.targetFileSystem).deleteSnapshot(res.remainingPath, snapshotName);
    }

    @Override
    public void satisfyStoragePolicy(Path path) throws IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((AbstractFileSystem)res.targetFileSystem).satisfyStoragePolicy(res.remainingPath);
    }

    @Override
    public void setStoragePolicy(Path path, String policyName) throws IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((AbstractFileSystem)res.targetFileSystem).setStoragePolicy(res.remainingPath, policyName);
    }

    @Override
    public void unsetStoragePolicy(Path src) throws IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(src), true);
        ((AbstractFileSystem)res.targetFileSystem).unsetStoragePolicy(res.remainingPath);
    }

    @Override
    public BlockStoragePolicySpi getStoragePolicy(Path src) throws IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(src), true);
        return ((AbstractFileSystem)res.targetFileSystem).getStoragePolicy(res.remainingPath);
    }

    static class InternalDirOfViewFs
    extends AbstractFileSystem {
        final InodeTree.INodeDir<AbstractFileSystem> theInternalDir;
        final long creationTime;
        final UserGroupInformation ugi;
        final URI myUri;
        private InodeTree<AbstractFileSystem> fsState;
        private Configuration conf;

        public InternalDirOfViewFs(InodeTree.INodeDir<AbstractFileSystem> dir, long cTime, UserGroupInformation ugi, URI uri, InodeTree fsState, Configuration conf) throws URISyntaxException {
            super(FsConstants.VIEWFS_URI, "viewfs", false, -1);
            this.theInternalDir = dir;
            this.creationTime = cTime;
            this.ugi = ugi;
            this.myUri = uri;
            this.fsState = fsState;
            this.conf = conf;
        }

        private static void checkPathIsSlash(Path f) throws IOException {
            if (f != InodeTree.SlashPath) {
                throw new IOException("Internal implementation error: expected file name to be /");
            }
        }

        @Override
        public FSDataOutputStream createInternal(Path f, EnumSet<CreateFlag> flag, FsPermission absolutePermission, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnsupportedFileSystemException, UnresolvedLinkException, IOException {
            Preconditions.checkNotNull((Object)f, (Object)"File cannot be null.");
            if (InodeTree.SlashPath.equals(f)) {
                throw new FileAlreadyExistsException("/ is not a file. The directory / already exist at: " + this.theInternalDir.fullPath);
            }
            if (this.fsState.getRootFallbackLink() != null) {
                if (this.theInternalDir.getChildren().containsKey(f.getName())) {
                    throw new FileAlreadyExistsException("A mount path(file/dir) already exist with the requested path: " + this.theInternalDir.getChildren().get((Object)f.getName()).fullPath);
                }
                AbstractFileSystem linkedFallbackFs = this.fsState.getRootFallbackLink().getTargetFileSystem();
                Path parent = Path.getPathWithoutSchemeAndAuthority(new Path(this.theInternalDir.fullPath));
                String leaf = f.getName();
                Path fileToCreate = new Path(parent, leaf);
                try {
                    return linkedFallbackFs.createInternal(fileToCreate, flag, absolutePermission, bufferSize, replication, blockSize, progress, checksumOpt, true);
                }
                catch (IOException e) {
                    StringBuilder msg = new StringBuilder("Failed to create file:").append(fileToCreate).append(" at fallback : ").append(linkedFallbackFs.getUri());
                    LOG.error(msg.toString(), (Throwable)e);
                    throw e;
                }
            }
            throw ViewFs.readOnlyMountTable("create", f);
        }

        @Override
        public boolean delete(Path f, boolean recursive) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw ViewFs.readOnlyMountTable("delete", f);
        }

        @Override
        public BlockLocation[] getFileBlockLocations(Path f, long start, long len) throws FileNotFoundException, IOException {
            if (!InodeTree.SlashPath.equals(f) && this.fsState.getRootFallbackLink() != null) {
                AbstractFileSystem linkedFallbackFs = this.fsState.getRootFallbackLink().getTargetFileSystem();
                Path parent = Path.getPathWithoutSchemeAndAuthority(new Path(this.theInternalDir.fullPath));
                Path pathToFallbackFs = new Path(parent, f.getName());
                return linkedFallbackFs.getFileBlockLocations(pathToFallbackFs, start, len);
            }
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw new FileNotFoundException("Path points to dir not a file");
        }

        @Override
        public FileChecksum getFileChecksum(Path f) throws FileNotFoundException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw new FileNotFoundException("Path points to dir not a file");
        }

        @Override
        public FileStatus getFileStatus(Path f) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            return new FileStatus(0L, true, 0, 0L, this.creationTime, this.creationTime, Constants.PERMISSION_555, this.ugi.getShortUserName(), this.ugi.getPrimaryGroupName(), new Path(this.theInternalDir.fullPath).makeQualified(this.myUri, null));
        }

        @Override
        public FileStatus getFileLinkStatus(Path f) throws IOException {
            FileStatus result;
            InodeTree.INode<AbstractFileSystem> inode = this.theInternalDir.getChildren().get(f.toUri().toString().substring(1));
            if (inode == null) {
                throw new FileNotFoundException("viewFs internal mount table - missing entry:" + f);
            }
            if (inode.isLink()) {
                InodeTree.INodeLink inodelink = (InodeTree.INodeLink)inode;
                try {
                    String linkedPath = ((AbstractFileSystem)inodelink.getTargetFileSystem()).getUri().getPath();
                    FileStatus status = ((ChRootedFs)inodelink.getTargetFileSystem()).getMyFs().getFileStatus(new Path(linkedPath));
                    result = new FileStatus(status.getLen(), false, status.getReplication(), status.getBlockSize(), status.getModificationTime(), status.getAccessTime(), status.getPermission(), status.getOwner(), status.getGroup(), inodelink.getTargetLink(), new Path(inode.fullPath).makeQualified(this.myUri, null));
                }
                catch (FileNotFoundException ex) {
                    result = new FileStatus(0L, false, 0, 0L, this.creationTime, this.creationTime, Constants.PERMISSION_555, this.ugi.getShortUserName(), this.ugi.getPrimaryGroupName(), inodelink.getTargetLink(), new Path(inode.fullPath).makeQualified(this.myUri, null));
                }
            } else {
                result = new FileStatus(0L, true, 0, 0L, this.creationTime, this.creationTime, Constants.PERMISSION_555, this.ugi.getShortUserName(), this.ugi.getPrimaryGroupName(), new Path(inode.fullPath).makeQualified(this.myUri, null));
            }
            return result;
        }

        @Override
        public FsStatus getFsStatus() {
            return new FsStatus(0L, 0L, 0L);
        }

        @Override
        @Deprecated
        public FsServerDefaults getServerDefaults() throws IOException {
            return LocalConfigKeys.getServerDefaults();
        }

        @Override
        public FsServerDefaults getServerDefaults(Path f) throws IOException {
            return LocalConfigKeys.getServerDefaults();
        }

        @Override
        public int getUriDefaultPort() {
            return -1;
        }

        @Override
        public FileStatus[] listStatus(Path f) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            FileStatus[] fallbackStatuses = this.listStatusForFallbackLink();
            HashSet<FileStatus> linkStatuses = new HashSet<FileStatus>();
            HashSet<FileStatus> internalDirStatuses = new HashSet<FileStatus>();
            boolean i = false;
            for (Map.Entry<String, InodeTree.INode<AbstractFileSystem>> iEntry : this.theInternalDir.getChildren().entrySet()) {
                InodeTree.INode<AbstractFileSystem> inode = iEntry.getValue();
                Path path = new Path(inode.fullPath).makeQualified(this.myUri, null);
                if (inode.isLink()) {
                    InodeTree.INodeLink link = (InodeTree.INodeLink)inode;
                    if (showMountLinksAsSymlinks) {
                        linkStatuses.add(new FileStatus(0L, false, 0, 0L, this.creationTime, this.creationTime, Constants.PERMISSION_555, this.ugi.getShortUserName(), this.ugi.getPrimaryGroupName(), link.getTargetLink(), path));
                        continue;
                    }
                    String linkedPath = ((AbstractFileSystem)link.getTargetFileSystem()).getUri().getPath();
                    if ("".equals(linkedPath)) {
                        linkedPath = "/";
                    }
                    try {
                        FileStatus status = ((ChRootedFs)link.getTargetFileSystem()).getMyFs().getFileStatus(new Path(linkedPath));
                        linkStatuses.add(new FileStatus(status.getLen(), status.isDirectory(), status.getReplication(), status.getBlockSize(), status.getModificationTime(), status.getAccessTime(), status.getPermission(), status.getOwner(), status.getGroup(), null, path));
                        continue;
                    }
                    catch (FileNotFoundException ex) {
                        LOG.warn("Cannot get one of the children's(" + path + ")  target path(" + ((AbstractFileSystem)link.getTargetFileSystem()).getUri() + ") file status.", (Throwable)ex);
                        throw ex;
                    }
                }
                internalDirStatuses.add(new FileStatus(0L, true, 0, 0L, this.creationTime, this.creationTime, Constants.PERMISSION_555, this.ugi.getShortUserName(), this.ugi.getPrimaryGroupName(), path));
            }
            FileStatus[] internalDirStatusesMergedWithFallBack = internalDirStatuses.toArray(new FileStatus[internalDirStatuses.size()]);
            if (fallbackStatuses.length > 0) {
                internalDirStatusesMergedWithFallBack = this.merge(fallbackStatuses, internalDirStatusesMergedWithFallBack);
            }
            return this.merge(linkStatuses.toArray(new FileStatus[linkStatuses.size()]), internalDirStatusesMergedWithFallBack);
        }

        private FileStatus[] merge(FileStatus[] toStatuses, FileStatus[] fromStatuses) {
            ArrayList<FileStatus> result = new ArrayList<FileStatus>();
            HashSet<String> pathSet = new HashSet<String>();
            for (FileStatus status : toStatuses) {
                result.add(status);
                pathSet.add(status.getPath().getName());
            }
            for (FileStatus status : fromStatuses) {
                if (pathSet.contains(status.getPath().getName())) continue;
                result.add(status);
            }
            return result.toArray(new FileStatus[result.size()]);
        }

        private FileStatus[] listStatusForFallbackLink() throws IOException {
            if (this.fsState.getRootFallbackLink() != null) {
                AbstractFileSystem linkedFallbackFs = this.fsState.getRootFallbackLink().getTargetFileSystem();
                Path p = Path.getPathWithoutSchemeAndAuthority(new Path(this.theInternalDir.fullPath));
                if (this.theInternalDir.isRoot() || FileContext.getFileContext(linkedFallbackFs, this.conf).util().exists(p)) {
                    FileStatus[] statuses;
                    for (FileStatus status : statuses = linkedFallbackFs.listStatus(p)) {
                        Path pathFromConfiguredFallbackRoot = new Path(p, status.getPath().getName());
                        status.setPath(new Path(this.myUri.toString(), pathFromConfiguredFallbackRoot));
                    }
                    return statuses;
                }
            }
            return new FileStatus[0];
        }

        @Override
        public void mkdir(Path dir, FsPermission permission, boolean createParent) throws IOException {
            if (this.theInternalDir.isRoot() && dir == null) {
                throw new FileAlreadyExistsException("/ already exits");
            }
            if (this.fsState.getRootFallbackLink() != null) {
                AbstractFileSystem linkedFallbackFs = this.fsState.getRootFallbackLink().getTargetFileSystem();
                Path parent = Path.getPathWithoutSchemeAndAuthority(new Path(this.theInternalDir.fullPath));
                String leafChild = InodeTree.SlashPath.equals(dir) ? InodeTree.SlashPath.toString() : dir.getName();
                Path dirToCreate = new Path(parent, leafChild);
                try {
                    linkedFallbackFs.mkdir(dirToCreate, permission, true);
                    return;
                }
                catch (IOException e) {
                    if (LOG.isDebugEnabled()) {
                        StringBuilder msg = new StringBuilder("Failed to create {}").append(" at fallback fs : {}");
                        LOG.debug(msg.toString(), (Object)dirToCreate, (Object)linkedFallbackFs.getUri());
                    }
                    throw e;
                }
            }
            throw ViewFs.readOnlyMountTable("mkdir", dir);
        }

        @Override
        public FSDataInputStream open(Path f, int bufferSize) throws FileNotFoundException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw new FileNotFoundException("Path points to dir not a file");
        }

        @Override
        public boolean truncate(Path f, long newLength) throws FileNotFoundException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw ViewFs.readOnlyMountTable("truncate", f);
        }

        @Override
        public void renameInternal(Path src, Path dst) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(src);
            InternalDirOfViewFs.checkPathIsSlash(dst);
            throw ViewFs.readOnlyMountTable("rename", src);
        }

        @Override
        public boolean supportsSymlinks() {
            return true;
        }

        @Override
        public void createSymlink(Path target, Path link, boolean createParent) throws AccessControlException {
            throw ViewFs.readOnlyMountTable("createSymlink", link);
        }

        @Override
        public Path getLinkTarget(Path f) throws FileNotFoundException, IOException {
            return this.getFileLinkStatus(f).getSymlink();
        }

        @Override
        public void setOwner(Path f, String username, String groupname) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw ViewFs.readOnlyMountTable("setOwner", f);
        }

        @Override
        public void setPermission(Path f, FsPermission permission) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw ViewFs.readOnlyMountTable("setPermission", f);
        }

        @Override
        public boolean setReplication(Path f, short replication) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw ViewFs.readOnlyMountTable("setReplication", f);
        }

        @Override
        public void setTimes(Path f, long mtime, long atime) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw ViewFs.readOnlyMountTable("setTimes", f);
        }

        @Override
        public void setVerifyChecksum(boolean verifyChecksum) throws AccessControlException {
            throw ViewFs.readOnlyMountTable("setVerifyChecksum", "");
        }

        @Override
        public void modifyAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFs.readOnlyMountTable("modifyAclEntries", path);
        }

        @Override
        public void removeAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFs.readOnlyMountTable("removeAclEntries", path);
        }

        @Override
        public void removeDefaultAcl(Path path) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFs.readOnlyMountTable("removeDefaultAcl", path);
        }

        @Override
        public void removeAcl(Path path) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFs.readOnlyMountTable("removeAcl", path);
        }

        @Override
        public void setAcl(Path path, List<AclEntry> aclSpec) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFs.readOnlyMountTable("setAcl", path);
        }

        @Override
        public AclStatus getAclStatus(Path path) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            return new AclStatus.Builder().owner(this.ugi.getShortUserName()).group(this.ugi.getPrimaryGroupName()).addEntries(AclUtil.getMinimalAcl(Constants.PERMISSION_555)).stickyBit(false).build();
        }

        @Override
        public void setXAttr(Path path, String name, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFs.readOnlyMountTable("setXAttr", path);
        }

        @Override
        public byte[] getXAttr(Path path, String name) throws IOException {
            throw new NotInMountpointException(path, "getXAttr");
        }

        @Override
        public Map<String, byte[]> getXAttrs(Path path) throws IOException {
            throw new NotInMountpointException(path, "getXAttrs");
        }

        @Override
        public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
            throw new NotInMountpointException(path, "getXAttrs");
        }

        @Override
        public List<String> listXAttrs(Path path) throws IOException {
            throw new NotInMountpointException(path, "listXAttrs");
        }

        @Override
        public void removeXAttr(Path path, String name) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFs.readOnlyMountTable("removeXAttr", path);
        }

        @Override
        public Path createSnapshot(Path path, String snapshotName) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFs.readOnlyMountTable("createSnapshot", path);
        }

        @Override
        public void renameSnapshot(Path path, String snapshotOldName, String snapshotNewName) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFs.readOnlyMountTable("renameSnapshot", path);
        }

        @Override
        public void deleteSnapshot(Path path, String snapshotName) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFs.readOnlyMountTable("deleteSnapshot", path);
        }

        @Override
        public void satisfyStoragePolicy(Path path) throws IOException {
            throw ViewFs.readOnlyMountTable("satisfyStoragePolicy", path);
        }

        @Override
        public void setStoragePolicy(Path path, String policyName) throws IOException {
            throw ViewFs.readOnlyMountTable("setStoragePolicy", path);
        }
    }

    private abstract class WrappingRemoteIterator<T extends FileStatus>
    implements RemoteIterator<T> {
        private final String resolvedPath;
        private final ChRootedFs targetFs;
        private final RemoteIterator<T> innerIter;
        private final Path originalPath;

        WrappingRemoteIterator(InodeTree.ResolveResult<AbstractFileSystem> res, RemoteIterator<T> innerIter, Path originalPath) {
            this.resolvedPath = res.resolvedPath;
            this.targetFs = (ChRootedFs)res.targetFileSystem;
            this.innerIter = innerIter;
            this.originalPath = originalPath;
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.innerIter.hasNext();
        }

        @Override
        public T next() throws IOException {
            FileStatus status = (FileStatus)this.innerIter.next();
            String suffix = this.targetFs.stripOutRoot(status.getPath());
            Path newPath = ViewFs.this.makeQualified(suffix.length() == 0 ? this.originalPath : new Path(this.resolvedPath, suffix));
            return (T)this.getViewFsFileStatus(status, newPath);
        }

        protected abstract T getViewFsFileStatus(T var1, Path var2);
    }

    public static class MountPoint {
        private Path src;
        private URI[] targets;

        MountPoint(Path srcPath, URI[] targetURIs) {
            this.src = srcPath;
            this.targets = targetURIs;
        }

        Path getSrc() {
            return this.src;
        }

        URI[] getTargets() {
            return this.targets;
        }
    }
}

