/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.splunkinput;

import com.splunk.Args;
import com.splunk.Event;
import com.splunk.JobArgs;
import com.splunk.ResultsReaderXml;
import com.splunk.Service;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePreviewFactory;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.splunkinput.ReturnValue;
import org.apache.hop.pipeline.transforms.splunkinput.SplunkInputMeta;
import org.apache.hop.splunk.SplunkConnection;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterNumberDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.dialog.PipelinePreviewProgressDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SplunkInputDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = SplunkInputMeta.class;
    private Text wTransformName;
    private MetaSelectionLine<SplunkConnection> wConnection;
    private Text wQuery;
    private TableView wReturns;
    private final SplunkInputMeta input;

    public SplunkInputDialog(Shell parent, IVariables variables, Object inputMetadata, PipelineMeta pipelineMeta, String transformName) {
        super(parent, variables, (BaseTransformMeta)inputMetadata, pipelineMeta, transformName);
        this.input = (SplunkInputMeta)((Object)inputMetadata);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        FormLayout shellLayout = new FormLayout();
        this.shell.setLayout((Layout)shellLayout);
        this.shell.setText("Splunk Input");
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        ScrolledComposite wScrolledComposite = new ScrolledComposite((Composite)this.shell, 768);
        FormLayout scFormLayout = new FormLayout();
        wScrolledComposite.setLayout((Layout)scFormLayout);
        FormData fdSComposite = new FormData();
        fdSComposite.left = new FormAttachment(0, 0);
        fdSComposite.right = new FormAttachment(100, 0);
        fdSComposite.top = new FormAttachment(0, 0);
        fdSComposite.bottom = new FormAttachment(100, 0);
        wScrolledComposite.setLayoutData((Object)fdSComposite);
        Composite wComposite = new Composite((Composite)wScrolledComposite, 0);
        this.props.setLook((Control)wComposite);
        FormData fdComposite = new FormData();
        fdComposite.left = new FormAttachment(0, 0);
        fdComposite.right = new FormAttachment(100, 0);
        fdComposite.top = new FormAttachment(0, 0);
        fdComposite.bottom = new FormAttachment(100, 0);
        wComposite.setLayoutData((Object)fdComposite);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        wComposite.setLayout((Layout)formLayout);
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wOk = new Button(wComposite, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wPreview = new Button(wComposite, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"System.Button.Preview", (String[])new String[0]));
        this.wPreview.addListener(13, e -> this.preview());
        this.wCancel = new Button(wComposite, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wPreview, this.wCancel}, margin, null);
        Label wlTransformName = new Label(wComposite, 131072);
        wlTransformName.setText("Transform name");
        this.props.setLook((Control)wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text(wComposite, 18436);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment((Control)wlTransformName, 0, 0x1000000);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Text lastControl = this.wTransformName;
        this.wConnection = new MetaSelectionLine(this.variables, this.metadataProvider, SplunkConnection.class, wComposite, 16388, "Splunk Connection", "Select, create or edit a Splunk Connection");
        this.props.setLook(this.wConnection);
        this.wConnection.addModifyListener(lsMod);
        FormData fdConnection = new FormData();
        fdConnection.left = new FormAttachment(0, 0);
        fdConnection.right = new FormAttachment(100, 0);
        fdConnection.top = new FormAttachment((Control)lastControl, margin);
        this.wConnection.setLayoutData((Object)fdConnection);
        lastControl = this.wConnection;
        Label wlQuery = new Label(wComposite, 16384);
        wlQuery.setText("Query:");
        this.props.setLook((Control)wlQuery);
        FormData fdlQuery = new FormData();
        fdlQuery.left = new FormAttachment(0, 0);
        fdlQuery.right = new FormAttachment(middle, -margin);
        fdlQuery.top = new FormAttachment(lastControl, margin);
        wlQuery.setLayoutData((Object)fdlQuery);
        this.wQuery = new Text(wComposite, 19202);
        this.wQuery.setFont(GuiResource.getInstance().getFontFixed());
        this.props.setLook((Control)this.wQuery);
        this.wQuery.addModifyListener(lsMod);
        FormData fdQuery = new FormData();
        fdQuery.left = new FormAttachment(0, 0);
        fdQuery.right = new FormAttachment(100, 0);
        fdQuery.top = new FormAttachment((Control)wlQuery, margin);
        fdQuery.bottom = new FormAttachment(60, 0);
        this.wQuery.setLayoutData((Object)fdQuery);
        lastControl = this.wQuery;
        ColumnInfo[] returnColumns = new ColumnInfo[]{new ColumnInfo("Field name", 1, false), new ColumnInfo("Splunk name", 1, false), new ColumnInfo("Return type", 2, ValueMetaFactory.getAllValueMetaNames(), false), new ColumnInfo("Length", 1, false), new ColumnInfo("Format", 1, false)};
        Label wlReturns = new Label(wComposite, 16384);
        wlReturns.setText("Returns");
        this.props.setLook((Control)wlReturns);
        FormData fdlReturns = new FormData();
        fdlReturns.left = new FormAttachment(0, 0);
        fdlReturns.right = new FormAttachment(middle, -margin);
        fdlReturns.top = new FormAttachment((Control)lastControl, margin);
        wlReturns.setLayoutData((Object)fdlReturns);
        Button wbGetReturnFields = new Button(wComposite, 8);
        wbGetReturnFields.setText("Get Output Fields");
        FormData fdbGetReturnFields = new FormData();
        fdbGetReturnFields.right = new FormAttachment(100, 0);
        fdbGetReturnFields.top = new FormAttachment((Control)lastControl, margin);
        wbGetReturnFields.setLayoutData((Object)fdbGetReturnFields);
        wbGetReturnFields.addListener(13, e -> this.getReturnValues());
        lastControl = wbGetReturnFields;
        this.wReturns = new TableView(this.variables, wComposite, 67586, returnColumns, this.input.getReturnValues().size(), lsMod, this.props);
        this.props.setLook((Control)this.wReturns);
        this.wReturns.addModifyListener(lsMod);
        FormData fdReturns = new FormData();
        fdReturns.left = new FormAttachment(0, 0);
        fdReturns.right = new FormAttachment(100, 0);
        fdReturns.top = new FormAttachment((Control)lastControl, margin);
        fdReturns.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wReturns.setLayoutData((Object)fdReturns);
        wComposite.pack();
        Rectangle bounds = wComposite.getBounds();
        wScrolledComposite.setContent((Control)wComposite);
        wScrolledComposite.setExpandHorizontal(true);
        wScrolledComposite.setExpandVertical(true);
        wScrolledComposite.setMinWidth(bounds.width);
        wScrolledComposite.setMinHeight(bounds.height);
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    public void getData() {
        this.wTransformName.setText(Const.NVL((String)this.transformName, (String)""));
        this.wConnection.setText(Const.NVL((String)this.input.getConnectionName(), (String)""));
        try {
            List elementNames = this.metadataProvider.getSerializer(SplunkConnection.class).listObjectNames();
            Collections.sort(elementNames);
            this.wConnection.setItems(elementNames.toArray(new String[0]));
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error", "Unable to list Splunk connections", e);
        }
        this.wQuery.setText(Const.NVL((String)this.input.getQuery(), (String)""));
        for (int i = 0; i < this.input.getReturnValues().size(); ++i) {
            ReturnValue returnValue = this.input.getReturnValues().get(i);
            TableItem item = this.wReturns.table.getItem(i);
            item.setText(1, Const.NVL((String)returnValue.getName(), (String)""));
            item.setText(2, Const.NVL((String)returnValue.getSplunkName(), (String)""));
            item.setText(3, Const.NVL((String)returnValue.getType(), (String)""));
            item.setText(4, returnValue.getLength() < 0 ? "" : Integer.toString(returnValue.getLength()));
            item.setText(5, Const.NVL((String)returnValue.getFormat(), (String)""));
        }
        this.wReturns.removeEmptyRows();
        this.wReturns.setRowNums();
        this.wReturns.optWidth(true);
    }

    private void ok() {
        if (StringUtils.isEmpty((String)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.getInfo(this.input);
        this.dispose();
    }

    private void getInfo(SplunkInputMeta meta) {
        meta.setConnectionName(this.wConnection.getText());
        meta.setQuery(this.wQuery.getText());
        ArrayList<ReturnValue> returnValues = new ArrayList<ReturnValue>();
        for (int i = 0; i < this.wReturns.nrNonEmpty(); ++i) {
            TableItem item = this.wReturns.getNonEmpty(i);
            String name = item.getText(1);
            String splunkName = item.getText(2);
            String type = item.getText(3);
            int length = Const.toInt((String)item.getText(4), (int)-1);
            String format = item.getText(5);
            returnValues.add(new ReturnValue(name, splunkName, type, length, format));
        }
        meta.setReturnValues(returnValues);
    }

    private synchronized void preview() {
        SplunkInputMeta oneMeta = new SplunkInputMeta();
        this.getInfo(oneMeta);
        PipelineMeta previewMeta = PipelinePreviewFactory.generatePreviewPipeline((IHopMetadataProvider)this.metadataProvider, (ITransformMeta)oneMeta, (String)this.wTransformName.getText());
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"QueryDialog.PreviewSize.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"QueryDialog.PreviewSize.DialogMessage", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            PipelinePreviewProgressDialog progressDialog = new PipelinePreviewProgressDialog(this.shell, this.variables, previewMeta, new String[]{this.wTransformName.getText()}, new int[]{previewSize});
            progressDialog.open();
            Pipeline pipeline = progressDialog.getPipeline();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled() && pipeline.getResult() != null && pipeline.getResult().getNrErrors() > 0L) {
                EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                etd.setReadOnly();
                etd.open();
            }
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, this.variables, 0, this.wTransformName.getText(), progressDialog.getPreviewRowsMeta(this.wTransformName.getText()), progressDialog.getPreviewRows(this.wTransformName.getText()), loggingText);
            prd.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getReturnValues() {
        try {
            IHopMetadataSerializer serializer = this.metadataProvider.getSerializer(SplunkConnection.class);
            SplunkConnection splunkConnection = (SplunkConnection)serializer.load(this.variables.resolve(this.wConnection.getText()));
            Service service = Service.connect((Map)splunkConnection.getServiceArgs(this.variables));
            Args args = new Args();
            args.put((Object)"connection_mode", (Object)JobArgs.ExecutionMode.BLOCKING.name());
            HashSet<String> detectedKeys = new HashSet<String>();
            try (InputStream eventsStream = service.oneshotSearch(this.variables.resolve(this.wQuery.getText()), args);){
                Event event;
                ResultsReaderXml resultsReader = new ResultsReaderXml(eventsStream);
                int nrScanned = 0;
                while ((event = resultsReader.getNextEvent()) != null) {
                    for (String key : event.keySet()) {
                        detectedKeys.add(key);
                    }
                    if (++nrScanned <= 10) continue;
                    break;
                }
            }
            for (String detectedKey : detectedKeys) {
                TableItem item = new TableItem(this.wReturns.table, 0);
                item.setText(1, detectedKey);
                item.setText(2, detectedKey);
                item.setText(3, "String");
            }
            this.wReturns.removeEmptyRows();
            this.wReturns.setRowNums();
            this.wReturns.optWidth(true);
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error", "Error getting fields from Splunk query", e);
        }
    }
}

