/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.security.auth;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.AS400BasicAuthenticationCredential;
import com.ibm.as400.security.auth.AS400BasicAuthenticationPrincipal;
import com.ibm.as400.security.auth.AS400Credential;
import com.ibm.as400.security.auth.AS400Principal;
import com.ibm.as400.security.auth.AuthenticationSystem;
import com.ibm.as400.security.auth.ProfileTokenImpl;
import com.ibm.as400.security.auth.UserProfilePrincipal;
import java.beans.PropertyVetoException;
import java.util.Random;

public final class ProfileTokenCredential
extends AS400Credential
implements AS400BasicAuthenticationCredential {
    static final long serialVersionUID = 4L;
    private byte[] addr_ = new byte[9];
    private byte[] mask_ = new byte[7];
    private byte[] token_ = null;
    private int type_ = 1;
    private int timeoutInterval_ = 3600;
    private static final int MAX_USERPROFILE_LENGTH = 10;
    static final int MAX_PASSWORD_LENGTH = 128;
    public static final int TYPE_SINGLE_USE = 1;
    public static final int TYPE_MULTIPLE_USE_NON_RENEWABLE = 2;
    public static final int TYPE_MULTIPLE_USE_RENEWABLE = 3;
    public static final int TOKEN_LENGTH = 32;
    public static final int PW_NOPWD = 1;
    public static final int PW_NOPWDCHK = 2;
    private boolean noRefresh = false;
    static /* synthetic */ Class class$com$ibm$as400$security$auth$AS400Principal;

    public ProfileTokenCredential() {
        new Random().nextBytes(this.addr_);
        new Random().nextBytes(this.mask_);
    }

    public ProfileTokenCredential(AS400 aS400, byte[] byArray, int n, int n2) {
        this();
        try {
            this.setSystem(aS400);
            this.setToken(byArray);
            this.setTokenType(n);
            this.setTimeoutInterval(n2);
        }
        catch (PropertyVetoException propertyVetoException) {
            AuthenticationSystem.handleUnexpectedException(propertyVetoException);
        }
    }

    private static byte[] decode(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[byArray3.length];
        for (int i = 0; i < byArray3.length; ++i) {
            byArray4[i] = (byte)((byArray2[i % byArray2.length] ^ byArray3[i]) - byArray[i % byArray.length]);
        }
        return byArray4;
    }

    private static byte[] encode(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[byArray3.length];
        for (int i = 0; i < byArray3.length; ++i) {
            byArray4[i] = (byte)(byArray3[i] + byArray[i % byArray.length] ^ byArray2[i % byArray2.length]);
        }
        return byArray4;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof ProfileTokenCredential)) {
            return false;
        }
        return this.hashCode() == ((ProfileTokenCredential)object).hashCode();
    }

    public int getTimeoutInterval() {
        return this.timeoutInterval_;
    }

    public synchronized byte[] getToken() {
        if (this.token_ != null) {
            return this.primitiveGetToken();
        }
        return null;
    }

    public int getTokenType() {
        return this.type_;
    }

    public int superHashCode() {
        return super.hashCode();
    }

    public int hashCode() {
        int n = 104473;
        if (this.token_ != null) {
            byte[] byArray = this.getToken();
            for (int i = 0; i < byArray.length; ++i) {
                n ^= byArray[i];
            }
        }
        n ^= this.type_ ^ 0x3841;
        n ^= this.timeoutInterval_ ^ 0x534F;
        n ^= this.isPrivate() ? 15501 : 12003;
        if (this.getPrincipal() != null) {
            n ^= this.getPrincipal().hashCode();
        }
        if (this.getSystem() != null) {
            n ^= this.getSystem().getSystemName().hashCode();
        }
        return n;
    }

    String implClassNameNative() {
        return "com.ibm.as400.access.ProfileTokenImplNative";
    }

    String implClassNameRemote() {
        return "com.ibm.as400.security.auth.ProfileTokenImplRemote";
    }

    public void initialize(AS400BasicAuthenticationPrincipal aS400BasicAuthenticationPrincipal, String string, boolean bl, boolean bl2, boolean bl3, int n) throws Exception {
        if (Trace.isTraceOn()) {
            Trace.log(3, "Initializing credential >> " + this.toString() + ", for principal >> " + aS400BasicAuthenticationPrincipal.toString() + ", isPrivate == " + bl + ", isReusable == " + bl2 + ", isRenewable == " + bl3 + ", timeoutInterval == " + n);
        }
        if (bl3 && !bl2) {
            Trace.log(2, "Profile tokens must be multi-use if declared as regenerable.");
            throw new ExtendedIllegalArgumentException("isReusable", 2);
        }
        AS400 aS400 = AuthenticationSystem.localHost();
        this.setSystem(aS400);
        AS400Principal aS400Principal = (class$com$ibm$as400$security$auth$AS400Principal == null ? (class$com$ibm$as400$security$auth$AS400Principal = ProfileTokenCredential.class$("com.ibm.as400.security.auth.AS400Principal")) : class$com$ibm$as400$security$auth$AS400Principal).isAssignableFrom(aS400BasicAuthenticationPrincipal.getClass()) ? (AS400Principal)((Object)aS400BasicAuthenticationPrincipal) : new UserProfilePrincipal(aS400, aS400BasicAuthenticationPrincipal.getUserProfileName());
        this.setPrincipal(aS400Principal);
        this.private_ = bl;
        this.setTimeoutInterval(n);
        if (bl3) {
            this.setTokenType(3);
        } else if (bl2) {
            this.setTokenType(2);
        } else {
            this.setTokenType(1);
        }
        this.setTokenExtended(aS400Principal, string);
    }

    void invalidateProperties() {
        super.invalidateProperties();
        this.token_ = null;
    }

    public boolean isRenewable() {
        return this.type_ == 3;
    }

    public boolean isReusable() {
        return this.type_ == 2 || this.type_ == 3;
    }

    private byte[] primitiveGetToken() {
        if (Trace.isTraceOn()) {
            Trace.log(3, "ProfileTokenCredential@" + Integer.toHexString(this.superHashCode()) + " getPrimitiveToken called");
            if (!this.noRefresh) {
                // empty if block
            }
        }
        return ProfileTokenCredential.decode(this.addr_, this.mask_, this.token_);
    }

    private void primitiveSetToken(byte[] byArray) {
        this.token_ = ProfileTokenCredential.encode(this.addr_, this.mask_, byArray);
    }

    public void refresh() throws AS400SecurityException {
        this.refresh(this.getTokenType(), this.getTimeoutInterval());
    }

    public synchronized void refresh(int n, int n2) throws AS400SecurityException {
        while (this.noRefresh) {
            if (Trace.isTraceOn()) {
                Trace.log(3, "ProfileTokenCredential@" + Integer.toHexString(this.hashCode()) + " refresh stuck because of noRefresh");
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        if (Trace.isTraceOn()) {
            Trace.log(3, "ProfileTokenCredential@" + Integer.toHexString(this.hashCode()) + " refresh called");
        }
        this.checkAuthenticationPermission("refreshCredential");
        if (!this.isRenewable()) {
            return;
        }
        if (n < 1 || n > 3) {
            Trace.log(2, "Token type " + n + " out of range");
            throw new ExtendedIllegalArgumentException("type", 4);
        }
        if (n2 < 1 || n2 > 3600) {
            Trace.log(2, "Timeout interval " + n2 + " out of range");
            throw new ExtendedIllegalArgumentException("timeoutInterval", 4);
        }
        byte[] byArray = this.getToken();
        byte[] byArray2 = ((ProfileTokenImpl)this.getImpl()).refresh(n, n2);
        this.primitiveSetToken(byArray2);
        this.type_ = n;
        this.timeoutInterval_ = n2;
        this.fireRefreshed();
        this.firePropertyChange("token", byArray, byArray2);
        if (Trace.isTraceOn()) {
            Trace.log(3, "ProfileTokenCredential@" + Integer.toHexString(this.hashCode()) + " Credential refreshed with type " + n + " and timeoutInterval = " + n2 + " >> " + this.toString());
        }
    }

    public void setTimeoutInterval(int n) throws PropertyVetoException {
        this.validatePropertyChange("timeoutInterval");
        if (n < 1 || n > 3600) {
            Trace.log(2, "Number of seconds " + n + " out of range");
            throw new ExtendedIllegalArgumentException("seconds", 4);
        }
        Integer n2 = new Integer(this.timeoutInterval_);
        Integer n3 = new Integer(n);
        this.fireVetoableChange("timeoutInterval", n2, n3);
        this.timeoutInterval_ = n;
        this.firePropertyChange("timeoutInterval", n2, n3);
    }

    public synchronized void setToken(byte[] byArray) throws PropertyVetoException {
        this.validatePropertyChange("token");
        if (byArray == null) {
            Trace.log(2, "Token byte array is null");
            throw new ExtendedIllegalArgumentException("bytes", 2);
        }
        if (byArray.length != 32) {
            Trace.log(2, "Token of length " + byArray.length + " not valid ");
            throw new ExtendedIllegalArgumentException("bytes", 1);
        }
        byte[] byArray2 = this.getToken();
        this.fireVetoableChange("token", byArray2, byArray);
        this.primitiveSetToken(byArray);
        this.firePropertyChange("token", byArray2, byArray);
    }

    public void setToken(AS400Principal aS400Principal, String string) throws PropertyVetoException, AS400SecurityException {
        this.setToken(aS400Principal.getUserProfileName(), string);
    }

    public void setToken(String string, String string2) throws PropertyVetoException, AS400SecurityException {
        this.validatePropertySet("system", this.getSystem());
        if (string == null) {
            Trace.log(2, "User profile name is null");
            throw new ExtendedIllegalArgumentException("name", 2);
        }
        if (string.length() > 10) {
            Trace.log(2, "User profile name exceeds maximum allowed length");
            throw new ExtendedIllegalArgumentException("name", 1);
        }
        if (string2 == null) {
            Trace.log(2, "User profile password is null");
            throw new ExtendedIllegalArgumentException("password", 2);
        }
        ProfileTokenImpl profileTokenImpl = (ProfileTokenImpl)this.getImplPrimitive();
        this.setToken(profileTokenImpl.generateToken(string, string2, this.getTokenType(), this.getTimeoutInterval()));
        this.setImpl(profileTokenImpl);
        this.fireCreated();
    }

    public void setToken(AS400Principal aS400Principal, int n) throws PropertyVetoException, AS400SecurityException {
        this.setToken(aS400Principal.getUserProfileName(), n);
    }

    public void setToken(String string, int n) throws PropertyVetoException, AS400SecurityException {
        this.validatePropertySet("system", this.getSystem());
        if (string == null) {
            Trace.log(2, "User profile name is null");
            throw new ExtendedIllegalArgumentException("name", 2);
        }
        if (string.length() > 10) {
            Trace.log(2, "User profile name exceeds maximum allowed length");
            throw new ExtendedIllegalArgumentException("name", 1);
        }
        switch (n) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                Trace.log(2, "Special value for password is not valid");
                throw new ExtendedIllegalArgumentException("password", 2);
            }
        }
        ProfileTokenImpl profileTokenImpl = (ProfileTokenImpl)this.getImplPrimitive();
        this.setToken(profileTokenImpl.generateToken(string, n, this.getTokenType(), this.getTimeoutInterval()));
        this.setImpl(profileTokenImpl);
        this.fireCreated();
    }

    public void setTokenExtended(AS400Principal aS400Principal, String string) throws PropertyVetoException, AS400SecurityException {
        this.setTokenExtended(aS400Principal.getUserProfileName(), string);
    }

    public void setTokenExtended(String string, String string2) throws PropertyVetoException, AS400SecurityException {
        this.validatePropertySet("system", this.getSystem());
        if (string == null) {
            Trace.log(2, "User profile name is null");
            throw new ExtendedIllegalArgumentException("name", 2);
        }
        if (string.length() > 10) {
            Trace.log(2, "User profile name exceeds maximum allowed length");
            throw new ExtendedIllegalArgumentException("name", 1);
        }
        if (string2 == null) {
            Trace.log(2, "User profile password is null");
            throw new ExtendedIllegalArgumentException("password", 2);
        }
        ProfileTokenImpl profileTokenImpl = (ProfileTokenImpl)this.getImplPrimitive();
        this.setToken(profileTokenImpl.generateTokenExtended(string, string2, this.getTokenType(), this.getTimeoutInterval()));
        this.setImpl(profileTokenImpl);
        this.fireCreated();
    }

    public void setTokenType(int n) throws PropertyVetoException {
        this.validatePropertyChange("tokenType");
        if (n < 1 || n > 3) {
            Trace.log(2, "Token type " + n + " out of range");
            throw new ExtendedIllegalArgumentException("type", 4);
        }
        Integer n2 = new Integer(this.type_);
        Integer n3 = new Integer(n);
        this.fireVetoableChange("tokenType", n2, n3);
        this.type_ = n;
        this.firePropertyChange("tokenType", n2, n3);
    }

    public String toString() {
        return new StringBuffer(256).append(super.toString()).append('[').append(this.getTokenType()).append(',').append(this.getTimeoutInterval()).append(']').toString();
    }

    boolean typeIsStandalone() {
        return true;
    }

    boolean typeIsTimed() {
        return true;
    }

    void validateProperties() {
        super.validateProperties();
        this.validatePropertySet("token", this.getToken());
    }

    public synchronized void preventRefresh() throws InterruptedException {
        if (Trace.isTraceOn()) {
            Trace.log(3, "ProfileTokenCredential@" + Integer.toHexString(this.hashCode()) + " preventRefresh");
        }
        this.noRefresh = true;
    }

    public synchronized void allowRefresh() {
        if (Trace.isTraceOn()) {
            Trace.log(3, "ProfileTokenCredential@" + Integer.toHexString(this.hashCode()) + " allowRefresh");
        }
        this.noRefresh = false;
        this.notify();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

