/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.spi;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import org.drools.core.WorkingMemory;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.CompiledInvoker;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.Invoker;
import org.drools.core.spi.Tuple;
import org.kie.internal.security.KiePolicyHelper;

public interface ReturnValueExpression
extends Invoker {
    public Object createContext();

    public FieldValue evaluate(InternalFactHandle var1, Tuple var2, Declaration[] var3, Declaration[] var4, WorkingMemory var5, Object var6) throws Exception;

    public void replaceDeclaration(Declaration var1, Declaration var2);

    public static boolean isCompiledInvoker(ReturnValueExpression expression) {
        return expression instanceof CompiledInvoker || expression instanceof SafeReturnValueExpression && ((SafeReturnValueExpression)expression).wrapsCompiledInvoker();
    }

    public static class SafeReturnValueExpression
    implements ReturnValueExpression,
    Serializable {
        private static final long serialVersionUID = -5616989474935380093L;
        private ReturnValueExpression delegate;

        public SafeReturnValueExpression(ReturnValueExpression delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object createContext() {
            return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return delegate.createContext();
                }
            }, KiePolicyHelper.getAccessContext());
        }

        @Override
        public FieldValue evaluate(final InternalFactHandle handle, final Tuple tuple, final Declaration[] previousDeclarations, final Declaration[] localDeclarations, final WorkingMemory workingMemory, final Object context) throws Exception {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FieldValue>(){

                @Override
                public FieldValue run() throws Exception {
                    return delegate.evaluate(handle, tuple, previousDeclarations, localDeclarations, workingMemory, context);
                }
            }, KiePolicyHelper.getAccessContext());
        }

        @Override
        public void replaceDeclaration(Declaration declaration, Declaration resolved) {
            this.delegate.replaceDeclaration(declaration, resolved);
        }

        public boolean wrapsCompiledInvoker() {
            return this.delegate instanceof CompiledInvoker;
        }
    }
}

