/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.avro.transforms.avroencode;

import org.apache.hop.avro.transforms.avroencode.AvroEncodeMeta;
import org.apache.hop.avro.transforms.avroencode.SourceField;
import org.apache.hop.core.Const;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class AvroEncodeDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = AvroEncodeMeta.class;
    private AvroEncodeMeta input;
    private TextVar wOutputField;
    private TextVar wSchemaName;
    private TextVar wNamespace;
    private TextVar wDocumentation;
    private TableView wFields;

    public AvroEncodeDialog(Shell parent, IVariables variables, Object baseTransformMeta, PipelineMeta pipelineMeta, String transformName) {
        super(parent, variables, (BaseTransformMeta)baseTransformMeta, pipelineMeta, transformName);
        this.input = (AvroEncodeMeta)((Object)baseTransformMeta);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"AvroEncodeDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        this.wGet.addListener(13, e -> this.getFields());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wGet, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"AvroEncodeDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment((Control)this.wlTransformName, 0, 0x1000000);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Text lastControl = this.wTransformName;
        Label wlOutputField = new Label((Composite)this.shell, 131072);
        wlOutputField.setText(BaseMessages.getString(PKG, (String)"AvroEncodeDialog.OutputField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlOutputField);
        FormData fdlOutputField = new FormData();
        fdlOutputField.left = new FormAttachment(0, 0);
        fdlOutputField.right = new FormAttachment(middle, -margin);
        fdlOutputField.top = new FormAttachment((Control)lastControl, margin);
        wlOutputField.setLayoutData((Object)fdlOutputField);
        this.wOutputField = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wOutputField.setText(this.transformName);
        this.props.setLook((Control)this.wOutputField);
        FormData fdOutputField = new FormData();
        fdOutputField.left = new FormAttachment(middle, 0);
        fdOutputField.top = new FormAttachment((Control)wlOutputField, 0, 0x1000000);
        fdOutputField.right = new FormAttachment(100, 0);
        this.wOutputField.setLayoutData((Object)fdOutputField);
        lastControl = this.wOutputField;
        Label wlSchemaName = new Label((Composite)this.shell, 131072);
        wlSchemaName.setText(BaseMessages.getString(PKG, (String)"AvroEncodeDialog.SchemaName.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSchemaName);
        FormData fdlSchemaName = new FormData();
        fdlSchemaName.left = new FormAttachment(0, 0);
        fdlSchemaName.right = new FormAttachment(middle, -margin);
        fdlSchemaName.top = new FormAttachment((Control)lastControl, margin);
        wlSchemaName.setLayoutData((Object)fdlSchemaName);
        this.wSchemaName = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wSchemaName.setText(this.transformName);
        this.props.setLook((Control)this.wSchemaName);
        FormData fdSchemaName = new FormData();
        fdSchemaName.left = new FormAttachment(middle, 0);
        fdSchemaName.top = new FormAttachment((Control)wlSchemaName, 0, 0x1000000);
        fdSchemaName.right = new FormAttachment(100, 0);
        this.wSchemaName.setLayoutData((Object)fdSchemaName);
        lastControl = this.wSchemaName;
        Label wlNamespace = new Label((Composite)this.shell, 131072);
        wlNamespace.setText(BaseMessages.getString(PKG, (String)"AvroEncodeDialog.Namespace.Label", (String[])new String[0]));
        this.props.setLook((Control)wlNamespace);
        FormData fdlNamespace = new FormData();
        fdlNamespace.left = new FormAttachment(0, 0);
        fdlNamespace.right = new FormAttachment(middle, -margin);
        fdlNamespace.top = new FormAttachment((Control)lastControl, margin);
        wlNamespace.setLayoutData((Object)fdlNamespace);
        this.wNamespace = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wNamespace.setText(this.transformName);
        this.props.setLook((Control)this.wNamespace);
        FormData fdNamespace = new FormData();
        fdNamespace.left = new FormAttachment(middle, 0);
        fdNamespace.top = new FormAttachment((Control)wlNamespace, 0, 0x1000000);
        fdNamespace.right = new FormAttachment(100, 0);
        this.wNamespace.setLayoutData((Object)fdNamespace);
        lastControl = this.wNamespace;
        Label wlDocumentation = new Label((Composite)this.shell, 131072);
        wlDocumentation.setText(BaseMessages.getString(PKG, (String)"AvroEncodeDialog.Documentation.Label", (String[])new String[0]));
        this.props.setLook((Control)wlDocumentation);
        FormData fdlDocumentation = new FormData();
        fdlDocumentation.left = new FormAttachment(0, 0);
        fdlDocumentation.right = new FormAttachment(middle, -margin);
        fdlDocumentation.top = new FormAttachment((Control)lastControl, margin);
        wlDocumentation.setLayoutData((Object)fdlDocumentation);
        this.wDocumentation = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wDocumentation.setText(this.transformName);
        this.props.setLook((Control)this.wDocumentation);
        FormData fdDocumentation = new FormData();
        fdDocumentation.left = new FormAttachment(middle, 0);
        fdDocumentation.top = new FormAttachment((Control)wlDocumentation, 0, 0x1000000);
        fdDocumentation.right = new FormAttachment(100, 0);
        this.wDocumentation.setLayoutData((Object)fdDocumentation);
        lastControl = this.wDocumentation;
        Label wlFields = new Label((Composite)this.shell, 131072);
        wlFields.setText(BaseMessages.getString(PKG, (String)"AvroEncodeDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.right = new FormAttachment(middle, -margin);
        fdlFields.top = new FormAttachment((Control)lastControl, margin);
        wlFields.setLayoutData((Object)fdlFields);
        ColumnInfo[] fieldsColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroEncodeDialog.Fields.Column.SourceField", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroEncodeDialog.Fields.Column.TargetField", (String[])new String[0]), 1, false, false)};
        this.wFields = new TableView(this.variables, (Composite)this.shell, 0, fieldsColumns, this.input.getSourceFields().size(), false, null, this.props);
        this.props.setLook((Control)this.wFields);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        this.wOutputField.setText(Const.NVL((String)this.input.getOutputFieldName(), (String)""));
        this.wSchemaName.setText(Const.NVL((String)this.input.getSchemaName(), (String)""));
        this.wNamespace.setText(Const.NVL((String)this.input.getNamespace(), (String)""));
        this.wDocumentation.setText(Const.NVL((String)this.input.getDocumentation(), (String)""));
        int rowNr = 0;
        for (SourceField sourceField : this.input.getSourceFields()) {
            TableItem item = this.wFields.table.getItem(rowNr++);
            int col = 1;
            item.setText(col++, Const.NVL((String)sourceField.getSourceFieldName(), (String)""));
            item.setText(col++, Const.NVL((String)sourceField.getTargetFieldName(), (String)""));
        }
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.input.setOutputFieldName(this.wOutputField.getText());
        this.input.setSchemaName(this.wSchemaName.getText());
        this.input.setNamespace(this.wNamespace.getText());
        this.input.setDocumentation(this.wDocumentation.getText());
        this.input.getSourceFields().clear();
        for (TableItem item : this.wFields.getNonEmptyItems()) {
            int col = 1;
            String sourceField = item.getText(col++);
            String targetField = item.getText(col++);
            this.input.getSourceFields().add(new SourceField(sourceField, targetField));
        }
        this.transformName = this.wTransformName.getText();
        this.transformMeta.setChanged();
        this.dispose();
    }

    private void getFields() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wFields, (int)1, (int[])new int[]{1}, (int[])new int[0], (int)-1, (int)-1, null);
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error", "Error getting fields", e);
        }
    }
}

