/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.scanner;

import com.google.api.core.InternalApi;
import com.google.cloud.bigtable.data.v2.models.RowAdapter;
import com.google.cloud.bigtable.grpc.scanner.FlatRow;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

@InternalApi(value="For internal usage only")
public class FlatRowAdapter
implements RowAdapter<FlatRow> {
    public RowAdapter.RowBuilder<FlatRow> createRowBuilder() {
        return new FlatRowBuilder();
    }

    public boolean isScanMarkerRow(FlatRow row) {
        return row.getCells().isEmpty();
    }

    public ByteString getKey(FlatRow row) {
        return row.getRowKey();
    }

    public class FlatRowBuilder
    implements RowAdapter.RowBuilder<FlatRow> {
        private ByteString currentKey;
        private String family;
        private ByteString qualifier;
        private List<String> labels;
        private long timestamp;
        private ByteString value;
        private Map<String, List<FlatRow.Cell>> cells = new TreeMap<String, List<FlatRow.Cell>>();
        private List<FlatRow.Cell> currentFamilyCells = null;
        private String previousFamily;
        private int totalCellCount = 0;

        public void startRow(ByteString rowKey) {
            this.currentKey = rowKey;
        }

        public void startCell(String family, ByteString qualifier, long timestamp, List<String> labels, long size) {
            this.family = family;
            this.qualifier = qualifier;
            this.timestamp = timestamp;
            this.labels = labels;
            this.value = ByteString.EMPTY;
        }

        public void cellValue(ByteString value) {
            this.value = this.value.concat(value);
        }

        public void finishCell() {
            if (!Objects.equals(this.family, this.previousFamily)) {
                this.previousFamily = this.family;
                this.currentFamilyCells = new ArrayList<FlatRow.Cell>();
                this.cells.put(this.family, this.currentFamilyCells);
            }
            FlatRow.Cell cell = new FlatRow.Cell(this.family, this.qualifier, this.timestamp, this.value, this.labels);
            this.currentFamilyCells.add(cell);
            ++this.totalCellCount;
        }

        public FlatRow finishRow() {
            ImmutableList.Builder combined = ImmutableList.builderWithExpectedSize((int)this.totalCellCount);
            for (List<FlatRow.Cell> familyCellList : this.cells.values()) {
                FlatRow.Cell previous = null;
                for (FlatRow.Cell c : familyCellList) {
                    if (previous == null || !c.getLabels().isEmpty() || !this.keysMatch(c, previous)) {
                        combined.add((Object)c);
                    }
                    previous = c;
                }
            }
            return new FlatRow(this.currentKey, (ImmutableList<FlatRow.Cell>)combined.build());
        }

        private boolean keysMatch(FlatRow.Cell current, FlatRow.Cell previous) {
            return current.getTimestamp() == previous.getTimestamp() && Objects.equals(current.getQualifier(), previous.getQualifier()) && Objects.equals(current.getLabels(), previous.getLabels());
        }

        public void reset() {
            this.currentKey = null;
            this.family = null;
            this.qualifier = null;
            this.labels = null;
            this.timestamp = 0L;
            this.value = null;
            this.cells = new TreeMap<String, List<FlatRow.Cell>>();
            this.currentFamilyCells = null;
            this.previousFamily = null;
            this.totalCellCount = 0;
        }

        public FlatRow createScanMarkerRow(ByteString rowKey) {
            return new FlatRow(rowKey, (ImmutableList<FlatRow.Cell>)ImmutableList.of());
        }
    }
}

