/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.metrics;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.AutoValue_DistributionData;
import org.apache.beam.sdk.metrics.DistributionResult;

@AutoValue
public abstract class DistributionData
implements Serializable {
    public static final DistributionData EMPTY = DistributionData.create(0L, 0L, Long.MAX_VALUE, Long.MIN_VALUE);

    public abstract long sum();

    public abstract long count();

    public abstract long min();

    public abstract long max();

    public static DistributionData create(long sum, long count, long min, long max) {
        return new AutoValue_DistributionData(sum, count, min, max);
    }

    public static DistributionData singleton(long value) {
        return DistributionData.create(value, 1L, value, value);
    }

    public DistributionData combine(long value) {
        return DistributionData.create(this.sum() + value, this.count() + 1L, Math.min(value, this.min()), Math.max(value, this.max()));
    }

    public DistributionData combine(long sum, long count, long min, long max) {
        return DistributionData.create(this.sum() + sum, this.count() + count, Math.min(min, this.min()), Math.max(max, this.max()));
    }

    public DistributionData combine(DistributionData value) {
        return DistributionData.create(this.sum() + value.sum(), this.count() + value.count(), Math.min(value.min(), this.min()), Math.max(value.max(), this.max()));
    }

    public DistributionResult extractResult() {
        return DistributionResult.create(this.sum(), this.count(), this.min(), this.max());
    }
}

