/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.history;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.history.ApplicationHistoryProvider;
import org.apache.spark.deploy.history.FsHistoryProvider;
import org.apache.spark.deploy.history.HistoryServer;
import org.apache.spark.deploy.history.HistoryServerArguments;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.History$;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class HistoryServer$
implements Logging {
    public static HistoryServer$ MODULE$;
    private final SparkConf conf;
    private final String UI_PATH_PREFIX;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new HistoryServer$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkConf conf() {
        return this.conf;
    }

    public String UI_PATH_PREFIX() {
        return this.UI_PATH_PREFIX;
    }

    public void main(String[] argStrings) {
        Utils$.MODULE$.initDaemon(this.log());
        new HistoryServerArguments(this.conf(), argStrings);
        this.initSecurity();
        SecurityManager securityManager = this.createSecurityManager(this.conf());
        String providerName = (String)((Option)this.conf().get(History$.MODULE$.PROVIDER())).getOrElse((Function0 & Serializable & scala.Serializable)() -> FsHistoryProvider.class.getName());
        ApplicationHistoryProvider provider = (ApplicationHistoryProvider)Utils$.MODULE$.classForName(providerName, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()).getConstructor(SparkConf.class).newInstance(this.conf());
        int port = BoxesRunTime.unboxToInt((Object)this.conf().get(History$.MODULE$.HISTORY_SERVER_UI_PORT()));
        HistoryServer server = new HistoryServer(this.conf(), provider, securityManager, port);
        server.bind();
        provider.start();
        ShutdownHookManager$.MODULE$.addShutdownHook((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> server.stop());
        while (true) {
            Thread.sleep(Integer.MAX_VALUE);
        }
    }

    public SecurityManager createSecurityManager(SparkConf config) {
        Object object;
        Object object2;
        if (config.getBoolean(SecurityManager$.MODULE$.SPARK_AUTH_CONF(), false)) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append("Clearing ").append(SecurityManager$.MODULE$.SPARK_AUTH_CONF()).toString());
            object2 = config.set(SecurityManager$.MODULE$.SPARK_AUTH_CONF(), "false");
        } else {
            object2 = BoxedUnit.UNIT;
        }
        if (BoxesRunTime.unboxToBoolean((Object)config.get(UI$.MODULE$.ACLS_ENABLE()))) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append(UI$.MODULE$.ACLS_ENABLE().key()).append(" is configured, ").append("clearing it and only using ").append(History$.MODULE$.HISTORY_SERVER_UI_ACLS_ENABLE().key()).toString());
            object = config.set(UI$.MODULE$.ACLS_ENABLE(), BoxesRunTime.boxToBoolean((boolean)false));
        } else {
            object = BoxedUnit.UNIT;
        }
        return new SecurityManager(config, SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3());
    }

    public void initSecurity() {
        block0: {
            if (!BoxesRunTime.unboxToBoolean((Object)this.conf().get(History$.MODULE$.KERBEROS_ENABLED()))) break block0;
            String principalName = (String)((Option)this.conf().get(History$.MODULE$.KERBEROS_PRINCIPAL())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NoSuchElementException(History$.MODULE$.KERBEROS_PRINCIPAL().key());
            });
            String keytabFilename = (String)((Option)this.conf().get(History$.MODULE$.KERBEROS_KEYTAB())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NoSuchElementException(History$.MODULE$.KERBEROS_KEYTAB().key());
            });
            SparkHadoopUtil$.MODULE$.get().loginUserFromKeytab(principalName, keytabFilename);
        }
    }

    public String getAttemptURI(String appId, Option<String> attemptId) {
        String attemptSuffix = (String)attemptId.map((Function1 & Serializable & scala.Serializable)id -> new StringBuilder(1).append("/").append((String)id).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        return new StringBuilder(1).append(this.UI_PATH_PREFIX()).append("/").append(appId).append(attemptSuffix).toString();
    }

    private HistoryServer$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.conf = new SparkConf();
        this.UI_PATH_PREFIX = "/history";
    }
}

