/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.dbproc;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.dbproc.DBProc;
import org.apache.hop.pipeline.transforms.dbproc.DBProcData;
import org.w3c.dom.Node;

@Transform(id="DBProc", image="dbproc.svg", name="i18n::CallDBProcedure.Name", description="i18n::CallDBProcedure.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Lookup", keywords={"i18n::DBProcMeta.keyword"}, documentationUrl="/pipeline/transforms/calldbproc.html")
public class DBProcMeta
extends BaseTransformMeta<DBProc, DBProcData> {
    private static final Class<?> PKG = DBProcMeta.class;
    private DatabaseMeta database;
    private String procedure;
    private String[] argument;
    private String[] argumentDirection;
    private int[] argumentType;
    private String resultName;
    private int resultType;
    private boolean autoCommit;

    public String[] getArgument() {
        return this.argument;
    }

    public void setArgument(String[] argument) {
        this.argument = argument;
    }

    public String[] getArgumentDirection() {
        return this.argumentDirection;
    }

    public void setArgumentDirection(String[] argumentDirection) {
        this.argumentDirection = argumentDirection;
    }

    public int[] getArgumentType() {
        return this.argumentType;
    }

    public void setArgumentType(int[] argumentType) {
        this.argumentType = argumentType;
    }

    public DatabaseMeta getDatabase() {
        return this.database;
    }

    public void setDatabase(DatabaseMeta database) {
        this.database = database;
    }

    public String getProcedure() {
        return this.procedure;
    }

    public void setProcedure(String procedure) {
        this.procedure = procedure;
    }

    public String getResultName() {
        return this.resultName;
    }

    public void setResultName(String resultName) {
        this.resultName = resultName;
    }

    public int getResultType() {
        return this.resultType;
    }

    public void setResultType(int resultType) {
        this.resultType = resultType;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode, metadataProvider);
    }

    public void allocate(int nrargs) {
        this.argument = new String[nrargs];
        this.argumentDirection = new String[nrargs];
        this.argumentType = new int[nrargs];
    }

    public Object clone() {
        DBProcMeta retval = (DBProcMeta)((Object)super.clone());
        int nrargs = this.argument.length;
        retval.allocate(nrargs);
        System.arraycopy(this.argument, 0, retval.argument, 0, nrargs);
        System.arraycopy(this.argumentDirection, 0, retval.argumentDirection, 0, nrargs);
        System.arraycopy(this.argumentType, 0, retval.argumentType, 0, nrargs);
        return retval;
    }

    public void setDefault() {
        this.database = null;
        int nrargs = 0;
        this.allocate(nrargs);
        for (int i = 0; i < nrargs; ++i) {
            this.argument[i] = "arg" + i;
            this.argumentDirection[i] = "IN";
            this.argumentType[i] = 1;
        }
        this.resultName = "result";
        this.resultType = 1;
        this.autoCommit = true;
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (!Utils.isEmpty((CharSequence)this.resultName)) {
            try {
                IValueMeta v = ValueMetaFactory.createValueMeta((String)this.resultName, (int)this.resultType);
                v.setOrigin(name);
                r.addValueMeta(v);
            }
            catch (HopPluginException e) {
                throw new HopTransformException((Throwable)e);
            }
        }
        for (int i = 0; i < this.argument.length; ++i) {
            if (!this.argumentDirection[i].equalsIgnoreCase("OUT")) continue;
            try {
                IValueMeta v = ValueMetaFactory.createValueMeta((String)this.argument[i], (int)this.argumentType[i]);
                v.setOrigin(name);
                r.addValueMeta(v);
                continue;
            }
            catch (HopPluginException e) {
                throw new HopTransformException((Throwable)e);
            }
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(500);
        retval.append("    ").append(XmlHandler.addTagValue((String)"connection", (String)(this.database == null ? "" : this.database.getName())));
        retval.append("    ").append(XmlHandler.addTagValue((String)"procedure", (String)this.procedure));
        retval.append("    <lookup>").append(Const.CR);
        for (int i = 0; i < this.argument.length; ++i) {
            retval.append("      <arg>").append(Const.CR);
            retval.append("        ").append(XmlHandler.addTagValue((String)"name", (String)this.argument[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"direction", (String)this.argumentDirection[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"type", (String)ValueMetaFactory.getValueMetaName((int)this.argumentType[i])));
            retval.append("      </arg>").append(Const.CR);
        }
        retval.append("    </lookup>").append(Const.CR);
        retval.append("    <result>").append(Const.CR);
        retval.append("      ").append(XmlHandler.addTagValue((String)"name", (String)this.resultName));
        retval.append("      ").append(XmlHandler.addTagValue((String)"type", (String)ValueMetaFactory.getValueMetaName((int)this.resultType)));
        retval.append("    </result>").append(Const.CR);
        retval.append("    ").append(XmlHandler.addTagValue((String)"auto_commit", (boolean)this.autoCommit));
        return retval.toString();
    }

    private void readData(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            String con = XmlHandler.getTagValue((Node)transformNode, (String)"connection");
            this.database = DatabaseMeta.loadDatabase((IHopMetadataProvider)metadataProvider, (String)con);
            this.procedure = XmlHandler.getTagValue((Node)transformNode, (String)"procedure");
            Node lookup = XmlHandler.getSubNode((Node)transformNode, (String)"lookup");
            int nrargs = XmlHandler.countNodes((Node)lookup, (String)"arg");
            this.allocate(nrargs);
            for (int i = 0; i < nrargs; ++i) {
                Node anode = XmlHandler.getSubNodeByNr((Node)lookup, (String)"arg", (int)i);
                this.argument[i] = XmlHandler.getTagValue((Node)anode, (String)"name");
                this.argumentDirection[i] = XmlHandler.getTagValue((Node)anode, (String)"direction");
                this.argumentType[i] = ValueMetaFactory.getIdForValueMeta((String)XmlHandler.getTagValue((Node)anode, (String)"type"));
            }
            this.resultName = XmlHandler.getTagValue((Node)transformNode, (String)"result", (String)"name");
            this.resultType = ValueMetaFactory.getIdForValueMeta((String)XmlHandler.getTagValue((Node)transformNode, (String)"result", (String)"type"));
            this.autoCommit = !"N".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"auto_commit"));
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"DBProcMeta.Exception.UnableToReadTransformMeta", (String[])new String[0]), (Throwable)e);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        block10: {
            Object errorMessage = "";
            if (this.database != null) {
                Database db = new Database((ILoggingObject)new LoggingObject((Object)pipelineMeta), variables, this.database);
                try {
                    db.connect();
                    if (prev != null && prev.size() > 0) {
                        boolean first = true;
                        errorMessage = "";
                        boolean errorFound = false;
                        for (int i = 0; i < this.argument.length; ++i) {
                            IValueMeta v = prev.searchValueMeta(this.argument[i]);
                            if (v == null) {
                                if (first) {
                                    first = false;
                                    errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"DBProcMeta.CheckResult.MissingArguments", (String[])new String[0]) + Const.CR;
                                }
                                errorFound = true;
                                errorMessage = (String)errorMessage + "\t\t" + this.argument[i] + Const.CR;
                                continue;
                            }
                            if (v.getType() == this.argumentType[i] || v.isNumeric() && ValueMetaBase.isNumeric((int)this.argumentType[i])) continue;
                            errorFound = true;
                            errorMessage = (String)errorMessage + "\t\t" + this.argument[i] + BaseMessages.getString(PKG, (String)"DBProcMeta.CheckResult.WrongTypeArguments", (String[])new String[]{v.getTypeDesc(), ValueMetaFactory.getValueMetaName((int)this.argumentType[i])}) + Const.CR;
                        }
                        cr = errorFound ? new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"DBProcMeta.CheckResult.AllArgumentsOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                        break block10;
                    }
                    errorMessage = BaseMessages.getString(PKG, (String)"DBProcMeta.CheckResult.CouldNotReadFields", (String[])new String[0]) + Const.CR;
                    cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
                catch (HopException e) {
                    errorMessage = BaseMessages.getString(PKG, (String)"DBProcMeta.CheckResult.ErrorOccurred", (String[])new String[0]) + e.getMessage();
                    cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
            } else {
                errorMessage = BaseMessages.getString(PKG, (String)"DBProcMeta.CheckResult.InvalidConnection", (String[])new String[0]);
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"DBProcMeta.CheckResult.ReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"DBProcMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

