/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.Props;
import org.apache.hop.core.gui.IGuiPosition;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.history.AuditManager;
import org.apache.hop.history.AuditState;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.OsHelper;
import org.apache.hop.ui.hopgui.TextSizeUtilFacade;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class PropsUi
extends Props {
    private static final String OS = System.getProperty("os.name").toLowerCase();
    private static double nativeZoomFactor;
    private static double globalZoomFactor;
    private static final String STRING_SHOW_COPY_OR_DISTRIBUTE_WARNING = "ShowCopyOrDistributeWarning";
    private static final String SHOW_TOOL_TIPS = "ShowToolTips";
    private static final String SHOW_HELP_TOOL_TIPS = "ShowHelpToolTips";
    private static final String CANVAS_GRID_SIZE = "CanvasGridSize";
    private static final String LEGACY_PERSPECTIVE_MODE = "LegacyPerspectiveMode";
    private static final String DISABLE_BROWSER_ENVIRONMENT_CHECK = "DisableBrowserEnvironmentCheck";
    private static final String USE_DOUBLE_CLICK_ON_CANVAS = "UseDoubleClickOnCanvas";
    private static final String USE_GLOBAL_FILE_BOOKMARKS = "UseGlobalFileBookmarks";
    private static final String DARK_MODE = "DarkMode";
    private static final String GLOBAL_ZOOMFACTOR = "GlobalZoomFactor";
    private Map<RGB, RGB> contrastingColors;
    private static PropsUi instance;
    public static final String[] globalZoomFactorLevels;

    public static PropsUi getInstance() {
        if (instance == null) {
            instance = new PropsUi();
        }
        return instance;
    }

    private PropsUi() {
        globalZoomFactor = Const.toDouble((String)this.getProperty(GLOBAL_ZOOMFACTOR, "1"), (double)1.0);
        if (EnvironmentUtils.getInstance().isWeb()) {
            nativeZoomFactor = 1.0;
        } else {
            org.eclipse.swt.graphics.Point extent = TextSizeUtilFacade.textExtent("The quick brown fox jumped over the lazy dog!");
            nativeZoomFactor = (double)extent.y / 16.0 * PropsUi.getGlobalZoomFactor();
        }
        this.setDefault();
    }

    public void setDefault() {
        super.setDefault();
        Display display = Display.getCurrent();
        this.populateContrastingColors();
        if (OsHelper.isWindows()) {
            if (this.isDarkMode()) {
                display.setData("org.eclipse.swt.internal.win32.useDarkModeExplorerTheme", (Object)Boolean.TRUE);
                display.setData("org.eclipse.swt.internal.win32.menuBarForegroundColor", (Object)new Color((Device)display, 208, 208, 208));
                display.setData("org.eclipse.swt.internal.win32.menuBarBackgroundColor", (Object)new Color((Device)display, 48, 48, 48));
                display.setData("org.eclipse.swt.internal.win32.menuBarBorderColor", (Object)new Color((Device)display, 80, 80, 80));
                display.setData("org.eclipse.swt.internal.win32.Canvas.use_WS_BORDER", (Object)Boolean.TRUE);
                display.setData("org.eclipse.swt.internal.win32.List.use_WS_BORDER", (Object)Boolean.TRUE);
                display.setData("org.eclipse.swt.internal.win32.Table.use_WS_BORDER", (Object)Boolean.TRUE);
                display.setData("org.eclipse.swt.internal.win32.Combo.use_WS_BORDER", (Object)Boolean.TRUE);
                display.setData("org.eclipse.swt.internal.win32.Text.use_WS_BORDER", (Object)Boolean.TRUE);
                display.setData("org.eclipse.swt.internal.win32.Tree.use_WS_BORDER", (Object)Boolean.TRUE);
                display.setData("org.eclipse.swt.internal.win32.Table.headerLineColor", (Object)new Color((Device)display, 80, 80, 80));
                display.setData("org.eclipse.swt.internal.win32.Label.disabledForegroundColor", (Object)new Color((Device)display, 128, 128, 128));
                display.setData("org.eclipse.swt.internal.win32.Combo.useDarkTheme", (Object)Boolean.TRUE);
                display.setData("org.eclipse.swt.internal.win32.ToolBar.backgroundColor", (Object)new Color((Device)display, 208, 208, 208));
                display.setData("org.eclipse.swt.internal.win32.Combo.backgroundColor", (Object)new Color((Device)display, 208, 208, 208));
                display.setData("org.eclipse.swt.internal.win32.ProgressBar.useColors", (Object)Boolean.TRUE);
            }
        } else if (!EnvironmentUtils.getInstance().isWeb()) {
            if (Display.isSystemDarkTheme()) {
                if (!this.isDarkMode()) {
                    this.setDarkMode(true);
                }
            } else if (this.isDarkMode()) {
                this.setDarkMode(false);
            }
        }
        if (display != null) {
            FontData fontData = this.getFixedFont();
            this.setProperty("FontFixedName", fontData.getName());
            this.setProperty("FontFixedSize", "" + fontData.getHeight());
            this.setProperty("FontFixedStyle", "" + fontData.getStyle());
            fontData = this.getGraphFont();
            int graphFontSize = (int)Math.round((double)fontData.getHeight() * PropsUi.getNativeZoomFactor());
            this.setProperty("FontGraphName", fontData.getName());
            this.setProperty("FontGraphSize", "" + graphFontSize);
            this.setProperty("FontGraphStyle", "" + fontData.getStyle());
            fontData = this.getNoteFont();
            this.setProperty("FontNoteName", fontData.getName());
            this.setProperty("FontNoteSize", "" + fontData.getHeight());
            this.setProperty("FontNoteStyle", "" + fontData.getStyle());
            this.setProperty("IconSize", "" + this.getIconSize());
            this.setProperty("LineWidth", "" + this.getLineWidth());
            this.setProperty("MaxUndo", "" + this.getMaxUndo());
        }
        this.setUseGlobalFileBookmarks(true);
    }

    public void setFixedFont(FontData fd) {
        this.setProperty("FontFixedName", fd.getName());
        this.setProperty("FontFixedSize", "" + fd.getHeight());
        this.setProperty("FontFixedStyle", "" + fd.getStyle());
    }

    public FontData getFixedFont() {
        FontData def = this.getDefaultFontData();
        String name = this.getProperty("FontFixedName");
        if (StringUtils.isEmpty((String)name)) {
            name = Const.isWindows() ? "Consolas" : (Const.isLinux() ? "Monospace" : (Const.isOSX() ? "Monaco" : (EnvironmentUtils.getInstance().isWeb() ? "monospace" : "Monospaced")));
        }
        int size = Const.toInt((String)this.getProperty("FontFixedSize"), (int)def.getHeight());
        int style = Const.toInt((String)this.getProperty("FontFixedStyle"), (int)def.getStyle());
        return new FontData(name, size, style);
    }

    public FontData getDefaultFont() {
        FontData def = this.getDefaultFontData();
        return def;
    }

    public void setGraphFont(FontData fd) {
        this.setProperty("FontGraphName", fd.getName());
        this.setProperty("FontGraphSize", "" + fd.getHeight());
        this.setProperty("FontGraphStyle", "" + fd.getStyle());
    }

    public FontData getGraphFont() {
        FontData def = this.getDefaultFontData();
        String name = this.getProperty("FontGraphName", def.getName());
        int size = Const.toInt((String)this.getProperty("FontGraphSize"), (int)def.getHeight());
        int correctedSize = (int)Math.round((double)size / PropsUi.getNativeZoomFactor());
        int style = Const.toInt((String)this.getProperty("FontGraphStyle"), (int)def.getStyle());
        return new FontData(name, correctedSize, style);
    }

    public void setNoteFont(FontData fd) {
        this.setProperty("FontNoteName", fd.getName());
        this.setProperty("FontNoteSize", "" + fd.getHeight());
        this.setProperty("FontNoteStyle", "" + fd.getStyle());
    }

    public FontData getNoteFont() {
        FontData def = this.getDefaultFontData();
        String name = this.getProperty("FontNoteName", def.getName());
        String ssize = this.getProperty("FontNoteSize");
        String sstyle = this.getProperty("FontNoteStyle");
        int size = Const.toInt((String)ssize, (int)def.getHeight());
        int style = Const.toInt((String)sstyle, (int)def.getStyle());
        return new FontData(name, size, style);
    }

    public void setIconSize(int size) {
        this.setProperty("IconSize", "" + size);
    }

    public int getIconSize() {
        return Const.toInt((String)this.getProperty("IconSize"), (int)32);
    }

    public void setZoomFactor(double factor) {
        this.setProperty("ZoomFactor", Double.toString(factor));
    }

    public double getZoomFactor() {
        String zoomFactorString = this.getProperty("ZoomFactor");
        if (StringUtils.isNotEmpty((String)zoomFactorString)) {
            return Const.toDouble((String)zoomFactorString, (double)nativeZoomFactor);
        }
        return nativeZoomFactor;
    }

    public int getMargin() {
        return (int)Math.round(this.getZoomFactor() * 4.0);
    }

    public void setLineWidth(int width) {
        this.setProperty("LineWidth", "" + width);
    }

    public int getLineWidth() {
        return Const.toInt((String)this.getProperty("LineWidth"), (int)1);
    }

    public void setLastPipeline(String pipeline) {
        this.setProperty("LastPreviewPipeline", pipeline);
    }

    public String getLastPipeline() {
        return this.getProperty("LastPreviewPipeline", "");
    }

    public void setLastPreview(String[] lastpreview, int[] transformsize) {
        this.setProperty("LastPreviewTransform", "" + lastpreview.length);
        for (int i = 0; i < lastpreview.length; ++i) {
            this.setProperty("LastPreviewTransform" + (i + 1), lastpreview[i]);
            this.setProperty("LastPreviewSize" + (i + 1), "" + transformsize[i]);
        }
    }

    public String[] getLastPreview() {
        String snr = this.getProperty("LastPreviewTransform");
        int nr = Const.toInt((String)snr, (int)0);
        String[] lp = new String[nr];
        for (int i = 0; i < nr; ++i) {
            lp[i] = this.getProperty("LastPreviewTransform" + (i + 1), "");
        }
        return lp;
    }

    public int[] getLastPreviewSize() {
        String snr = this.getProperty("LastPreviewTransform");
        int nr = Const.toInt((String)snr, (int)0);
        int[] si = new int[nr];
        for (int i = 0; i < nr; ++i) {
            si[i] = Const.toInt((String)this.getProperty("LastPreviewSize" + (i + 1), ""), (int)0);
        }
        return si;
    }

    public FontData getDefaultFontData() {
        return Display.getCurrent().getSystemFont().getFontData()[0];
    }

    public void setMaxUndo(int max) {
        this.setProperty("MaxUndo", "" + max);
    }

    public int getMaxUndo() {
        return Const.toInt((String)this.getProperty("MaxUndo"), (int)100);
    }

    public void setMiddlePct(int pct) {
        this.setProperty("MiddlePct", "" + pct);
    }

    public int getMiddlePct() {
        return Const.toInt((String)this.getProperty("MiddlePct"), (int)35);
    }

    public void setScreen(WindowProperty windowProperty) {
        AuditManager.storeState((ILogChannel)LogChannel.UI, (String)"hop-gui", (String)"shells", (String)windowProperty.getName(), windowProperty.getStateProperties());
    }

    public WindowProperty getScreen(String windowName) {
        if (windowName == null) {
            return null;
        }
        AuditState auditState = AuditManager.retrieveState((ILogChannel)LogChannel.UI, (String)"hop-gui", (String)"shells", (String)windowName);
        if (auditState == null) {
            return null;
        }
        return new WindowProperty(windowName, auditState.getStateMap());
    }

    public void setOpenLastFile(boolean open) {
        this.setProperty("OpenLastFile", open ? "Y" : "N");
    }

    public boolean openLastFile() {
        String open = this.getProperty("OpenLastFile");
        return !"N".equalsIgnoreCase(open);
    }

    public void setAutoSave(boolean autosave) {
        this.setProperty("AutoSave", autosave ? "Y" : "N");
    }

    public boolean getAutoSave() {
        String autosave = this.getProperty("AutoSave");
        return "Y".equalsIgnoreCase(autosave);
    }

    public void setSaveConfirmation(boolean saveconf) {
        this.setProperty("SaveConfirmation", saveconf ? "Y" : "N");
    }

    public boolean getSaveConfirmation() {
        String saveconf = this.getProperty("SaveConfirmation");
        return "Y".equalsIgnoreCase(saveconf);
    }

    public void setAutoSplit(boolean autosplit) {
        this.setProperty("AutoSplit", autosplit ? "Y" : "N");
    }

    public boolean getAutoSplit() {
        String autosplit = this.getProperty("AutoSplit");
        return "Y".equalsIgnoreCase(autosplit);
    }

    public void setAutoCollapseCoreObjectsTree(boolean autoCollapse) {
        this.setProperty("AutoCollapseCoreObjectsTree", autoCollapse ? "Y" : "N");
    }

    public boolean getAutoCollapseCoreObjectsTree() {
        String autoCollapse = this.getProperty("AutoCollapseCoreObjectsTree");
        return "Y".equalsIgnoreCase(autoCollapse);
    }

    public void setExitWarningShown(boolean show) {
        this.setProperty("ShowExitWarning", show ? "Y" : "N");
    }

    public boolean isShowCanvasGridEnabled() {
        String showCanvas = this.getProperty("ShowCanvasGrid", "N");
        return "Y".equalsIgnoreCase(showCanvas);
    }

    public void setShowCanvasGridEnabled(boolean anti) {
        this.setProperty("ShowCanvasGrid", anti ? "Y" : "N");
    }

    public boolean showExitWarning() {
        String show = this.getProperty("ShowExitWarning", "Y");
        return "Y".equalsIgnoreCase(show);
    }

    public static void setGCFont(GC gc, Device device, FontData fontData) {
        if (Const.getSystemOs().startsWith("Windows")) {
            Font font = new Font(device, fontData);
            gc.setFont(font);
            font.dispose();
        } else {
            gc.setFont(device.getSystemFont());
        }
    }

    public void setLook(Control widget) {
        this.setLook(widget, 0);
        if (widget instanceof Composite) {
            for (Control child : ((Composite)widget).getChildren()) {
                this.setLook(child);
            }
        }
    }

    public void setLook(Control control, int style) {
        Button b;
        GuiResource gui = GuiResource.getInstance();
        Font font = null;
        Color background = null;
        Color foreground = null;
        switch (style) {
            case 0: {
                background = gui.getColorWhite();
                foreground = gui.getColorBlack();
                font = null;
                if (control instanceof Group && OS.contains("mac")) {
                    control.addPaintListener(paintEvent -> {
                        paintEvent.gc.setForeground(gui.getColorBlack());
                        paintEvent.gc.setBackground(gui.getColorWhite());
                        paintEvent.gc.fillRectangle(2, 0, control.getBounds().width - 8, control.getBounds().height - 20);
                    });
                    break;
                }
                if (!(control instanceof Combo)) break;
                if (Const.isWindows() && this.isDarkMode()) {
                    background = gui.getColorBackground();
                    break;
                }
                return;
            }
            case 1: {
                foreground = gui.getColorBlack();
                background = gui.getColorWhite();
                font = gui.getFontFixed();
                break;
            }
            case 2: {
                background = gui.getColorLightGray();
                foreground = gui.getColorDarkGray();
                if (!(control instanceof Table)) break;
                Table table = (Table)control;
                table.setHeaderBackground(gui.getColorLightGray());
                table.setHeaderForeground(gui.getColorDarkGray());
                break;
            }
            case 3: {
                foreground = gui.getColorBlack();
                background = gui.getColorWhite();
                font = gui.getFontNote();
                break;
            }
            case 4: {
                foreground = gui.getColorBlack();
                background = gui.getColorWhite();
                font = gui.getFontGraph();
                break;
            }
            case 6: {
                foreground = gui.getColorBlack();
                if (this.isDarkMode()) {
                    background = gui.getColorLightGray();
                    break;
                }
                background = gui.getColorDemoGray();
                break;
            }
            case 5: {
                CTabFolder tabFolder = (CTabFolder)control;
                tabFolder.setBorderVisible(true);
                tabFolder.setBackground(gui.getColorGray());
                tabFolder.setForeground(gui.getColorBlack());
                tabFolder.setSelectionBackground(gui.getColorWhite());
                tabFolder.setSelectionForeground(gui.getColorBlack());
                break;
            }
            default: {
                background = gui.getColorBackground();
                font = null;
            }
        }
        if (font != null && !font.isDisposed()) {
            control.setFont(font);
        }
        if (background != null && !background.isDisposed()) {
            boolean setBackground = true;
            if (control instanceof Button && ((b = (Button)control).getStyle() & 8) != 0) {
                setBackground = false;
            }
            if (setBackground) {
                control.setBackground(background);
            }
        }
        if (foreground != null && !foreground.isDisposed()) {
            boolean setForeground = true;
            if (control instanceof Button && ((b = (Button)control).getStyle() & 8) != 0) {
                setForeground = false;
            }
            if (setForeground) {
                control.setForeground(foreground);
            }
        }
    }

    public static void setTableItemLook(TableItem item, Display disp) {
        if (!Const.getSystemOs().startsWith("Windows")) {
            return;
        }
        Color background = GuiResource.getInstance().getColorBackground();
        if (background != null) {
            item.setBackground(background);
        }
    }

    public static Display getDisplay() {
        return Display.getCurrent();
    }

    public void setDefaultPreviewSize(int size) {
        this.setProperty("DefaultPreviewSize", "" + size);
    }

    public int getDefaultPreviewSize() {
        return Const.toInt((String)this.getProperty("DefaultPreviewSize"), (int)1000);
    }

    public boolean showCopyOrDistributeWarning() {
        String show = this.getProperty(STRING_SHOW_COPY_OR_DISTRIBUTE_WARNING, "Y");
        return "Y".equalsIgnoreCase(show);
    }

    public void setShowCopyOrDistributeWarning(boolean show) {
        this.setProperty(STRING_SHOW_COPY_OR_DISTRIBUTE_WARNING, show ? "Y" : "N");
    }

    public void setDialogSize(Shell shell, String styleProperty) {
        String prop = this.getProperty(styleProperty);
        if (Utils.isEmpty((CharSequence)prop)) {
            return;
        }
        String[] xy = prop.split(",");
        if (xy.length != 2) {
            return;
        }
        shell.setSize(Integer.parseInt(xy[0]), Integer.parseInt(xy[1]));
    }

    public boolean useDoubleClick() {
        return "Y".equalsIgnoreCase(this.getProperty(USE_DOUBLE_CLICK_ON_CANVAS, "N"));
    }

    public void setUseDoubleClickOnCanvas(boolean use) {
        this.setProperty(USE_DOUBLE_CLICK_ON_CANVAS, use ? "Y" : "N");
    }

    public boolean useGlobalFileBookmarks() {
        return "Y".equalsIgnoreCase(this.getProperty(USE_GLOBAL_FILE_BOOKMARKS, "Y"));
    }

    public void setUseGlobalFileBookmarks(boolean use) {
        this.setProperty(USE_GLOBAL_FILE_BOOKMARKS, use ? "Y" : "N");
    }

    public boolean isDarkMode() {
        return "Y".equalsIgnoreCase(this.getProperty(DARK_MODE, "N"));
    }

    public void setDarkMode(boolean darkMode) {
        this.setProperty(DARK_MODE, darkMode ? "Y" : "N");
    }

    public boolean showToolTips() {
        return "Y".equalsIgnoreCase(this.getProperty(SHOW_TOOL_TIPS, "Y"));
    }

    public void setShowToolTips(boolean show) {
        this.setProperty(SHOW_TOOL_TIPS, show ? "Y" : "N");
    }

    public boolean isShowingHelpToolTips() {
        return "Y".equalsIgnoreCase(this.getProperty(SHOW_HELP_TOOL_TIPS, "Y"));
    }

    public void setShowingHelpToolTips(boolean show) {
        this.setProperty(SHOW_HELP_TOOL_TIPS, show ? "Y" : "N");
    }

    public int getCanvasGridSize() {
        return Const.toInt((String)this.getProperty(CANVAS_GRID_SIZE, "16"), (int)16);
    }

    public void setCanvasGridSize(int gridSize) {
        this.setProperty(CANVAS_GRID_SIZE, Integer.toString(gridSize));
    }

    public int getSupportedVersion(String property) {
        return Integer.parseInt(this.getProperty(property));
    }

    public boolean isBrowserEnvironmentCheckDisabled() {
        return "Y".equalsIgnoreCase(this.getProperty(DISABLE_BROWSER_ENVIRONMENT_CHECK, "N"));
    }

    public boolean isLegacyPerspectiveMode() {
        return "Y".equalsIgnoreCase(this.getProperty(LEGACY_PERSPECTIVE_MODE, "N"));
    }

    public static void setLocation(IGuiPosition guiElement, int x, int y) {
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        guiElement.setLocation(PropsUi.calculateGridPosition(new Point(x, y)));
    }

    public static Point calculateGridPosition(Point p) {
        int gridSize = PropsUi.getInstance().getCanvasGridSize();
        if (gridSize > 1) {
            return new Point(gridSize * Math.round(p.x / gridSize), gridSize * Math.round(p.y / gridSize));
        }
        return p;
    }

    public boolean isIndicateSlowPipelineTransformsEnabled() {
        String indicate = this.getProperty("IndicateSlowPipelineTransforms", "Y");
        return "Y".equalsIgnoreCase(indicate);
    }

    public void setIndicateSlowPipelineTransformsEnabled(boolean indicate) {
        this.setProperty("IndicateSlowPipelineTransforms", indicate ? "Y" : "N");
    }

    public static double getNativeZoomFactor() {
        return nativeZoomFactor;
    }

    public static void setNativeZoomFactor(double nativeZoomFactor) {
        PropsUi.nativeZoomFactor = nativeZoomFactor;
    }

    private void populateContrastingColors() {
        this.contrastingColors = new HashMap<RGB, RGB>();
        this.contrastingColors.put(this.toRGB("#000000"), this.toRGB("#ffffff"));
        this.contrastingColors.put(this.toRGB("#0e3a5a"), this.toRGB("#c8e7fa"));
        this.contrastingColors.put(this.toRGB("#0f3b5a"), this.toRGB("#c7e6fa"));
        this.contrastingColors.put(this.toRGB("#f0f0f0"), this.toRGB("#0f0f0f"));
        this.contrastingColors.put(this.toRGB("#e1e1e1"), this.toRGB("#303030"));
        this.contrastingColors.put(this.toRGB("#646464"), this.toRGB("#707070"));
        this.contrastingColors.put(this.toRGB("#ffd700"), this.toRGB("#0028ff"));
        this.contrastingColors.put(this.toRGB("#033d5d"), this.toRGB("#36b3f8"));
        this.contrastingColors.put(this.toRGB("#eeffaa"), this.toRGB("#556a00"));
        this.contrastingColors.put(this.toRGB("#c9e8fb"), this.toRGB("#0f88d2"));
        this.contrastingColors.put(new RGB(254, 254, 254), new RGB(35, 35, 35));
        this.contrastingColors.put(new RGB(245, 245, 245), new RGB(40, 40, 40));
        this.contrastingColors.put(new RGB(240, 240, 240), new RGB(45, 45, 45));
        this.contrastingColors.put(new RGB(235, 235, 235), new RGB(50, 50, 50));
        this.contrastingColors.put(new RGB(225, 225, 225), new RGB(70, 70, 70));
        this.contrastingColors.put(new RGB(215, 215, 215), new RGB(100, 100, 100));
        this.contrastingColors.put(new RGB(100, 100, 100), new RGB(215, 215, 215));
        this.contrastingColors.put(new RGB(50, 50, 50), new RGB(235, 235, 235));
        HashMap inverse = new HashMap();
        this.contrastingColors.keySet().stream().forEach(key -> inverse.put(this.contrastingColors.get(key), key));
        this.contrastingColors.putAll(inverse);
    }

    private RGB toRGB(String colorString) {
        int red = Integer.valueOf(colorString.substring(1, 3), 16);
        int green = Integer.valueOf(colorString.substring(3, 5), 16);
        int blue = Integer.valueOf(colorString.substring(5, 7), 16);
        return new RGB(red, green, blue);
    }

    public RGB contrastColor(RGB rgb) {
        RGB contrastingRGB;
        if (PropsUi.getInstance().isDarkMode() && (contrastingRGB = this.contrastingColors.get(rgb)) != null) {
            return contrastingRGB;
        }
        return rgb;
    }

    public RGB contrastColor(int r, int g, int b) {
        return this.contrastColor(new RGB(r, g, b));
    }

    public Map<String, String> getContrastingColorStrings() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (RGB rgb : this.contrastingColors.keySet()) {
            RGB contrastingRGB = this.contrastingColors.get(rgb);
            map.put(this.toColorString(rgb), this.toColorString(contrastingRGB));
            map.put(this.toColorString(rgb).toUpperCase(), this.toColorString(contrastingRGB));
        }
        return map;
    }

    private String toColorString(RGB rgb) {
        Object r = Integer.toString(rgb.red, 16);
        r = ((String)r).length() == 1 ? "0" + (String)r : r;
        Object g = Integer.toString(rgb.green, 16);
        g = ((String)g).length() == 1 ? "0" + (String)g : g;
        Object b = Integer.toString(rgb.blue, 16);
        b = ((String)b).length() == 1 ? "0" + (String)b : b;
        return ("#" + (String)r + (String)g + (String)b).toLowerCase();
    }

    public Map<RGB, RGB> getContrastingColors() {
        return this.contrastingColors;
    }

    public void setContrastingColors(Map<RGB, RGB> contrastingColors) {
        this.contrastingColors = contrastingColors;
    }

    public static double getGlobalZoomFactor() {
        return globalZoomFactor;
    }

    public void setGlobalZoomFactor(double globalZoomFactor) {
        this.setProperty(GLOBAL_ZOOMFACTOR, Double.toString(globalZoomFactor));
    }

    static {
        globalZoomFactorLevels = new String[]{"200%", "175%", "150%", "140%", "130%", "120%", "110%", "100%", "90%", "80%", "70%"};
    }
}

