/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.core.ApiFuture;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.ProtoRows;
import com.google.cloud.bigquery.storage.v1.WriteStream;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.RetryManager;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiDynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiFinalizeWritesDoFn;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWritePayload;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.TwoLevelMessageConverterCache;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.Cache;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheBuilder;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageApiWriteUnshardedRecords<DestinationT, ElementT>
extends PTransform<PCollection<KV<DestinationT, StorageApiWritePayload>>, PCollection<Void>> {
    private static final Logger LOG = LoggerFactory.getLogger(StorageApiWriteUnshardedRecords.class);
    private final StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations;
    private final BigQueryServices bqServices;
    private static final ExecutorService closeWriterExecutor = Executors.newCachedThreadPool();
    private static final Cache<String, BigQueryServices.StreamAppendClient> APPEND_CLIENTS = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.MINUTES).removalListener(removal -> {
        LOG.info("Expiring append client for " + (String)removal.getKey());
        @Nullable BigQueryServices.StreamAppendClient streamAppendClient = (BigQueryServices.StreamAppendClient)removal.getValue();
        StorageApiWriteUnshardedRecords.runAsyncIgnoreFailure(closeWriterExecutor, streamAppendClient::close);
    }).build();

    static void clearCache() {
        APPEND_CLIENTS.invalidateAll();
    }

    private static void runAsyncIgnoreFailure(ExecutorService executor, ThrowingRunnable task) {
        executor.submit(() -> {
            try {
                task.run();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public StorageApiWriteUnshardedRecords(StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations, BigQueryServices bqServices) {
        this.dynamicDestinations = dynamicDestinations;
        this.bqServices = bqServices;
    }

    public PCollection<Void> expand(PCollection<KV<DestinationT, StorageApiWritePayload>> input) {
        String operationName = input.getName() + "/" + this.getName();
        BigQueryOptions options = (BigQueryOptions)input.getPipeline().getOptions().as(BigQueryOptions.class);
        return (PCollection)((PCollection)((PCollection)input.apply("Write Records", (PTransform)ParDo.of(new WriteRecordsDoFn<DestinationT, ElementT>(operationName, this.dynamicDestinations, this.bqServices, false, options.getStorageApiAppendThresholdBytes(), options.getStorageApiAppendThresholdRecordCount(), options.getNumStorageWriteApiStreamAppendClients())).withSideInputs(this.dynamicDestinations.getSideInputs()))).setCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)StringUtf8Coder.of())).apply("Reshuffle", (PTransform)Reshuffle.of())).apply("Finalize writes", (PTransform)ParDo.of((DoFn)new StorageApiFinalizeWritesDoFn(this.bqServices)));
    }

    static class WriteRecordsDoFn<DestinationT, ElementT>
    extends DoFn<KV<DestinationT, StorageApiWritePayload>, KV<String, String>> {
        private final Counter forcedFlushes = Metrics.counter(WriteRecordsDoFn.class, (String)"forcedFlushes");
        private @Nullable Map<DestinationT, DestinationState> destinations = Maps.newHashMap();
        private final TwoLevelMessageConverterCache<DestinationT, ElementT> messageConverters;
        private transient @Nullable BigQueryServices.DatasetService maybeDatasetService;
        private int numPendingRecords = 0;
        private int numPendingRecordBytes = 0;
        private final int flushThresholdBytes;
        private final int flushThresholdCount;
        private final StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations;
        private final BigQueryServices bqServices;
        private final boolean useDefaultStream;
        private int streamAppendClientCount;

        WriteRecordsDoFn(String operationName, StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations, BigQueryServices bqServices, boolean useDefaultStream, int flushThresholdBytes, int flushThresholdCount, int streamAppendClientCount) {
            this.messageConverters = new TwoLevelMessageConverterCache(operationName);
            this.dynamicDestinations = dynamicDestinations;
            this.bqServices = bqServices;
            this.useDefaultStream = useDefaultStream;
            this.flushThresholdBytes = flushThresholdBytes;
            this.flushThresholdCount = flushThresholdCount;
            this.streamAppendClientCount = streamAppendClientCount;
        }

        boolean shouldFlush() {
            return this.numPendingRecords > this.flushThresholdCount || this.numPendingRecordBytes > this.flushThresholdBytes;
        }

        void flushIfNecessary() throws Exception {
            if (this.shouldFlush()) {
                this.forcedFlushes.inc();
                this.flushAll();
            }
        }

        void flushAll() throws Exception {
            RetryManager<AppendRowsResponse, RetryManager.Operation.Context<AppendRowsResponse>> retryManager = new RetryManager<AppendRowsResponse, RetryManager.Operation.Context<AppendRowsResponse>>(Duration.standardSeconds((long)1L), Duration.standardSeconds((long)10L), 1000);
            org.apache.beam.sdk.util.Preconditions.checkStateNotNull(this.destinations);
            for (DestinationState destinationState : this.destinations.values()) {
                destinationState.flush(retryManager);
            }
            retryManager.run(true);
            this.numPendingRecords = 0;
            this.numPendingRecordBytes = 0;
        }

        private BigQueryServices.DatasetService initializeDatasetService(PipelineOptions pipelineOptions) {
            if (this.maybeDatasetService == null) {
                this.maybeDatasetService = this.bqServices.getDatasetService((BigQueryOptions)pipelineOptions.as(BigQueryOptions.class));
            }
            return this.maybeDatasetService;
        }

        @DoFn.StartBundle
        public void startBundle() throws IOException {
            this.destinations = Maps.newHashMap();
            this.numPendingRecords = 0;
            this.numPendingRecordBytes = 0;
        }

        DestinationState createDestinationState(DoFn.ProcessContext c, DestinationT destination, BigQueryServices.DatasetService datasetService) {
            StorageApiDynamicDestinations.MessageConverter<ElementT> messageConverter;
            TableDestination tableDestination1 = this.dynamicDestinations.getTable(destination);
            Preconditions.checkArgument((tableDestination1 != null ? 1 : 0) != 0, (String)"DynamicDestinations.getTable() may not return null, but %s returned null for destination %s", this.dynamicDestinations, destination);
            try {
                messageConverter = this.messageConverters.get(destination, this.dynamicDestinations, datasetService);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return new DestinationState(tableDestination1.getTableUrn(), messageConverter, datasetService, this.useDefaultStream, this.streamAppendClientCount);
        }

        @DoFn.ProcessElement
        public void process(DoFn.ProcessContext c, PipelineOptions pipelineOptions, @DoFn.Element KV<DestinationT, StorageApiWritePayload> element) throws Exception {
            BigQueryServices.DatasetService initializedDatasetService = this.initializeDatasetService(pipelineOptions);
            this.dynamicDestinations.setSideInputAccessorFromProcessContext(c);
            org.apache.beam.sdk.util.Preconditions.checkStateNotNull(this.destinations);
            DestinationState state = this.destinations.computeIfAbsent(element.getKey(), k -> this.createDestinationState(c, k, initializedDatasetService));
            this.flushIfNecessary();
            state.addMessage((StorageApiWritePayload)element.getValue());
            ++this.numPendingRecords;
            this.numPendingRecordBytes += ((StorageApiWritePayload)element.getValue()).getPayload().length;
        }

        @DoFn.FinishBundle
        public void finishBundle(DoFn.FinishBundleContext context) throws Exception {
            this.flushAll();
            Map destinations = (Map)org.apache.beam.sdk.util.Preconditions.checkStateNotNull(this.destinations);
            for (DestinationState state : destinations.values()) {
                if (!this.useDefaultStream) {
                    context.output((Object)KV.of((Object)state.tableUrn, (Object)state.streamName), BoundedWindow.TIMESTAMP_MAX_VALUE.minus((ReadableDuration)Duration.millis((long)1L)), (BoundedWindow)GlobalWindow.INSTANCE);
                }
                state.teardown();
            }
            destinations.clear();
            this.destinations = null;
        }

        @DoFn.Teardown
        public void teardown() {
            this.destinations = null;
            try {
                if (this.maybeDatasetService != null) {
                    this.maybeDatasetService.close();
                    this.maybeDatasetService = null;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        class DestinationState {
            private final String tableUrn;
            private final StorageApiDynamicDestinations.MessageConverter<ElementT> messageConverter;
            private String streamName = "";
            private @Nullable BigQueryServices.StreamAppendClient streamAppendClient = null;
            private long currentOffset = 0L;
            private List<ByteString> pendingMessages;
            private transient @Nullable BigQueryServices.DatasetService maybeDatasetService;
            private final Counter recordsAppended = Metrics.counter(WriteRecordsDoFn.class, (String)"recordsAppended");
            private final Counter appendFailures = Metrics.counter(WriteRecordsDoFn.class, (String)"appendFailures");
            private final Counter schemaMismatches = Metrics.counter(WriteRecordsDoFn.class, (String)"schemaMismatches");
            private final Distribution inflightWaitSecondsDistribution = Metrics.distribution(WriteRecordsDoFn.class, (String)"streamWriterWaitSeconds");
            private final boolean useDefaultStream;
            private StorageApiDynamicDestinations.DescriptorWrapper descriptorWrapper;
            private Instant nextCacheTickle = Instant.MAX;
            private final int clientNumber;

            public DestinationState(String tableUrn, StorageApiDynamicDestinations.MessageConverter<ElementT> messageConverter, BigQueryServices.DatasetService datasetService, boolean useDefaultStream, int streamAppendClientCount) {
                this.tableUrn = tableUrn;
                this.messageConverter = messageConverter;
                this.pendingMessages = Lists.newArrayList();
                this.maybeDatasetService = datasetService;
                this.useDefaultStream = useDefaultStream;
                this.descriptorWrapper = messageConverter.getSchemaDescriptor();
                this.clientNumber = new Random().nextInt(streamAppendClientCount);
            }

            void teardown() {
                this.maybeTickleCache();
                if (this.streamAppendClient != null) {
                    StorageApiWriteUnshardedRecords.runAsyncIgnoreFailure(closeWriterExecutor, this.streamAppendClient::unpin);
                    this.streamAppendClient = null;
                }
            }

            String getDefaultStreamName() {
                return BigQueryHelpers.stripPartitionDecorator(this.tableUrn) + "/streams/_default";
            }

            String getStreamAppendClientCacheEntryKey() {
                if (this.useDefaultStream) {
                    return this.getDefaultStreamName() + "-client" + this.clientNumber;
                }
                return this.streamName;
            }

            String createStreamIfNeeded() {
                try {
                    this.streamName = !this.useDefaultStream ? ((BigQueryServices.DatasetService)org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)this.maybeDatasetService)).createWriteStream(this.tableUrn, WriteStream.Type.PENDING).getName() : this.getDefaultStreamName();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return this.streamName;
            }

            BigQueryServices.StreamAppendClient generateClient() throws Exception {
                org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)this.maybeDatasetService);
                return this.maybeDatasetService.getStreamAppendClient(this.streamName, this.descriptorWrapper.descriptor);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            BigQueryServices.StreamAppendClient getStreamAppendClient(boolean lookupCache) {
                try {
                    if (this.streamAppendClient == null) {
                        BigQueryServices.StreamAppendClient newStreamAppendClient;
                        this.createStreamIfNeeded();
                        Cache cache = APPEND_CLIENTS;
                        synchronized (cache) {
                            if (lookupCache) {
                                newStreamAppendClient = (BigQueryServices.StreamAppendClient)APPEND_CLIENTS.get((Object)this.getStreamAppendClientCacheEntryKey(), () -> this.generateClient());
                            } else {
                                newStreamAppendClient = this.generateClient();
                                APPEND_CLIENTS.put((Object)this.getStreamAppendClientCacheEntryKey(), (Object)newStreamAppendClient);
                            }
                            newStreamAppendClient.pin();
                        }
                        this.currentOffset = 0L;
                        this.nextCacheTickle = Instant.now().plus(java.time.Duration.ofMinutes(1L));
                        this.streamAppendClient = newStreamAppendClient;
                    }
                    return this.streamAppendClient;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void maybeTickleCache() {
                if (this.streamAppendClient != null && Instant.now().isAfter(this.nextCacheTickle)) {
                    Cache cache = APPEND_CLIENTS;
                    synchronized (cache) {
                        APPEND_CLIENTS.getIfPresent((Object)this.getStreamAppendClientCacheEntryKey());
                    }
                    this.nextCacheTickle = Instant.now().plus(java.time.Duration.ofMinutes(1L));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void invalidateWriteStream() {
                if (this.streamAppendClient != null) {
                    Cache cache = APPEND_CLIENTS;
                    synchronized (cache) {
                        StorageApiWriteUnshardedRecords.runAsyncIgnoreFailure(closeWriterExecutor, this.streamAppendClient::unpin);
                        String cacheEntryKey = this.getStreamAppendClientCacheEntryKey();
                        @Nullable BigQueryServices.StreamAppendClient cachedAppendClient = (BigQueryServices.StreamAppendClient)APPEND_CLIENTS.getIfPresent((Object)cacheEntryKey);
                        if (cachedAppendClient != null && System.identityHashCode(cachedAppendClient) == System.identityHashCode(this.streamAppendClient)) {
                            APPEND_CLIENTS.invalidate((Object)cacheEntryKey);
                        }
                    }
                    this.streamAppendClient = null;
                }
            }

            void addMessage(StorageApiWritePayload payload) throws Exception {
                this.maybeTickleCache();
                if (payload.getSchemaHash() != this.descriptorWrapper.hash) {
                    DynamicMessage msg;
                    this.schemaMismatches.inc();
                    this.messageConverter.refreshSchema(payload.getSchemaHash());
                    this.descriptorWrapper = this.messageConverter.getSchemaDescriptor();
                    this.invalidateWriteStream();
                    if (this.useDefaultStream) {
                        this.getStreamAppendClient(false);
                    }
                    if ((msg = DynamicMessage.parseFrom((Descriptors.Descriptor)this.descriptorWrapper.descriptor, (byte[])payload.getPayload())).getUnknownFields() != null && !msg.getUnknownFields().asMap().isEmpty()) {
                        throw new RuntimeException("Record schema does not match table. Unknown fields: " + msg.getUnknownFields());
                    }
                }
                this.pendingMessages.add(ByteString.copyFrom((byte[])payload.getPayload()));
            }

            void flush(RetryManager<AppendRowsResponse, RetryManager.Operation.Context<AppendRowsResponse>> retryManager) throws Exception {
                if (this.pendingMessages.isEmpty()) {
                    return;
                }
                ProtoRows.Builder inserts = ProtoRows.newBuilder();
                inserts.addAllSerializedRows(this.pendingMessages);
                ProtoRows protoRows = inserts.build();
                this.pendingMessages.clear();
                retryManager.addOperation(c -> {
                    try {
                        BigQueryServices.StreamAppendClient writeStream = this.getStreamAppendClient(true);
                        long offset = -1L;
                        if (!this.useDefaultStream) {
                            offset = this.currentOffset;
                            this.currentOffset += (long)inserts.getSerializedRowsCount();
                        }
                        ApiFuture<AppendRowsResponse> response = writeStream.appendRows(offset, protoRows);
                        this.inflightWaitSecondsDistribution.update(writeStream.getInflightWaitSeconds());
                        if (writeStream.getInflightWaitSeconds() > 5L) {
                            LOG.warn("Storage Api write delay more than {} seconds.", (Object)writeStream.getInflightWaitSeconds());
                        }
                        return response;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }, contexts -> {
                    LOG.warn("Append to stream {} by client #{} failed with error, operations will be retried. Details: {}", new Object[]{this.streamName, this.clientNumber, this.retrieveErrorDetails((Iterable<RetryManager.Operation.Context<AppendRowsResponse>>)contexts)});
                    this.invalidateWriteStream();
                    this.appendFailures.inc();
                    return RetryManager.RetryType.RETRY_ALL_OPERATIONS;
                }, response -> this.recordsAppended.inc((long)protoRows.getSerializedRowsCount()), new RetryManager.Operation.Context());
                this.maybeTickleCache();
            }

            String retrieveErrorDetails(Iterable<RetryManager.Operation.Context<AppendRowsResponse>> contexts) {
                return StreamSupport.stream(contexts.spliterator(), false).map(ctx -> (Throwable)org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)ctx.getError())).map(err -> String.format("message: %s, stacktrace: %s", err, Lists.newArrayList((Object[])err.getStackTrace()).stream().map(se -> se.toString()).collect(Collectors.joining("\n")))).collect(Collectors.joining(","));
            }
        }
    }

    private static interface ThrowingRunnable {
        public void run() throws Exception;
    }
}

