/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction;

import com.google.cloud.Timestamp;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionMode;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionPosition;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionRestriction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionRestrictionClaimer;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionRestrictionMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionRestrictionProgressChecker;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionRestrictionSplitter;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampUtils;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionRestrictionTracker
extends RestrictionTracker<PartitionRestriction, PartitionPosition>
implements RestrictionTracker.HasProgress {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionRestrictionTracker.class);
    private final PartitionRestrictionSplitter splitter;
    private final PartitionRestrictionClaimer claimer;
    private final PartitionRestrictionProgressChecker progressChecker;
    protected PartitionRestriction restriction;
    private @Nullable PartitionPosition lastClaimedPosition;
    protected Supplier<Timestamp> timeSupplier;

    public PartitionRestrictionTracker(PartitionRestriction restriction) {
        this(restriction, new PartitionRestrictionSplitter(), new PartitionRestrictionClaimer(), new PartitionRestrictionProgressChecker());
    }

    PartitionRestrictionTracker(PartitionRestriction restriction, PartitionRestrictionSplitter splitter, PartitionRestrictionClaimer claimer, PartitionRestrictionProgressChecker progressChecker) {
        this.splitter = splitter;
        this.claimer = claimer;
        this.restriction = restriction;
        this.progressChecker = progressChecker;
        this.timeSupplier = () -> Timestamp.now();
    }

    @VisibleForTesting
    public void setTimeSupplier(Supplier<Timestamp> timeSupplier) {
        this.timeSupplier = timeSupplier;
    }

    public @Nullable SplitResult<PartitionRestriction> trySplit(double fractionOfRemainder) {
        SplitResult<PartitionRestriction> splitResult = this.splitter.trySplit(fractionOfRemainder, this.lastClaimedPosition, this.restriction);
        if (splitResult != null) {
            PartitionRestriction restrictionFromSplit;
            this.restriction = restrictionFromSplit = Optional.ofNullable((PartitionRestriction)splitResult.getPrimary()).orElse(this.restriction);
        }
        return splitResult;
    }

    public boolean tryClaim(PartitionPosition position) {
        boolean canClaim = this.claimer.tryClaim(this.restriction, this.lastClaimedPosition, position);
        if (canClaim) {
            this.lastClaimedPosition = position;
        }
        return canClaim;
    }

    public RestrictionTracker.Progress getProgress() {
        String token = Optional.ofNullable(this.restriction.getMetadata()).map(PartitionRestrictionMetadata::getPartitionToken).orElse(null);
        RestrictionTracker.Progress progress = this.progressChecker.getProgress(this.restriction, this.lastClaimedPosition);
        LOG.debug("[" + token + "] Progress is " + progress);
        return progress;
    }

    public PartitionRestriction currentRestriction() {
        return this.restriction;
    }

    public void checkDone() throws IllegalStateException {
        if (this.restriction.getMode() == PartitionMode.STOP) {
            return;
        }
        if (this.lastClaimedPosition != null) {
            PartitionMode currentMode = this.lastClaimedPosition.getMode();
            if (currentMode == PartitionMode.QUERY_CHANGE_STREAM) {
                Timestamp nextPosition = TimestampUtils.next(this.lastClaimedPosition.getTimestamp().get());
                if (nextPosition.compareTo(this.restriction.getEndTimestamp()) < 0) {
                    throw new IllegalStateException(String.format("Last attempted key was %s in range %s, claiming work in [%s, %s) was not attempted", nextPosition, this.restriction, nextPosition, this.restriction.getEndTimestamp()));
                }
            } else {
                Preconditions.checkState((currentMode == PartitionMode.DONE ? 1 : 0) != 0, (String)"Restriction %s does not have mode DONE", (Object)this.restriction.toString());
            }
        } else {
            throw new IllegalStateException(String.format("restriction is non-empty %s and no keys have been attempted.", this.restriction));
        }
    }

    public RestrictionTracker.IsBounded isBounded() {
        return RestrictionTracker.IsBounded.UNBOUNDED;
    }

    @VisibleForTesting
    PartitionRestriction getRestriction() {
        return this.restriction;
    }

    @VisibleForTesting
    @Nullable PartitionPosition getLastClaimedPosition() {
        return this.lastClaimedPosition;
    }
}

