/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.testing.xp;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.testing.PipelineUnitTest;
import org.apache.hop.testing.gui.TestingGuiPlugin;
import org.apache.hop.testing.xp.HopGuiUnitTestChanged;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.swt.widgets.MessageBox;

@ExtensionPoint(id="HopGuiUnitTestCreated", extensionPointId="HopGuiMetadataObjectCreated", description="When HopGui create a new metadata object somewhere")
public class HopGuiUnitTestCreated
extends HopGuiUnitTestChanged
implements IExtensionPoint {
    @Override
    public void callExtensionPoint(ILogChannel log, IVariables variables, Object object) throws HopException {
        super.callExtensionPoint(log, variables, object);
        if (!(object instanceof PipelineUnitTest)) {
            return;
        }
        PipelineUnitTest test = (PipelineUnitTest)object;
        HopGui hopGui = HopGui.getInstance();
        TestingGuiPlugin testingGuiPlugin = TestingGuiPlugin.getInstance();
        PipelineMeta pipelineMeta = testingGuiPlugin.getActivePipelineMeta();
        if (pipelineMeta == null) {
            return;
        }
        MessageBox messageBox = new MessageBox(hopGui.getShell(), 196);
        messageBox.setText("Attach?");
        messageBox.setMessage("Do you want to use this unit test for the active pipeline '" + pipelineMeta.getName() + "'?");
        int answer = messageBox.open();
        if ((answer & 0x40) == 0) {
            return;
        }
        test.setRelativeFilename(variables, pipelineMeta.getFilename());
        TestingGuiPlugin.selectUnitTest(pipelineMeta, test);
        hopGui.getActiveFileTypeHandler().updateGui();
    }
}

