/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.git;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.gui.IGc;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.svg.SvgFile;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.git.HopDiff;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePainter;
import org.apache.hop.ui.core.PropsUi;

@ExtensionPoint(id="DrawDiffOnTransExtensionPoint", description="Draws a marker on top of a transform if it has some change", extensionPointId="PipelinePainterEnd")
public class DrawDiffOnTransformExtensionPoint
implements IExtensionPoint {
    public void callExtensionPoint(ILogChannel log, IVariables variables, Object object) throws HopException {
        if (!(object instanceof PipelinePainter)) {
            return;
        }
        PipelinePainter painter = (PipelinePainter)object;
        Point offset = painter.getOffset();
        IGc gc = painter.getGc();
        PipelineMeta pipelineMeta = painter.getPipelineMeta();
        try {
            pipelineMeta.getTransforms().stream().filter(transform -> transform.getAttribute(HopDiff.ATTR_GIT, HopDiff.ATTR_STATUS) != null).forEach(transform -> {
                if (pipelineMeta.getPipelineVersion() != null && pipelineMeta.getPipelineVersion().startsWith("git")) {
                    String location;
                    String status = transform.getAttribute(HopDiff.ATTR_GIT, HopDiff.ATTR_STATUS);
                    Point n = transform.getLocation();
                    if (status.equals("REMOVED")) {
                        location = "removed.svg";
                    } else if (status.equals("CHANGED")) {
                        location = "changed.svg";
                    } else if (status.equals("ADDED")) {
                        location = "added.svg";
                    } else {
                        return;
                    }
                    int iconSize = 32;
                    try {
                        iconSize = PropsUi.getInstance().getIconSize();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    int x = n.x + iconSize + offset.x - iconSize / 4;
                    int y = n.y + offset.y - iconSize / 4;
                    try {
                        gc.drawImage(new SvgFile(location, this.getClass().getClassLoader()), x, y, iconSize / 2, iconSize / 2, gc.getMagnification(), 0.0);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                transform.getAttributesMap().remove(HopDiff.ATTR_GIT);
            });
        }
        catch (Exception e) {
            throw new HopException("Error drawing status on transform", (Throwable)e);
        }
    }
}

