/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import io.netty.util.concurrent.FastThreadLocal;
import java.nio.ByteBuffer;
import java.util.EnumMap;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.util.FileUtils;

public final class ThreadLocalByteBufferHolder {
    private static final EnumMap<BufferType, FastThreadLocal<ByteBuffer>> reusableBBHolder = new EnumMap(BufferType.class);
    private final FastThreadLocal<ByteBuffer> reusableBB;
    private final BufferType bufferType;

    public ThreadLocalByteBufferHolder(BufferType bufferType) {
        this.bufferType = bufferType;
        this.reusableBB = reusableBBHolder.get((Object)bufferType);
    }

    public ByteBuffer getBuffer(int size) {
        ByteBuffer buffer = (ByteBuffer)this.reusableBB.get();
        if (buffer.capacity() < size) {
            FileUtils.clean(buffer);
            buffer = this.bufferType.allocate(size);
            this.reusableBB.set((Object)buffer);
        }
        buffer.clear().limit(size);
        return buffer;
    }

    static {
        for (BufferType bbType : BufferType.values()) {
            reusableBBHolder.put(bbType, new FastThreadLocal<ByteBuffer>(){

                protected ByteBuffer initialValue() {
                    return ByteBuffer.allocate(0);
                }
            });
        }
    }
}

