/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.datagrid;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.datagrid.DataGridData;
import org.apache.hop.pipeline.transforms.datagrid.DataGridDataMeta;
import org.apache.hop.pipeline.transforms.datagrid.DataGridMeta;

public class DataGrid
extends BaseTransform<DataGridMeta, DataGridData> {
    private static final Class<?> PKG = DataGridMeta.class;

    public DataGrid(TransformMeta transformMeta, DataGridMeta meta, DataGridData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        if (((DataGridData)this.data).linesWritten >= ((DataGridMeta)this.meta).getDataLines().size()) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((DataGridData)this.data).linesWritten = 0;
            ((DataGridData)this.data).outputRowMeta = new RowMeta();
            ((DataGridMeta)this.meta).getFields(((DataGridData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((DataGridData)this.data).convertMeta = ((DataGridData)this.data).outputRowMeta.cloneToType(2);
        }
        Object[] outputRowData = RowDataUtil.allocateRowData((int)((DataGridData)this.data).outputRowMeta.size());
        DataGridDataMeta outputLine = ((DataGridMeta)this.meta).getDataLines().get(((DataGridData)this.data).linesWritten);
        for (int i = 0; i < ((DataGridData)this.data).outputRowMeta.size(); ++i) {
            if (Boolean.TRUE.equals(((DataGridMeta)this.meta).getDataGridFields().get(i).isEmptyString())) {
                outputRowData[i] = "";
                continue;
            }
            IValueMeta valueMeta = ((DataGridData)this.data).outputRowMeta.getValueMeta(i);
            IValueMeta convertMeta = ((DataGridData)this.data).convertMeta.getValueMeta(i);
            String valueData = outputLine.getDatalines().get(i);
            if (valueData != null && valueMeta.isNull((Object)valueData)) {
                valueData = null;
            }
            outputRowData[i] = valueMeta.convertDataFromString(valueData, convertMeta, null, null, 0);
        }
        this.putRow(((DataGridData)this.data).outputRowMeta, outputRowData);
        ++((DataGridData)this.data).linesWritten;
        if (this.log.isRowLevel()) {
            this.log.logRowlevel(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"DataGrid.Log.Wrote.Row", (String[])new String[]{Long.toString(this.getLinesWritten()), ((DataGridData)this.data).outputRowMeta.getString(outputRowData)})});
        }
        if (this.checkFeedback(this.getLinesWritten()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"DataGrid.Log.LineNr", (String[])new String[]{Long.toString(this.getLinesWritten())}));
        }
        return true;
    }
}

