/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.passwords.aes;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.encryption.ITwoWayPasswordEncoder;
import org.apache.hop.core.encryption.TwoWayPasswordEncoderPlugin;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.Variables;

@TwoWayPasswordEncoderPlugin(id="AES", name="AES Password encoder", description="Allows for 128/192/256 bit password encryption of passwords in Hop")
public class AesTwoWayPasswordEncoder
implements ITwoWayPasswordEncoder {
    public static final String VARIABLE_HOP_AES_ENCODER_KEY = "HOP_AES_ENCODER_KEY";
    public static final String AES_PREFIX = "AES ";
    public static final String AES_ALGORITHM = "AES/ECB/PKCS5Padding";
    private Cipher encryptCipher;
    private Cipher decryptCipher;

    public void init() throws HopException {
        try {
            String realAesKey;
            String aesKey = System.getProperty(VARIABLE_HOP_AES_ENCODER_KEY, null);
            if (StringUtils.isEmpty((String)aesKey)) {
                this.noKeySpecified();
            }
            if (StringUtils.isEmpty((String)(realAesKey = Variables.getADefaultVariableSpace().resolve(aesKey)))) {
                this.noKeySpecified();
            }
            byte[] key = realAesKey.getBytes(StandardCharsets.UTF_8);
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] digestKey = messageDigest.digest(key);
            byte[] copiedKey = Arrays.copyOf(digestKey, 16);
            SecretKeySpec secretKeySpec = new SecretKeySpec(copiedKey, "AES");
            this.encryptCipher = Cipher.getInstance(AES_ALGORITHM);
            this.encryptCipher.init(1, secretKeySpec);
            this.decryptCipher = Cipher.getInstance(AES_ALGORITHM);
            this.decryptCipher.init(2, secretKeySpec);
        }
        catch (Exception e) {
            throw new HopException("Error initializing AES password encoder plugin", (Throwable)e);
        }
    }

    private void noKeySpecified() throws HopException {
        throw new HopException("Please specify a key to encrypt/decrypt with by setting variable HOP_AES_ENCODER_KEY in the system properties");
    }

    public String encode(String password) {
        return this.encode(password, true);
    }

    public String encode(String password, boolean includePrefix) {
        if (StringUtils.isEmpty((String)password)) {
            return password;
        }
        try {
            if (includePrefix) {
                return this.encryptPasswordIfNotUsingVariablesInternal(password);
            }
            return this.encodeInternal(password);
        }
        catch (Exception e) {
            throw new RuntimeException("Error encoding password using AES", e);
        }
    }

    private String encodeInternal(String password) {
        if (StringUtils.isEmpty((String)password)) {
            return password;
        }
        try {
            return Base64.getEncoder().encodeToString(this.encryptCipher.doFinal(password.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            throw new RuntimeException("Error encoding password using AES", e);
        }
    }

    public String decode(String encodedPassword, boolean optionallyEncrypted) {
        if (StringUtils.isEmpty((String)encodedPassword)) {
            return encodedPassword;
        }
        if (optionallyEncrypted) {
            if (encodedPassword.startsWith(AES_PREFIX)) {
                encodedPassword = encodedPassword.substring(AES_PREFIX.length());
                return this.decodeOnly(encodedPassword);
            }
            return encodedPassword;
        }
        return this.decodeOnly(encodedPassword);
    }

    public String decode(String encodedPassword) {
        if (StringUtils.isEmpty((String)encodedPassword)) {
            return encodedPassword;
        }
        if (encodedPassword.startsWith(AES_PREFIX)) {
            encodedPassword = encodedPassword.substring(AES_PREFIX.length());
        }
        return this.decodeOnly(encodedPassword);
    }

    protected final String encryptPasswordIfNotUsingVariablesInternal(String password) {
        Object encryptedPassword = "";
        ArrayList varList = new ArrayList();
        StringUtil.getUsedVariables((String)password, varList, (boolean)true);
        encryptedPassword = varList.isEmpty() ? AES_PREFIX + this.encodeInternal(password) : password;
        return encryptedPassword;
    }

    private String decodeOnly(String encodedPassword) {
        try {
            return new String(this.decryptCipher.doFinal(Base64.getDecoder().decode(encodedPassword)));
        }
        catch (Exception e) {
            throw new RuntimeException("Error decoding password using AES", e);
        }
    }

    public String[] getPrefixes() {
        return new String[]{AES_PREFIX};
    }
}

