/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.graph;

import java.util.Objects;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.neo4j.transforms.graph.RelationshipMappingType;

public class RelationshipMapping {
    @HopMetadataProperty(key="relationship_mapping_type", injectionKey="relationship_mapping_type", injectionGroupDescription="GraphOutput.Injection.RELATIONSHIP_MAPPING_TYPE", storeWithCode=true)
    private RelationshipMappingType type;
    @HopMetadataProperty(key="relationship_name", injectionKey="relationship_name", injectionGroupDescription="GraphOutput.Injection.TARGET_RELATIONSHIP_NAME")
    private String targetRelationship;
    @HopMetadataProperty(key="field_name", injectionKey="field_name", injectionGroupDescription="GraphOutput.Injection.FIELD_NAME")
    private String fieldName;
    @HopMetadataProperty(key="field_value", injectionKey="field_value", injectionGroupDescription="GraphOutput.Injection.FIELD_VALUE")
    private String fieldValue;
    @HopMetadataProperty(key="source_node", injectionKey="source_node", injectionGroupDescription="GraphOutput.Injection.RELATIONSHIP_MAPPING_SOURCE_NODE")
    private String sourceNode;
    @HopMetadataProperty(key="target_node", injectionKey="target_node", injectionGroupDescription="GraphOutput.Injection.RELATIONSHIP_MAPPING_TARGET_NODE")
    private String targetNode;

    public RelationshipMapping() {
        this.type = RelationshipMappingType.NoRelationship;
    }

    public RelationshipMapping(RelationshipMappingType type, String fieldName, String fieldValue, String targetRelationship, String sourceNode, String targetNode) {
        this.type = type;
        this.fieldName = fieldName;
        this.fieldValue = fieldValue;
        this.targetRelationship = targetRelationship;
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelationshipMapping that = (RelationshipMapping)o;
        return this.type == that.type && Objects.equals(this.targetRelationship, that.targetRelationship) && Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.fieldValue, that.fieldValue) && Objects.equals(this.sourceNode, that.sourceNode) && Objects.equals(this.targetNode, that.targetNode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.targetRelationship, this.fieldName, this.fieldValue, this.sourceNode, this.targetNode});
    }

    public String toString() {
        return "RelationshipMapping{type=" + this.type + ", targetRelationship='" + this.targetRelationship + "', fieldName='" + this.fieldName + "', fieldValue='" + this.fieldValue + "', sourceNode='" + this.sourceNode + "', targetNode='" + this.targetNode + "'}";
    }

    public RelationshipMappingType getType() {
        return this.type;
    }

    public void setType(RelationshipMappingType type) {
        this.type = type;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldValue() {
        return this.fieldValue;
    }

    public void setFieldValue(String fieldValue) {
        this.fieldValue = fieldValue;
    }

    public String getTargetRelationship() {
        return this.targetRelationship;
    }

    public void setTargetRelationship(String targetRelationship) {
        this.targetRelationship = targetRelationship;
    }

    public String getSourceNode() {
        return this.sourceNode;
    }

    public void setSourceNode(String sourceNode) {
        this.sourceNode = sourceNode;
    }

    public String getTargetNode() {
        return this.targetNode;
    }

    public void setTargetNode(String targetNode) {
        this.targetNode = targetNode;
    }
}

