/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CallQueueTooBigException;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.NeedUnmanagedConnectionException;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptor;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptorContext;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptorFactory;
import org.apache.hadoop.hbase.exceptions.PreemptiveFastFailException;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ServiceException;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ExceptionUtil;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class RpcRetryingCaller<T> {
    public static final Log LOG = LogFactory.getLog(RpcRetryingCaller.class);
    private long globalStartTime;
    private static final int MIN_RPC_TIMEOUT = 1;
    private final int startLogErrorsCnt;
    private final long pause;
    private final long pauseForCQTBE;
    private final int retries;
    private final int rpcTimeout;
    private final Object lock = new Object();
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final RetryingCallerInterceptor interceptor;
    private final RetryingCallerInterceptorContext context;

    public RpcRetryingCaller(long pause, long pauseForCQTBE, int retries, int startLogErrorsCnt) {
        this(pause, pauseForCQTBE, retries, RetryingCallerInterceptorFactory.NO_OP_INTERCEPTOR, startLogErrorsCnt, 0);
    }

    public RpcRetryingCaller(long pause, long pauseForCQTBE, int retries, RetryingCallerInterceptor interceptor, int startLogErrorsCnt, int rpcTimeout) {
        this.pause = pause;
        this.pauseForCQTBE = pauseForCQTBE;
        this.retries = retries;
        this.interceptor = interceptor;
        this.context = interceptor.createEmptyContext();
        this.startLogErrorsCnt = startLogErrorsCnt;
        this.rpcTimeout = rpcTimeout;
    }

    private int getRemainingTime(int callTimeout) {
        if (callTimeout <= 0) {
            return 0;
        }
        if (callTimeout == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        int remainingTime = (int)((long)callTimeout - (EnvironmentEdgeManager.currentTime() - this.globalStartTime));
        if (remainingTime < 1) {
            remainingTime = 1;
        }
        return remainingTime;
    }

    private int getTimeout(int callTimeout) {
        int timeout = this.getRemainingTime(callTimeout);
        if (timeout <= 0 || this.rpcTimeout > 0 && this.rpcTimeout < timeout) {
            timeout = this.rpcTimeout;
        }
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.lock;
        synchronized (object) {
            this.cancelled.set(true);
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T callWithRetries(RetryingCallable<T> callable, int callTimeout) throws IOException, RuntimeException {
        ArrayList<RetriesExhaustedException.ThrowableWithExtraContext> exceptions = new ArrayList<RetriesExhaustedException.ThrowableWithExtraContext>();
        this.globalStartTime = EnvironmentEdgeManager.currentTime();
        this.context.clear();
        int tries = 0;
        while (true) {
            long expectedSleep;
            Object t3;
            try {
                callable.prepare(tries != 0);
                this.interceptor.intercept(this.context.prepare(callable, tries));
                T t2 = callable.call(this.getTimeout(callTimeout));
                return t2;
            }
            catch (PreemptiveFastFailException e) {
                throw e;
            }
            catch (Throwable t3) {
                ExceptionUtil.rethrowIfInterrupt(t3);
                this.interceptor.handleFailure(this.context, t3);
                t3 = RpcRetryingCaller.translateException(t3);
                if (tries > this.startLogErrorsCnt && LOG.isInfoEnabled()) {
                    StringBuilder builder = new StringBuilder("Call exception, tries=").append(tries).append(", retries=").append(this.retries).append(", started=").append(EnvironmentEdgeManager.currentTime() - this.globalStartTime).append(" ms ago, ").append("cancelled=").append(this.cancelled.get()).append(", msg=").append(((Throwable)t3).getMessage()).append(", details=").append(callable.getExceptionMessageAdditionalDetail()).append(", see https://s.apache.org/timeout");
                    if (LOG.isDebugEnabled()) {
                        builder.append(", exception=").append(StringUtils.stringifyException((Throwable)t3));
                        LOG.debug((Object)builder.toString());
                    } else {
                        LOG.info((Object)builder.toString());
                    }
                }
                callable.throwable((Throwable)t3, this.retries != 1);
                RetriesExhaustedException.ThrowableWithExtraContext qt = new RetriesExhaustedException.ThrowableWithExtraContext((Throwable)t3, EnvironmentEdgeManager.currentTime(), this.toString());
                exceptions.add(qt);
                if (tries >= this.retries - 1) {
                    throw new RetriesExhaustedException(tries, exceptions);
                }
                long pauseBase = t3 instanceof CallQueueTooBigException ? this.pauseForCQTBE : this.pause;
                expectedSleep = callable.sleep(pauseBase, tries);
                long duration = this.singleCallDuration(expectedSleep);
                if (duration > (long)callTimeout) {
                    String msg = "callTimeout=" + callTimeout + ", callDuration=" + duration + ": " + ((Throwable)t3).getMessage() + " " + callable.getExceptionMessageAdditionalDetail();
                    throw (SocketTimeoutException)new SocketTimeoutException(msg).initCause((Throwable)t3);
                }
            }
            finally {
                this.interceptor.updateFailureInfo(this.context);
            }
            try {
                if (expectedSleep > 0L) {
                    t3 = this.lock;
                    synchronized (t3) {
                        if (this.cancelled.get()) {
                            return null;
                        }
                        this.lock.wait(expectedSleep);
                    }
                }
                if (this.cancelled.get()) {
                    return null;
                }
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException("Interrupted after " + tries + " tries  on " + this.retries);
            }
            ++tries;
        }
    }

    private long singleCallDuration(long expectedSleep) {
        return EnvironmentEdgeManager.currentTime() - this.globalStartTime + expectedSleep;
    }

    public T callWithoutRetries(RetryingCallable<T> callable, int callTimeout) throws IOException, RuntimeException {
        this.globalStartTime = EnvironmentEdgeManager.currentTime();
        try {
            callable.prepare(false);
            return callable.call(callTimeout);
        }
        catch (Throwable t) {
            Throwable t2 = RpcRetryingCaller.translateException(t);
            ExceptionUtil.rethrowIfInterrupt(t2);
            if (t2 instanceof IOException) {
                throw (IOException)t2;
            }
            throw new RuntimeException(t2);
        }
    }

    static Throwable translateException(Throwable t) throws DoNotRetryIOException {
        if (t instanceof UndeclaredThrowableException && t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof RemoteException) {
            t = ((RemoteException)t).unwrapRemoteException();
        }
        if (t instanceof LinkageError) {
            throw new DoNotRetryIOException(t);
        }
        if (t instanceof ServiceException) {
            ServiceException se = (ServiceException)t;
            Throwable cause = se.getCause();
            if (cause != null) {
                if (cause instanceof DoNotRetryIOException) {
                    throw (DoNotRetryIOException)cause;
                }
                if (cause instanceof NeedUnmanagedConnectionException) {
                    throw new DoNotRetryIOException(cause);
                }
            }
            t = cause;
            RpcRetryingCaller.translateException(t);
        } else {
            if (t instanceof DoNotRetryIOException) {
                throw (DoNotRetryIOException)t;
            }
            if (t instanceof NeedUnmanagedConnectionException) {
                throw new DoNotRetryIOException(t);
            }
        }
        return t;
    }

    public String toString() {
        return "RpcRetryingCaller{globalStartTime=" + this.globalStartTime + ", pause=" + this.pause + ", retries=" + this.retries + '}';
    }
}

