/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.svg;

import java.awt.geom.Rectangle2D;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.XMLResourceDescriptor;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.svg.SvgCacheEntry;
import org.apache.hop.core.svg.SvgFile;
import org.apache.hop.core.vfs.HopVfs;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class SvgCache {
    private static SvgCache instance;
    private Map<String, SvgCacheEntry> fileDocumentMap = new HashMap<String, SvgCacheEntry>();

    private SvgCache() {
    }

    public static SvgCache getInstance() {
        if (instance == null) {
            instance = new SvgCache();
        }
        return instance;
    }

    public static synchronized SvgCacheEntry findSvg(String filename) {
        return SvgCache.getInstance().fileDocumentMap.get(filename);
    }

    public static synchronized SvgCacheEntry loadSvg(SvgFile svgFile) throws HopException {
        SvgCacheEntry cacheEntry = SvgCache.findSvg(svgFile.getFilename());
        if (cacheEntry != null) {
            return cacheEntry;
        }
        try {
            String parser = XMLResourceDescriptor.getXMLParserClassName();
            SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(parser);
            InputStream svgStream = svgFile.getClassLoader().getResourceAsStream(svgFile.getFilename());
            if (svgStream == null) {
                svgStream = HopVfs.getInputStream(svgFile.getFilename());
            }
            SVGDocument svgDocument = factory.createSVGDocument(svgFile.getFilename(), svgStream);
            SVGSVGElement elSVG = svgDocument.getRootElement();
            float width = -1.0f;
            float height = -1.0f;
            float x = 0.0f;
            float y = 0.0f;
            String widthAttribute = elSVG.getAttribute("width");
            String heightAttribute = elSVG.getAttribute("height");
            if (widthAttribute != null && heightAttribute != null) {
                width = (float)Const.toDouble(widthAttribute.replace("px", "").replace("mm", ""), -1.0);
                height = (float)Const.toDouble(heightAttribute.replace("px", "").replace("mm", ""), -1.0);
            }
            String xAttribute = elSVG.getAttribute("x");
            String yAttribute = elSVG.getAttribute("y");
            if (xAttribute != null && yAttribute != null) {
                x = (float)Const.toDouble(xAttribute.replace("px", "").replace("mm", ""), 0.0);
                y = (float)Const.toDouble(yAttribute.replace("px", "").replace("mm", ""), 0.0);
            }
            if (width <= 1.0f || height <= 1.0f) {
                String[] parts;
                String attributeNS;
                UserAgentAdapter agent = new UserAgentAdapter();
                DocumentLoader loader = new DocumentLoader((UserAgent)agent);
                BridgeContext context = new BridgeContext((UserAgent)agent, loader);
                context.setDynamic(true);
                GVTBuilder builder = new GVTBuilder();
                GraphicsNode root = builder.build(context, (Document)svgDocument);
                Rectangle2D primitiveBounds = root.getPrimitiveBounds();
                width = (float)primitiveBounds.getWidth();
                height = (float)primitiveBounds.getHeight();
                x = (float)primitiveBounds.getX();
                y = (float)primitiveBounds.getY();
                if ((width <= 1.0f || height <= 1.0f) && StringUtils.isNotEmpty((String)(attributeNS = elSVG.getAttributeNS(null, "viewBox"))) && (parts = attributeNS.split(" ")).length == 4) {
                    width = (float)Const.toDouble(parts[2], 0.0);
                    height = (float)Const.toDouble(parts[3], 0.0);
                }
            }
            if (width <= 1.0f || height <= 1.0f) {
                throw new HopException("Couldn't determine width or height of file : " + svgFile.getFilename());
            }
            cacheEntry = new SvgCacheEntry(svgFile.getFilename(), svgDocument, Math.round(width), Math.round(height), Math.round(x), Math.round(y));
            SvgCache.getInstance().fileDocumentMap.put(svgFile.getFilename(), cacheEntry);
            return cacheEntry;
        }
        catch (Exception e) {
            throw new HopException("Error loading SVG file " + svgFile.getFilename(), e);
        }
    }

    public static synchronized void addSvg(String filename, SVGDocument svgDocument, int width, int height, int x, int y) {
        SvgCache.getInstance().fileDocumentMap.put(filename, new SvgCacheEntry(filename, svgDocument, width, height, x, y));
    }
}

