/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.projects.config;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.config.plugin.IConfigOptions;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import org.apache.hop.projects.config.ProjectsConfig;
import org.apache.hop.projects.config.ProjectsConfigSingleton;
import org.apache.hop.projects.environment.LifecycleEnvironment;
import org.apache.hop.projects.project.Project;
import org.apache.hop.projects.project.ProjectConfig;
import org.apache.hop.projects.util.ProjectsUtil;
import picocli.CommandLine;

public class ProjectsOptionPlugin
implements IConfigOptions {
    @CommandLine.Option(names={"-e", "--environment"}, description={"The name of the lifecycle environment to use"})
    private String environmentOption = null;
    @CommandLine.Option(names={"-j", "--project"}, description={"The name of the project to use"})
    private String projectOption = null;
    protected ProjectsConfig config;
    protected ProjectConfig projectConfig;
    protected List<String> configurationFiles;
    protected Project project;
    protected String projectName;
    protected String environmentName;
    protected LifecycleEnvironment environment;

    public boolean handleOption(ILogChannel log, IHasHopMetadataProvider hasHopMetadataProvider, IVariables variables) throws HopException {
        this.config = ProjectsConfigSingleton.getConfig();
        this.projectConfig = null;
        this.configurationFiles = new ArrayList<String>();
        this.projectName = this.projectOption;
        this.environmentName = this.environmentOption;
        if (StringUtils.isEmpty((String)this.environmentName)) {
            this.environmentName = this.config.getDefaultEnvironment();
        }
        if (this.config.isEnvironmentMandatory() && StringUtils.isEmpty((String)this.environmentName)) {
            throw new HopException("Use of an environment is configured to be mandatory and none was specified.");
        }
        if (StringUtils.isEmpty((String)this.projectName)) {
            this.projectName = this.config.getDefaultProject();
        }
        if (this.config.isProjectMandatory() && StringUtils.isEmpty((String)this.projectName)) {
            throw new HopException("Use of a project is configured to be mandatory and none was specified.");
        }
        if (StringUtils.isNotEmpty((String)this.environmentName)) {
            this.environment = this.config.findEnvironment(this.environmentName);
            if (this.environment == null) {
                throw new HopException("Unable to find lifecycle environment '" + this.environmentName + "'");
            }
            this.projectName = this.environment.getProjectName();
            if (StringUtils.isEmpty((String)this.projectName)) {
                throw new HopException("Lifecycle environment '" + this.environmentOption + "' is not referencing a project.");
            }
            this.projectConfig = this.config.findProjectConfig(this.projectName);
            if (this.projectConfig == null) {
                throw new HopException("Unable to find project '" + this.projectName + "' referenced in environment '" + this.environmentName);
            }
            this.configurationFiles.addAll(this.environment.getConfigurationFiles());
            log.logBasic("Referencing environment '" + this.environmentOption + "' for project " + this.projectName + "' in " + this.environment.getPurpose());
        } else if (StringUtils.isNotEmpty((String)this.projectName)) {
            this.projectConfig = this.config.findProjectConfig(this.projectName);
            if (this.projectConfig == null) {
                throw new HopException("Unable to find project '" + this.projectName + "'");
            }
            this.projectName = this.projectConfig.getProjectName();
        } else {
            log.logDebug("No project or environment referenced.");
            return false;
        }
        try {
            Project project = this.projectConfig.loadProject(variables);
            log.logBasic("Enabling project '" + this.projectName + "'");
            if (project == null) {
                throw new HopException("Project '" + this.projectName + "' couldn't be found");
            }
            ProjectsUtil.enableProject(log, this.projectName, project, variables, this.configurationFiles, this.environmentName, hasHopMetadataProvider);
            return true;
        }
        catch (Exception e) {
            throw new HopException("Error enabling project '" + this.projectName + "'", (Throwable)e);
        }
    }
}

