/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Processor;
import org.apache.camel.model.ClaimCheckOperation;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.processor.ClaimCheckProcessor;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.AggregationStrategyBeanAdapter;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="eip,routing")
@XmlRootElement(name="claimCheck")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ClaimCheckDefinition
extends NoOutputDefinition<ClaimCheckDefinition> {
    @XmlAttribute(required=true)
    private ClaimCheckOperation operation;
    @XmlAttribute
    private String key;
    @XmlAttribute
    private String filter;
    @XmlAttribute(name="strategyRef")
    @Metadata(label="advanced")
    private String aggregationStrategyRef;
    @XmlAttribute(name="strategyMethodName")
    @Metadata(label="advanced")
    private String aggregationStrategyMethodName;
    @XmlTransient
    private AggregationStrategy aggregationStrategy;

    public String toString() {
        if (this.operation != null) {
            return "ClaimCheck[" + (Object)((Object)this.operation) + "]";
        }
        return "ClaimCheck";
    }

    @Override
    public String getShortName() {
        return "claimCheck";
    }

    @Override
    public String getLabel() {
        return "claimCheck";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        ObjectHelper.notNull(this.operation, "operation", this);
        ClaimCheckProcessor claim = new ClaimCheckProcessor();
        claim.setOperation(this.operation.name());
        claim.setKey(this.getKey());
        claim.setFilter(this.getFilter());
        AggregationStrategy strategy = this.createAggregationStrategy(routeContext);
        if (strategy != null) {
            claim.setAggregationStrategy(strategy);
        }
        if (this.getFilter() != null && strategy != null) {
            throw new IllegalArgumentException("Cannot use both filter and custom aggregation strategy on ClaimCheck EIP");
        }
        if (this.getFilter() != null) {
            boolean bl;
            Iterable<Object> it = ObjectHelper.createIterable(this.filter, ",");
            boolean includeBody = false;
            boolean excludeBody = false;
            for (Object o : it) {
                String pattern = o.toString();
                if ("body".equals(pattern) || "+body".equals(pattern)) {
                    includeBody = true;
                    continue;
                }
                if (!"-body".equals(pattern)) continue;
                excludeBody = true;
            }
            if (includeBody && excludeBody) {
                throw new IllegalArgumentException("Cannot have both include and exclude body at the same time in the filter: " + this.filter);
            }
            boolean includeHeaders = false;
            boolean excludeHeaders = false;
            for (Object e : it) {
                String pattern = e.toString();
                if ("headers".equals(pattern) || "+headers".equals(pattern)) {
                    includeHeaders = true;
                    continue;
                }
                if (!"-headers".equals(pattern)) continue;
                excludeHeaders = true;
            }
            if (includeHeaders && excludeHeaders) {
                throw new IllegalArgumentException("Cannot have both include and exclude headers at the same time in the filter: " + this.filter);
            }
            boolean includeHeader = false;
            boolean bl2 = false;
            for (Object o : it) {
                String pattern = o.toString();
                if (pattern.startsWith("header:") || pattern.startsWith("+header:")) {
                    includeHeader = true;
                    continue;
                }
                if (!pattern.startsWith("-header:")) continue;
                bl = true;
            }
            if (includeHeader && bl) {
                throw new IllegalArgumentException("Cannot have both include and exclude header at the same time in the filter: " + this.filter);
            }
        }
        return claim;
    }

    private AggregationStrategy createAggregationStrategy(RouteContext routeContext) {
        AggregationStrategy strategy = this.getAggregationStrategy();
        if (strategy == null && this.aggregationStrategyRef != null) {
            Object aggStrategy = routeContext.lookup(this.aggregationStrategyRef, Object.class);
            if (aggStrategy instanceof AggregationStrategy) {
                strategy = (AggregationStrategy)aggStrategy;
            } else if (aggStrategy != null) {
                strategy = new AggregationStrategyBeanAdapter(aggStrategy, this.getAggregationStrategyMethodName());
            } else {
                throw new IllegalArgumentException("Cannot find AggregationStrategy in Registry with name: " + this.aggregationStrategyRef);
            }
        }
        if (strategy instanceof CamelContextAware) {
            ((CamelContextAware)((Object)strategy)).setCamelContext(routeContext.getCamelContext());
        }
        return strategy;
    }

    public ClaimCheckDefinition operation(ClaimCheckOperation operation) {
        this.setOperation(operation);
        return this;
    }

    public ClaimCheckDefinition key(String key) {
        this.setKey(key);
        return this;
    }

    public ClaimCheckDefinition filter(String filter) {
        this.setFilter(filter);
        return this;
    }

    public ClaimCheckDefinition aggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy);
        return this;
    }

    public ClaimCheckDefinition aggregationStrategyRef(String aggregationStrategyRef) {
        this.setAggregationStrategyRef(aggregationStrategyRef);
        return this;
    }

    public ClaimCheckDefinition aggregationStrategyMethodName(String aggregationStrategyMethodName) {
        this.setAggregationStrategyMethodName(aggregationStrategyMethodName);
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public ClaimCheckOperation getOperation() {
        return this.operation;
    }

    public void setOperation(ClaimCheckOperation operation) {
        this.operation = operation;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getAggregationStrategyRef() {
        return this.aggregationStrategyRef;
    }

    public void setAggregationStrategyRef(String aggregationStrategyRef) {
        this.aggregationStrategyRef = aggregationStrategyRef;
    }

    public String getAggregationStrategyMethodName() {
        return this.aggregationStrategyMethodName;
    }

    public void setAggregationStrategyMethodName(String aggregationStrategyMethodName) {
        this.aggregationStrategyMethodName = aggregationStrategyMethodName;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }
}

