/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Comparator;
import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.processor.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;

public class SortProcessor<T>
extends ServiceSupport
implements AsyncProcessor,
Traceable,
IdAware {
    private String id;
    private final Expression expression;
    private final Comparator<? super T> comparator;

    public SortProcessor(Expression expression, Comparator<? super T> comparator) {
        this.expression = expression;
        this.comparator = comparator;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            Message in = exchange.getIn();
            List list = this.expression.evaluate(exchange, List.class);
            list.sort(this.comparator);
            if (exchange.getPattern().isOutCapable()) {
                Message out = exchange.getOut();
                out.copyFromWithNewBody(in, list);
            } else {
                in.setBody(list);
            }
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return "Sort[" + this.expression + "]";
    }

    @Override
    public String getTraceLabel() {
        return "sort[" + this.expression + "]";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Comparator<? super T> getComparator() {
        return this.comparator;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

