/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.protocol;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.InvalidClientIDException;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.AbstractRegion;
import org.apache.activemq.broker.region.DurableTopicSubscription;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.TopicRegion;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTempDestination;
import org.apache.activemq.command.ActiveMQTempQueue;
import org.apache.activemq.command.ActiveMQTempTopic;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionError;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerControl;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.LocalTransactionId;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.RemoveInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.command.ShutdownInfo;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.transport.InactivityIOException;
import org.apache.activemq.transport.amqp.AmqpHeader;
import org.apache.activemq.transport.amqp.AmqpInactivityMonitor;
import org.apache.activemq.transport.amqp.AmqpProtocolConverter;
import org.apache.activemq.transport.amqp.AmqpProtocolException;
import org.apache.activemq.transport.amqp.AmqpSupport;
import org.apache.activemq.transport.amqp.AmqpTransport;
import org.apache.activemq.transport.amqp.AmqpTransportFilter;
import org.apache.activemq.transport.amqp.AmqpWireFormat;
import org.apache.activemq.transport.amqp.protocol.AmqpLink;
import org.apache.activemq.transport.amqp.protocol.AmqpResource;
import org.apache.activemq.transport.amqp.protocol.AmqpSender;
import org.apache.activemq.transport.amqp.protocol.AmqpSession;
import org.apache.activemq.transport.amqp.protocol.AmqpTransactionCoordinator;
import org.apache.activemq.transport.amqp.protocol.ResponseHandler;
import org.apache.activemq.transport.amqp.sasl.AmqpAuthenticator;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.IdGenerator;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transaction.Coordinator;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Collector;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.CollectorImpl;
import org.apache.qpid.proton.engine.impl.ProtocolTracer;
import org.apache.qpid.proton.engine.impl.TransportImpl;
import org.apache.qpid.proton.framing.TransportFrame;
import org.fusesource.hawtbuf.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpConnection
implements AmqpProtocolConverter {
    private static final Logger TRACE_FRAMES = AmqpTransportFilter.TRACE_FRAMES;
    private static final Logger LOG = LoggerFactory.getLogger(AmqpConnection.class);
    private static final int CHANNEL_MAX = Short.MAX_VALUE;
    private static final String BROKER_VERSION;
    private static final String BROKER_PLATFORM;
    private final Transport protonTransport = Proton.transport();
    private final Connection protonConnection = Proton.connection();
    private final Collector eventCollector = new CollectorImpl();
    private final AmqpTransport amqpTransport;
    private final AmqpWireFormat amqpWireFormat;
    private final BrokerService brokerService;
    private static final IdGenerator CONNECTION_ID_GENERATOR;
    private final AtomicInteger lastCommandId = new AtomicInteger();
    private final ConnectionId connectionId = new ConnectionId(CONNECTION_ID_GENERATOR.generateId());
    private final ConnectionInfo connectionInfo = new ConnectionInfo();
    private long nextSessionId;
    private long nextTempDestinationId;
    private long nextTransactionId;
    private boolean closing;
    private boolean closedSocket;
    private AmqpAuthenticator authenticator;
    private final Map<TransactionId, AmqpTransactionCoordinator> transactions = new HashMap<TransactionId, AmqpTransactionCoordinator>();
    private final ConcurrentMap<Integer, ResponseHandler> resposeHandlers = new ConcurrentHashMap<Integer, ResponseHandler>();
    private final ConcurrentMap<ConsumerId, AmqpSender> subscriptionsByConsumerId = new ConcurrentHashMap<ConsumerId, AmqpSender>();

    public AmqpConnection(AmqpTransport transport, BrokerService brokerService) {
        this.amqpTransport = transport;
        AmqpInactivityMonitor monitor = transport.getInactivityMonitor();
        if (monitor != null) {
            monitor.setAmqpTransport(this.amqpTransport);
        }
        this.amqpWireFormat = transport.getWireFormat();
        this.brokerService = brokerService;
        int maxFrameSize = this.amqpWireFormat.getMaxAmqpFrameSize();
        if (maxFrameSize > -1) {
            this.protonTransport.setMaxFrameSize(maxFrameSize);
            try {
                this.protonTransport.setOutboundFrameSizeLimit(maxFrameSize);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.protonTransport.bind(this.protonConnection);
        this.protonTransport.setChannelMax(Short.MAX_VALUE);
        this.protonTransport.setEmitFlowEventOnSend(false);
        this.protonConnection.collect(this.eventCollector);
        this.updateTracer();
    }

    protected Symbol[] getConnectionCapabilitiesOffered() {
        return new Symbol[]{AmqpSupport.ANONYMOUS_RELAY, AmqpSupport.DELAYED_DELIVERY};
    }

    protected Map<Symbol, Object> getConnetionProperties() {
        HashMap<Symbol, Object> properties = new HashMap<Symbol, Object>();
        properties.put(AmqpSupport.QUEUE_PREFIX, "queue://");
        properties.put(AmqpSupport.TOPIC_PREFIX, "topic://");
        properties.put(AmqpSupport.PRODUCT, "ActiveMQ");
        properties.put(AmqpSupport.VERSION, BROKER_VERSION);
        properties.put(AmqpSupport.PLATFORM, BROKER_PLATFORM);
        return properties;
    }

    protected Map<Symbol, Object> getFailedConnetionProperties() {
        HashMap<Symbol, Object> properties = new HashMap<Symbol, Object>();
        properties.put(AmqpSupport.CONNECTION_OPEN_FAILED, true);
        return properties;
    }

    @Override
    public void updateTracer() {
        if (this.amqpTransport.isTrace()) {
            ((TransportImpl)this.protonTransport).setProtocolTracer(new ProtocolTracer(){

                public void receivedFrame(TransportFrame transportFrame) {
                    TRACE_FRAMES.trace("{} | RECV: {}", (Object)AmqpConnection.this.amqpTransport.getRemoteAddress(), (Object)transportFrame.getBody());
                }

                public void sentFrame(TransportFrame transportFrame) {
                    TRACE_FRAMES.trace("{} | SENT: {}", (Object)AmqpConnection.this.amqpTransport.getRemoteAddress(), (Object)transportFrame.getBody());
                }
            });
        }
    }

    @Override
    public long keepAlive() throws IOException {
        long rescheduleAt = 0L;
        LOG.trace("Performing connection:{} keep-alive processing", (Object)this.amqpTransport.getRemoteAddress());
        if (this.protonConnection.getLocalState() != EndpointState.CLOSED) {
            long now = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            long deadline = this.protonTransport.tick(now);
            this.pumpProtonToSocket();
            if (this.protonTransport.isClosed()) {
                LOG.debug("Transport closed after inactivity check.");
                throw new InactivityIOException("Channel was inactive for too long");
            }
            if (deadline != 0L) {
                rescheduleAt = Math.max(deadline - now, 1L);
            }
        }
        LOG.trace("Connection:{} keep alive processing done, next update in {} milliseconds.", (Object)this.amqpTransport.getRemoteAddress(), (Object)rescheduleAt);
        return rescheduleAt;
    }

    public int getConfiguredReceiverCredit() {
        return this.amqpWireFormat.getProducerCredit();
    }

    public String getConfiguredTransformer() {
        return this.amqpWireFormat.getTransformer();
    }

    public ConnectionId getConnectionId() {
        return this.connectionId;
    }

    public String getClientId() {
        return this.connectionInfo.getClientId();
    }

    public long getMaxFrameSize() {
        return this.amqpWireFormat.getMaxFrameSize();
    }

    void pumpProtonToSocket() {
        try {
            boolean done = false;
            while (!done) {
                ByteBuffer toWrite = this.protonTransport.getOutputBuffer();
                if (toWrite != null && toWrite.hasRemaining()) {
                    LOG.trace("Server: Sending {} bytes out", (Object)toWrite.limit());
                    this.amqpTransport.sendToAmqp(toWrite);
                    this.protonTransport.outputConsumed();
                    continue;
                }
                done = true;
            }
        }
        catch (IOException e) {
            this.amqpTransport.onException(e);
        }
    }

    @Override
    public void onAMQPData(Object command) throws Exception {
        Buffer frame;
        if (command.getClass() == AmqpHeader.class) {
            AmqpHeader header = (AmqpHeader)command;
            if (this.amqpWireFormat.isHeaderValid(header, this.authenticator != null)) {
                LOG.trace("Connection from an AMQP v1.0 client initiated. {}", (Object)header);
            } else {
                LOG.warn("Connection attempt from non AMQP v1.0 client. {}", (Object)header);
                AmqpHeader reply = this.amqpWireFormat.getMinimallySupportedHeader();
                this.amqpTransport.sendToAmqp(reply.getBuffer());
                this.handleException(new AmqpProtocolException("Connection from client using unsupported AMQP attempted", true));
            }
            switch (header.getProtocolId()) {
                case 0: {
                    this.authenticator = null;
                    break;
                }
                case 3: {
                    this.authenticator = new AmqpAuthenticator(this.amqpTransport, this.protonTransport.sasl(), this.brokerService);
                    break;
                }
            }
            frame = header.getBuffer();
        } else {
            frame = (Buffer)command;
        }
        if (this.protonTransport.isClosed()) {
            LOG.debug("Ignoring incoming AMQP data, transport is closed.");
            return;
        }
        LOG.trace("Server: Received from client: {} bytes", (Object)frame.getLength());
        while (frame.length > 0) {
            try {
                int count = this.protonTransport.input(frame.data, frame.offset, frame.length);
                frame.moveHead(count);
            }
            catch (Throwable e) {
                this.handleException(new AmqpProtocolException("Could not decode AMQP frame: " + String.valueOf(frame), true, e));
                return;
            }
            if (this.authenticator != null) {
                this.processSaslExchange();
                continue;
            }
            this.processProtonEvents();
        }
    }

    private void processSaslExchange() throws Exception {
        this.authenticator.processSaslExchange(this.connectionInfo);
        if (this.authenticator.isDone()) {
            this.amqpTransport.getWireFormat().resetMagicRead();
        }
        this.pumpProtonToSocket();
    }

    private void processProtonEvents() throws Exception {
        try {
            Event event = null;
            while ((event = this.eventCollector.peek()) != null) {
                if (this.amqpTransport.isTrace()) {
                    LOG.trace("Server: Processing event: {}", (Object)event.getType());
                }
                switch (event.getType()) {
                    case CONNECTION_REMOTE_OPEN: {
                        this.processConnectionOpen(event.getConnection());
                        break;
                    }
                    case CONNECTION_REMOTE_CLOSE: {
                        this.processConnectionClose(event.getConnection());
                        break;
                    }
                    case SESSION_REMOTE_OPEN: {
                        this.processSessionOpen(event.getSession());
                        break;
                    }
                    case SESSION_REMOTE_CLOSE: {
                        this.processSessionClose(event.getSession());
                        break;
                    }
                    case LINK_REMOTE_OPEN: {
                        this.processLinkOpen(event.getLink());
                        break;
                    }
                    case LINK_REMOTE_DETACH: {
                        this.processLinkDetach(event.getLink());
                        break;
                    }
                    case LINK_REMOTE_CLOSE: {
                        this.processLinkClose(event.getLink());
                        break;
                    }
                    case LINK_FLOW: {
                        this.processLinkFlow(event.getLink());
                        break;
                    }
                    case DELIVERY: {
                        this.processDelivery(event.getDelivery());
                        break;
                    }
                }
                this.eventCollector.pop();
            }
        }
        catch (Throwable e) {
            this.handleException(new AmqpProtocolException("Could not process AMQP commands", true, e));
        }
        this.pumpProtonToSocket();
    }

    protected void processConnectionOpen(Connection connection) throws Exception {
        this.stopConnectionTimeoutChecker();
        this.connectionInfo.setResponseRequired(true);
        this.connectionInfo.setConnectionId(this.connectionId);
        String clientId = this.protonConnection.getRemoteContainer();
        if (clientId != null && !clientId.isEmpty()) {
            this.connectionInfo.setClientId(clientId);
        }
        this.connectionInfo.setTransportContext((Object)this.amqpTransport.getPeerCertificates());
        if (connection.getTransport().getRemoteIdleTimeout() > 0 && !this.amqpTransport.isUseInactivityMonitor()) {
            this.protonConnection.setProperties(this.getFailedConnetionProperties());
            this.protonConnection.open();
            this.protonConnection.setCondition(new ErrorCondition(AmqpError.PRECONDITION_FAILED, "Cannot send idle frames"));
            this.protonConnection.close();
            this.pumpProtonToSocket();
            this.amqpTransport.onException(new IOException("Connection failed, remote requested idle processing but inactivity monitoring is disbaled."));
            return;
        }
        this.sendToActiveMQ((Command)this.connectionInfo, new ResponseHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResponse(AmqpProtocolConverter converter, Response response) throws IOException {
                Throwable exception = null;
                try {
                    if (response.isException()) {
                        AmqpConnection.this.protonConnection.setProperties(AmqpConnection.this.getFailedConnetionProperties());
                        AmqpConnection.this.protonConnection.open();
                        exception = ((ExceptionResponse)response).getException();
                        if (exception instanceof SecurityException) {
                            AmqpConnection.this.protonConnection.setCondition(new ErrorCondition(AmqpError.UNAUTHORIZED_ACCESS, exception.getMessage()));
                        } else if (exception instanceof InvalidClientIDException) {
                            ErrorCondition condition = new ErrorCondition(AmqpError.INVALID_FIELD, exception.getMessage());
                            HashMap<Symbol, Symbol> infoMap = new HashMap<Symbol, Symbol>();
                            infoMap.put(AmqpSupport.INVALID_FIELD, AmqpSupport.CONTAINER_ID);
                            condition.setInfo(infoMap);
                            AmqpConnection.this.protonConnection.setCondition(condition);
                        } else {
                            AmqpConnection.this.protonConnection.setCondition(new ErrorCondition(AmqpError.ILLEGAL_STATE, exception.getMessage()));
                        }
                        AmqpConnection.this.protonConnection.close();
                    } else {
                        if (AmqpConnection.this.amqpTransport.isUseInactivityMonitor() && AmqpConnection.this.amqpWireFormat.getIdleTimeout() > 0) {
                            LOG.trace("Connection requesting Idle timeout of: {} mills", (Object)AmqpConnection.this.amqpWireFormat.getIdleTimeout());
                            AmqpConnection.this.protonTransport.setIdleTimeout(AmqpConnection.this.amqpWireFormat.getIdleTimeout());
                        }
                        AmqpConnection.this.protonConnection.setOfferedCapabilities(AmqpConnection.this.getConnectionCapabilitiesOffered());
                        AmqpConnection.this.protonConnection.setProperties(AmqpConnection.this.getConnetionProperties());
                        AmqpConnection.this.protonConnection.setContainer(AmqpConnection.this.brokerService.getBrokerName());
                        AmqpConnection.this.protonConnection.open();
                        AmqpConnection.this.configureInactivityMonitor();
                    }
                    AmqpConnection.this.pumpProtonToSocket();
                }
                catch (Throwable throwable) {
                    AmqpConnection.this.pumpProtonToSocket();
                    if (response.isException()) {
                        AmqpConnection.this.amqpTransport.onException(IOExceptionSupport.create(exception));
                    }
                    throw throwable;
                }
                if (response.isException()) {
                    AmqpConnection.this.amqpTransport.onException(IOExceptionSupport.create((Throwable)exception));
                }
            }
        });
    }

    protected void processConnectionClose(Connection connection) throws Exception {
        if (!this.closing) {
            this.closing = true;
            this.sendToActiveMQ((Command)new RemoveInfo((DataStructure)this.connectionId), new ResponseHandler(){

                @Override
                public void onResponse(AmqpProtocolConverter converter, Response response) throws IOException {
                    AmqpConnection.this.protonConnection.close();
                    AmqpConnection.this.protonConnection.free();
                    if (!AmqpConnection.this.closedSocket) {
                        AmqpConnection.this.pumpProtonToSocket();
                    }
                }
            });
            this.sendToActiveMQ((Command)new ShutdownInfo());
        }
    }

    protected void processSessionOpen(Session protonSession) throws Exception {
        new AmqpSession(this, this.getNextSessionId(), protonSession).open();
    }

    protected void processSessionClose(Session protonSession) throws Exception {
        if (protonSession.getContext() != null) {
            ((AmqpResource)protonSession.getContext()).close();
        } else {
            protonSession.close();
            protonSession.free();
        }
    }

    protected void processLinkOpen(Link link) throws Exception {
        link.setSource(link.getRemoteSource());
        link.setTarget(link.getRemoteTarget());
        AmqpSession session = (AmqpSession)link.getSession().getContext();
        if (link instanceof Receiver) {
            if (link.getRemoteTarget() instanceof Coordinator) {
                session.createCoordinator((Receiver)link);
            } else {
                session.createReceiver((Receiver)link);
            }
        } else {
            session.createSender((Sender)link);
        }
    }

    protected void processLinkDetach(Link link) throws Exception {
        Object context = link.getContext();
        if (context instanceof AmqpLink) {
            ((AmqpLink)context).detach();
        } else {
            link.detach();
            link.free();
        }
    }

    protected void processLinkClose(Link link) throws Exception {
        Object context = link.getContext();
        if (context instanceof AmqpLink) {
            ((AmqpLink)context).close();
        } else {
            link.close();
            link.free();
        }
    }

    protected void processLinkFlow(Link link) throws Exception {
        Object context = link.getContext();
        if (context instanceof AmqpLink) {
            ((AmqpLink)context).flow();
        }
    }

    protected void processDelivery(Delivery delivery) throws Exception {
        Object context;
        if (!delivery.isPartial() && (context = delivery.getLink().getContext()) instanceof AmqpLink) {
            AmqpLink amqpLink = (AmqpLink)context;
            amqpLink.delivery(delivery);
        }
    }

    @Override
    public void onAMQPException(IOException error) {
        this.closedSocket = true;
        if (!this.closing) {
            try {
                this.closing = true;
                this.protonConnection.setCondition(new ErrorCondition(AmqpError.DECODE_ERROR, error.getMessage()));
                this.protonConnection.close();
                this.pumpProtonToSocket();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.amqpTransport.sendToActiveMQ(error);
        } else {
            try {
                this.amqpTransport.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void onActiveMQCommand(Command command) throws Exception {
        if (command.isResponse()) {
            Response response = (Response)command;
            ResponseHandler rh = (ResponseHandler)this.resposeHandlers.remove(response.getCorrelationId());
            if (rh != null) {
                rh.onResponse(this, response);
            } else if (response.isException()) {
                Throwable exception = ((ExceptionResponse)response).getException();
                this.handleException(exception);
            }
        } else if (command.isMessageDispatch()) {
            MessageDispatch dispatch = (MessageDispatch)command;
            AmqpSender sender = (AmqpSender)this.subscriptionsByConsumerId.get(dispatch.getConsumerId());
            if (sender != null) {
                if (dispatch.getMessage() != null) {
                    LOG.trace("Dispatching MessageId: {} to consumer", (Object)dispatch.getMessage().getMessageId());
                } else {
                    LOG.trace("Dispatching End of Browse Command to consumer {}", (Object)dispatch.getConsumerId());
                }
                sender.onMessageDispatch(dispatch);
                if (dispatch.getMessage() != null) {
                    LOG.trace("Finished Dispatch of MessageId: {} to consumer", (Object)dispatch.getMessage().getMessageId());
                }
            }
        } else if (command.getDataStructureType() == 16) {
            Throwable exception = ((ConnectionError)command).getException();
            this.handleException(exception);
        } else if (command.isConsumerControl()) {
            ConsumerControl control = (ConsumerControl)command;
            AmqpSender sender = (AmqpSender)this.subscriptionsByConsumerId.get(control.getConsumerId());
            if (sender != null) {
                sender.onConsumerControl(control);
            }
        } else if (!command.isBrokerInfo()) {
            LOG.debug("Do not know how to process ActiveMQ Command {}", (Object)command);
        }
    }

    void registerSender(ConsumerId consumerId, AmqpSender sender) {
        this.subscriptionsByConsumerId.put(consumerId, sender);
    }

    void unregisterSender(ConsumerId consumerId) {
        this.subscriptionsByConsumerId.remove(consumerId);
    }

    void registerTransaction(TransactionId txId, AmqpTransactionCoordinator coordinator) {
        this.transactions.put(txId, coordinator);
    }

    void unregisterTransaction(TransactionId txId) {
        this.transactions.remove(txId);
    }

    AmqpTransactionCoordinator getTxCoordinator(TransactionId txId) {
        return this.transactions.get(txId);
    }

    LocalTransactionId getNextTransactionId() {
        return new LocalTransactionId(this.getConnectionId(), ++this.nextTransactionId);
    }

    ConsumerInfo lookupSubscription(String subscriptionName) throws AmqpProtocolException {
        RegionBroker regionBroker;
        ConsumerInfo result = null;
        try {
            regionBroker = (RegionBroker)this.brokerService.getBroker().getAdaptor(RegionBroker.class);
        }
        catch (Exception e) {
            throw new AmqpProtocolException("Error finding subscription: " + subscriptionName + ": " + e.getMessage(), false, e);
        }
        TopicRegion topicRegion = (TopicRegion)regionBroker.getTopicRegion();
        DurableTopicSubscription subscription = topicRegion.lookupSubscription(subscriptionName, this.connectionInfo.getClientId());
        if (subscription != null) {
            result = subscription.getConsumerInfo();
        }
        return result;
    }

    Subscription lookupPrefetchSubscription(ConsumerInfo consumerInfo) {
        Subscription subscription = null;
        try {
            subscription = (Subscription)((AbstractRegion)((RegionBroker)this.brokerService.getBroker().getAdaptor(RegionBroker.class)).getRegion(consumerInfo.getDestination())).getSubscriptions().get(consumerInfo.getConsumerId());
        }
        catch (Exception e) {
            LOG.warn("Error finding subscription for: " + String.valueOf(consumerInfo) + ": " + e.getMessage(), (Object)false, (Object)e);
        }
        return subscription;
    }

    ActiveMQDestination createTemporaryDestination(final Link link, Symbol[] capabilities) {
        ActiveMQTempTopic rc = null;
        if (AmqpSupport.contains(capabilities, AmqpSupport.TEMP_TOPIC_CAPABILITY)) {
            rc = new ActiveMQTempTopic(this.connectionId, this.nextTempDestinationId++);
        } else if (AmqpSupport.contains(capabilities, AmqpSupport.TEMP_QUEUE_CAPABILITY)) {
            rc = new ActiveMQTempQueue(this.connectionId, this.nextTempDestinationId++);
        } else {
            LOG.debug("Dynamic link request with no type capability, defaults to Temporary Queue");
            rc = new ActiveMQTempQueue(this.connectionId, this.nextTempDestinationId++);
        }
        DestinationInfo info = new DestinationInfo();
        info.setConnectionId(this.connectionId);
        info.setOperationType((byte)0);
        info.setDestination((ActiveMQDestination)rc);
        this.sendToActiveMQ((Command)info, new ResponseHandler(){

            @Override
            public void onResponse(AmqpProtocolConverter converter, Response response) throws IOException {
                if (response.isException()) {
                    link.setSource(null);
                    Throwable exception = ((ExceptionResponse)response).getException();
                    if (exception instanceof SecurityException) {
                        link.setCondition(new ErrorCondition(AmqpError.UNAUTHORIZED_ACCESS, exception.getMessage()));
                    } else {
                        link.setCondition(new ErrorCondition(AmqpError.INTERNAL_ERROR, exception.getMessage()));
                    }
                    link.close();
                    link.free();
                }
            }
        });
        return rc;
    }

    void deleteTemporaryDestination(ActiveMQTempDestination destination) {
        DestinationInfo info = new DestinationInfo();
        info.setConnectionId(this.connectionId);
        info.setOperationType((byte)1);
        info.setDestination((ActiveMQDestination)destination);
        this.sendToActiveMQ((Command)info, new ResponseHandler(){

            @Override
            public void onResponse(AmqpProtocolConverter converter, Response response) throws IOException {
                if (response.isException()) {
                    Throwable exception = ((ExceptionResponse)response).getException();
                    LOG.debug("Error during temp destination removeal: {}", (Object)exception.getMessage());
                }
            }
        });
    }

    void sendToActiveMQ(Command command) {
        this.sendToActiveMQ(command, null);
    }

    void sendToActiveMQ(Command command, ResponseHandler handler) {
        command.setCommandId(this.lastCommandId.incrementAndGet());
        if (handler != null) {
            command.setResponseRequired(true);
            this.resposeHandlers.put(command.getCommandId(), handler);
        }
        this.amqpTransport.sendToActiveMQ(command);
    }

    void handleException(Throwable exception) {
        LOG.debug("Exception detail", exception);
        if (exception instanceof AmqpProtocolException) {
            this.onAMQPException((IOException)exception);
        } else {
            try {
                this.sendToActiveMQ((Command)new ShutdownInfo());
                this.amqpTransport.stop();
            }
            catch (Throwable e) {
                LOG.error("Failed to stop AMQP Transport ", e);
            }
        }
    }

    private SessionId getNextSessionId() {
        return new SessionId(this.connectionId, this.nextSessionId++);
    }

    private void stopConnectionTimeoutChecker() {
        AmqpInactivityMonitor monitor = this.amqpTransport.getInactivityMonitor();
        if (monitor != null) {
            monitor.stopConnectionTimeoutChecker();
        }
    }

    private void configureInactivityMonitor() {
        AmqpInactivityMonitor monitor = this.amqpTransport.getInactivityMonitor();
        if (monitor == null) {
            return;
        }
        long now = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        long nextIdleCheck = this.protonTransport.tick(now);
        if (nextIdleCheck != 0L) {
            long delay = Math.max(nextIdleCheck - now, 1L);
            LOG.trace("Connection keep-alive processing starts in: {}", (Object)delay);
            monitor.startKeepAliveTask(delay);
        } else {
            LOG.trace("Connection does not require keep-alive processing");
        }
    }

    static {
        String javaVersion = System.getProperty("java.version");
        BROKER_PLATFORM = "Java/" + (javaVersion == null ? "unknown" : javaVersion);
        InputStream in = null;
        String version = "<unknown-5.x>";
        in = AmqpConnection.class.getResourceAsStream("/org/apache/activemq/version.txt");
        if (in != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            try {
                version = reader.readLine();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        BROKER_VERSION = version;
        CONNECTION_ID_GENERATOR = new IdGenerator();
    }
}

